/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT JOIN PERS_CARD pc ON t.ID = pc.PERSON_ID LEFT JOIN AUTH_DEPARTMENT d ON t.auth_dept_id = d.id")
@Where(after=" AND (pc.CARD_NO is null or pc.CARD_NO = '')")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class EleSelectPersonRadioItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(columnType="ra", width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="80")
    private String personPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="80")
    private String personName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="80")
    private String personLastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="65")
    private String cardNo;
    @Column(name="t.GENDER")
    @GridColumn(label="pers_person_gender", format="F=pers_person_female,M=pers_person_male,=---", sortNo=5, width="60", show=false)
    private String gender;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", sortNo=6, width="*")
    private String deptName;
    private String beginPin;
    private String endPin;
    private String type;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public EleSelectPersonRadioItem() {
    }

    public EleSelectPersonRadioItem(String id, String personPin, String personName, String personLastName, String cardNo, String gender, String deptName, String beginPin, String endPin) {
        this.id = id;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.cardNo = cardNo;
        this.gender = gender;
        this.deptName = deptName;
        this.beginPin = beginPin;
        this.endPin = endPin;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getGender() {
        return this.gender;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getBeginPin() {
        return this.beginPin;
    }

    public String getEndPin() {
        return this.endPin;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getUserId() {
        return this.userId;
    }

    public EleSelectPersonRadioItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleSelectPersonRadioItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public EleSelectPersonRadioItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public EleSelectPersonRadioItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public EleSelectPersonRadioItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public EleSelectPersonRadioItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public EleSelectPersonRadioItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public EleSelectPersonRadioItem setBeginPin(String beginPin) {
        this.beginPin = beginPin;
        return this;
    }

    public EleSelectPersonRadioItem setEndPin(String endPin) {
        this.endPin = endPin;
        return this;
    }

    public EleSelectPersonRadioItem setType(String type) {
        this.type = type;
        return this;
    }

    public EleSelectPersonRadioItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public EleSelectPersonRadioItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "EleSelectPersonRadioItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", cardNo=" + this.getCardNo() + ", gender=" + this.getGender() + ", deptName=" + this.getDeptName() + ", beginPin=" + this.getBeginPin() + ", endPin=" + this.getEndPin() + ", type=" + this.getType() + ", selectId=" + this.getSelectId() + ", userId=" + this.getUserId() + ")";
    }
}

