/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT JOIN PERS_CARD pc ON t.ID = pc.PERSON_ID LEFT JOIN AUTH_DEPARTMENT d ON t.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class EleSelectPersonItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    private String personId;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1)
    private String personPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="65")
    private String personName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="65")
    private String personLastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="65")
    private String cardNo;
    @Column(name="t.GENDER")
    @GridColumn(label="pers_person_gender", format="F=pers_person_female,M=pers_person_male,=---", sortNo=5, width="60", show=false)
    private String gender;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", sortNo=6, width="*")
    private String deptName;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;
    @Condition(value="t.ID NOT IN (SELECT elp.PERS_PERSON_ID FROM ELE_LEVEL_PERSON elp WHERE elp.LEVEL_ID=''{0}'')")
    private String levelId;
    @Condition(value="t.ID NOT IN (SELECT egp.PERS_PERSON_ID FROM ELE_GLOBALLINKAGE_PERSON egp WHERE egp.LINKAGE_ID=''{0}'')")
    private String globalLinkId;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String beginPin;
    private String endPin;
    private String type;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;
    @Deprecated
    private String linkId;
    @Deprecated
    private String modelType;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getGender() {
        return this.gender;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getGlobalLinkId() {
        return this.globalLinkId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getBeginPin() {
        return this.beginPin;
    }

    public String getEndPin() {
        return this.endPin;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    @Deprecated
    public String getLinkId() {
        return this.linkId;
    }

    @Deprecated
    public String getModelType() {
        return this.modelType;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public EleSelectPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleSelectPersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public EleSelectPersonItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public EleSelectPersonItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public EleSelectPersonItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public EleSelectPersonItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public EleSelectPersonItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public EleSelectPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public EleSelectPersonItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public EleSelectPersonItem setLevelId(String levelId) {
        this.levelId = levelId;
        return this;
    }

    public EleSelectPersonItem setGlobalLinkId(String globalLinkId) {
        this.globalLinkId = globalLinkId;
        return this;
    }

    public EleSelectPersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public EleSelectPersonItem setBeginPin(String beginPin) {
        this.beginPin = beginPin;
        return this;
    }

    public EleSelectPersonItem setEndPin(String endPin) {
        this.endPin = endPin;
        return this;
    }

    public EleSelectPersonItem setType(String type) {
        this.type = type;
        return this;
    }

    public EleSelectPersonItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    @Deprecated
    public EleSelectPersonItem setLinkId(String linkId) {
        this.linkId = linkId;
        return this;
    }

    @Deprecated
    public EleSelectPersonItem setModelType(String modelType) {
        this.modelType = modelType;
        return this;
    }

    public EleSelectPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }
}

