/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_READER t LEFT JOIN ELE_DEVICE ed ON ed.ID = t.DEV_ID ")
@OrderBy(after="ed.BUSINESS_ID ASC, t.READER_NO ASC")
@GridConfig(operate=true, idField="id", winHeight=530, winWidth=470, operates={@GridOperate(type="edit", permission="ele:reader:edit", url="eleReader.do?edit", label="common_op_edit")})
public class EleReaderItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(show=false, width="40")
    private String id;
    @Column(name="t.NAME")
    @GridColumn(label="ele_reader_name", width="200", columnType="edit", editUrl="eleReader.do?edit", editPermission="ele:reader:edit")
    private String name;
    @Column(name="ed.ID")
    private String deviceId;
    @Column(name="ed.DEV_ALIAS")
    @GridColumn(label="common_ownedDev", width="150")
    private String deviceAlias;
    @Column(name="t.ACTION_INTERVAL")
    @GridColumn(label="ele_reader_punchInterval", width="100")
    private Short actionInterval;
    @Column(name="t.VERIFY_MODE")
    private Short verifyMode;
    @GridColumn(label="common_verifyMode_entiy", width="120", columnType="custom", convert="eleConvertVerifyModeName")
    private String verifyModeName;
    @Column(name="t.READER_NO")
    @GridColumn(label="common_number")
    private Short readerNo;
    @Column(name="t.COMM_TYPE")
    @GridColumn(label="ele_reader_commType", width="100", format="0=ele_readerCommType_disable,1=ele_readerCommType_rs485,2=ele_readerCommType_wiegand,3=ele_readerCommType_wg485,4=ele_readerCommType_tcp")
    private Short commType;
    @Column(name="t.COMM_ADDRESS", equalTag="=")
    @GridColumn(label="ele_reader_commAddress", width="100")
    private Short commAddress;
    @Column(name="t.PERS_WIEGANDFMT_ID")
    private String persWiegandFmtId;
    @Condition(value="ed.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    @Column(name="ed.SN")
    private String deviceSn;
    @Column(name="t.IP")
    private String ip;
    @Column(name="t.PORT")
    private Short port;
    @Column(name="t.MAC")
    private String mac;
    @Column(name="t.MULTICAST")
    private String multicast;
    @Column(name="t.READER_ENCRYPT")
    private Boolean readerEncrypt;
    private String userInfoReveal;
    @Column(name="t.RS485_PROTOCOL_TYPE")
    private Short rs485ProtocolType;
    @Condition(value="ed.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public EleReaderItem() {
    }

    public EleReaderItem(Boolean equals) {
        super(equals);
    }

    public EleReaderItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public EleReaderItem(String id, String name, Short actionInterval, Short verifyMode) {
        this.id = id;
        this.name = name;
        this.actionInterval = actionInterval;
        this.verifyMode = verifyMode;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public Short getActionInterval() {
        return this.actionInterval;
    }

    public Short getVerifyMode() {
        return this.verifyMode;
    }

    public String getVerifyModeName() {
        return this.verifyModeName;
    }

    public Short getReaderNo() {
        return this.readerNo;
    }

    public Short getCommType() {
        return this.commType;
    }

    public Short getCommAddress() {
        return this.commAddress;
    }

    public String getPersWiegandFmtId() {
        return this.persWiegandFmtId;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getIp() {
        return this.ip;
    }

    public Short getPort() {
        return this.port;
    }

    public String getMac() {
        return this.mac;
    }

    public String getMulticast() {
        return this.multicast;
    }

    public Boolean getReaderEncrypt() {
        return this.readerEncrypt;
    }

    public String getUserInfoReveal() {
        return this.userInfoReveal;
    }

    public Short getRs485ProtocolType() {
        return this.rs485ProtocolType;
    }

    public String getUserId() {
        return this.userId;
    }

    public EleReaderItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleReaderItem setName(String name) {
        this.name = name;
        return this;
    }

    public EleReaderItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public EleReaderItem setDeviceAlias(String deviceAlias) {
        this.deviceAlias = deviceAlias;
        return this;
    }

    public EleReaderItem setActionInterval(Short actionInterval) {
        this.actionInterval = actionInterval;
        return this;
    }

    public EleReaderItem setVerifyMode(Short verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public EleReaderItem setVerifyModeName(String verifyModeName) {
        this.verifyModeName = verifyModeName;
        return this;
    }

    public EleReaderItem setReaderNo(Short readerNo) {
        this.readerNo = readerNo;
        return this;
    }

    public EleReaderItem setCommType(Short commType) {
        this.commType = commType;
        return this;
    }

    public EleReaderItem setCommAddress(Short commAddress) {
        this.commAddress = commAddress;
        return this;
    }

    public EleReaderItem setPersWiegandFmtId(String persWiegandFmtId) {
        this.persWiegandFmtId = persWiegandFmtId;
        return this;
    }

    public EleReaderItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public EleReaderItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public EleReaderItem setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public EleReaderItem setPort(Short port) {
        this.port = port;
        return this;
    }

    public EleReaderItem setMac(String mac) {
        this.mac = mac;
        return this;
    }

    public EleReaderItem setMulticast(String multicast) {
        this.multicast = multicast;
        return this;
    }

    public EleReaderItem setReaderEncrypt(Boolean readerEncrypt) {
        this.readerEncrypt = readerEncrypt;
        return this;
    }

    public EleReaderItem setUserInfoReveal(String userInfoReveal) {
        this.userInfoReveal = userInfoReveal;
        return this;
    }

    public EleReaderItem setRs485ProtocolType(Short rs485ProtocolType) {
        this.rs485ProtocolType = rs485ProtocolType;
        return this;
    }

    public EleReaderItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

