/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_LEVEL_PERSON t LEFT JOIN PERS_PERSON p on t.PERS_PERSON_ID = p.ID LEFT JOIN PERS_CARD pc on p.ID = pc.PERSON_ID LEFT JOIN AUTH_DEPARTMENT d on p.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class ElePersonListItem
extends BaseItem {
    @Column(name="p.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="p.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="p.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="100", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="100", sort="na", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", sortNo=5, width="150", sort="na")
    private String deptName;
    @Column(name="p.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;
    @Deprecated
    private String linkId;
    @Deprecated
    private String modelType;
    @Condition(value="(LOWER (p.NAME) LIKE LOWER (''%{0}%'') OR LOWER (p.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Column(name="t.LEVEL_ID")
    private String levelId;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    @Deprecated
    public String getLinkId() {
        return this.linkId;
    }

    @Deprecated
    public String getModelType() {
        return this.modelType;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPersonPin(String personPin) {
        this.personPin = personPin;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public void setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
    }

    @Deprecated
    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    @Deprecated
    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setLikeName(String likeName) {
        this.likeName = likeName;
    }

    public void setLevelId(String levelId) {
        this.levelId = levelId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

