/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT join PERS_CARD pc on t.ID = pc.PERSON_ID LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="select", permission="ele:personLevelByPerson:addLevel", url="skip.do?page=ele_personLevelByPerson_personSelectLevelContent&personId=(id)&personPin=(pin)", label="common_level_addPersonLevel", click="elePersonAfterAddLevel")})
public class ElePersonLevelByPersonItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="90", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="80", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="80", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="95", sort="na", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNos;
    @Condition(value="(LOWER (pc.CARD_NO) LIKE LOWER (''%{0}%''))", encryptConverter=true)
    private String likeCardNo;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", sortNo=5, width="120", sort="na")
    private String deptName;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public ElePersonLevelByPersonItem() {
    }

    public ElePersonLevelByPersonItem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCardNos() {
        return this.cardNos;
    }

    public String getLikeCardNo() {
        return this.likeCardNo;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public ElePersonLevelByPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public ElePersonLevelByPersonItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public ElePersonLevelByPersonItem setName(String name) {
        this.name = name;
        return this;
    }

    public ElePersonLevelByPersonItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public ElePersonLevelByPersonItem setCardNos(String cardNos) {
        this.cardNos = cardNos;
        return this;
    }

    public ElePersonLevelByPersonItem setLikeCardNo(String likeCardNo) {
        this.likeCardNo = likeCardNo;
        return this;
    }

    public ElePersonLevelByPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public ElePersonLevelByPersonItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public ElePersonLevelByPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public ElePersonLevelByPersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

