/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_LEVEL t LEFT JOIN AUTH_AREA a ON t.AUTH_AREA_ID = a.ID LEFT JOIN ELE_TIMESEG e ON t.TIMESEG_ID = e.ID ")
@OrderBy(after="t.CREATE_TIME ASC")
@GridConfig(operate=true, idField="id", winHeight=200, winWidth=400, operates={@GridOperate(type="edit", permission="ele:level:edit", url="eleLevel.do?edit", label="common_op_edit"), @GridOperate(type="custom", permission="ele:level:addFloor", label="ele_level_addFloor", click="eleLevelAddFloor")})
public class EleLevelItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(columnType="edit", label="common_level_name", width="110", sortNo=1)
    private String name;
    @Column(name="a.NAME")
    @GridColumn(label="base_area_name", width="80", sortNo=2)
    private String authAreaName;
    @Column(name="t.AUTH_AREA_ID")
    @GridColumn(show=false)
    private String authAreaId;
    @Column(name="e.NAME")
    @GridColumn(label="ele_timeSeg_entity", width="80", sortNo=3)
    private String timeSegName;
    @Condition(value="(LOWER (e.NAME) LIKE LOWER (''%{0}%''))")
    private String likeTimeSegName;
    @Column(name="e.ID")
    @GridColumn(show=false)
    private String timeSegId;
    @Column(name="(SELECT COUNT(*) FROM ELE_LEVEL_FLOOR f WHERE f.LEVEL_ID = t.ID)")
    @GridColumn(label="ele_level_floorCount", width="80", sortNo=4)
    private String floorCount;
    @Column(name="t.INIT_FLAG")
    private Boolean initFlag;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    private Boolean changeLevel;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String areaIds;
    @Condition(value="a.ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String authAreaCode;

    public EleLevelItem() {
    }

    public EleLevelItem(Boolean equals) {
        super(equals);
    }

    public EleLevelItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public EleLevelItem(String id, String name, String authAreaName, String authAreaId, String timeSegName, String timeSegId, String floorCount) {
        this.id = id;
        this.name = name;
        this.authAreaName = authAreaName;
        this.authAreaId = authAreaId;
        this.timeSegName = timeSegName;
        this.timeSegId = timeSegId;
        this.floorCount = floorCount;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getTimeSegName() {
        return this.timeSegName;
    }

    public String getLikeTimeSegName() {
        return this.likeTimeSegName;
    }

    public String getTimeSegId() {
        return this.timeSegId;
    }

    public String getFloorCount() {
        return this.floorCount;
    }

    public Boolean getInitFlag() {
        return this.initFlag;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public Boolean getChangeLevel() {
        return this.changeLevel;
    }

    public String getAreaIds() {
        return this.areaIds;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAuthAreaCode() {
        return this.authAreaCode;
    }

    public EleLevelItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleLevelItem setName(String name) {
        this.name = name;
        return this;
    }

    public EleLevelItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public EleLevelItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public EleLevelItem setTimeSegName(String timeSegName) {
        this.timeSegName = timeSegName;
        return this;
    }

    public EleLevelItem setLikeTimeSegName(String likeTimeSegName) {
        this.likeTimeSegName = likeTimeSegName;
        return this;
    }

    public EleLevelItem setTimeSegId(String timeSegId) {
        this.timeSegId = timeSegId;
        return this;
    }

    public EleLevelItem setFloorCount(String floorCount) {
        this.floorCount = floorCount;
        return this;
    }

    public EleLevelItem setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
        return this;
    }

    public EleLevelItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public EleLevelItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public EleLevelItem setChangeLevel(Boolean changeLevel) {
        this.changeLevel = changeLevel;
        return this;
    }

    public EleLevelItem setAreaIds(String areaIds) {
        this.areaIds = areaIds;
        return this;
    }

    public EleLevelItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public EleLevelItem setAuthAreaCode(String authAreaCode) {
        this.authAreaCode = authAreaCode;
        return this;
    }
}

