/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_FLOOR t LEFT JOIN ELE_DEVICE ed ON t.DEV_ID = ed.ID LEFT JOIN ELE_LEVEL_FLOOR f ON f.FLOOR_ID = t.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class EleLevelFloorItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.FLOOR_NO")
    @GridColumn(label="ele_floor_number", sortNo=1, width="170")
    private Short floorNo;
    @Column(name="t.FLOOR_NO_EX")
    @GridColumn(label="ele_floor_entity", sortNo=2, width="170")
    private Short floorNoEx;
    @Column(name="t.NAME")
    @GridColumn(label="ele_floor_name", sortNo=3, width="*")
    private String name;
    @Column(name="f.LEVEL_ID")
    @GridColumn(show=false)
    private String levelId;
    @Column(name="t.ID", equalTag="in")
    private String inId;
    @Column(name="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="ed.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String eleLevelName;
    private String doorNo;
    private String deviceSn;

    public EleLevelFloorItem() {
    }

    public EleLevelFloorItem(Boolean equals) {
        super(equals);
    }

    public EleLevelFloorItem(String id) {
        this.id = id;
    }

    public EleLevelFloorItem(String id, Short floorNo, String name, String levelId) {
        this.id = id;
        this.floorNo = floorNo;
        this.name = name;
        this.levelId = levelId;
    }

    public String getId() {
        return this.id;
    }

    public Short getFloorNo() {
        return this.floorNo;
    }

    public Short getFloorNoEx() {
        return this.floorNoEx;
    }

    public String getName() {
        return this.name;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEleLevelName() {
        return this.eleLevelName;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public EleLevelFloorItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleLevelFloorItem setFloorNo(Short floorNo) {
        this.floorNo = floorNo;
        return this;
    }

    public EleLevelFloorItem setFloorNoEx(Short floorNoEx) {
        this.floorNoEx = floorNoEx;
        return this;
    }

    public EleLevelFloorItem setName(String name) {
        this.name = name;
        return this;
    }

    public EleLevelFloorItem setLevelId(String levelId) {
        this.levelId = levelId;
        return this;
    }

    public EleLevelFloorItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public EleLevelFloorItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public EleLevelFloorItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public EleLevelFloorItem setEleLevelName(String eleLevelName) {
        this.eleLevelName = eleLevelName;
        return this;
    }

    public EleLevelFloorItem setDoorNo(String doorNo) {
        this.doorNo = doorNo;
        return this;
    }

    public EleLevelFloorItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }
}

