/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT join ELE_GLOBALLINKAGE_PERSON egp on egp.PERS_PERSON_ID = t.ID LEFT join PERS_CARD pc on t.ID = pc.PERSON_ID LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600, operates={})
public class EleGlobalLinkagePersonItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @GridColumn(show=false)
    private String personId;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="100", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="100", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", sortNo=5, width="120")
    private String deptName;
    @Column(name="egp.LINKAGE_ID")
    @GridColumn(show=false)
    private String globalLinkageId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public EleGlobalLinkagePersonItem() {
    }

    public EleGlobalLinkagePersonItem(Boolean equals) {
        super(equals);
    }

    public EleGlobalLinkagePersonItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public EleGlobalLinkagePersonItem(String id, String personId, String personPin, String personName, String cardNo, String deptName) {
        this.id = id;
        this.personId = personId;
        this.personPin = personPin;
        this.personName = personName;
        this.cardNo = cardNo;
        this.deptName = deptName;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getGlobalLinkageId() {
        return this.globalLinkageId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public EleGlobalLinkagePersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleGlobalLinkagePersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public EleGlobalLinkagePersonItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public EleGlobalLinkagePersonItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public EleGlobalLinkagePersonItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public EleGlobalLinkagePersonItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public EleGlobalLinkagePersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public EleGlobalLinkagePersonItem setGlobalLinkageId(String globalLinkageId) {
        this.globalLinkageId = globalLinkageId;
        return this;
    }

    public EleGlobalLinkagePersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public EleGlobalLinkagePersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

