/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_EXTERNAL_READER t LEFT JOIN ELE_FLOOR f on f.ID=t.FLOOR_ID LEFT JOIN ELE_SERVICE_CONFIG c on c.ID = f.SERVICE_CONFIG_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=450, winWidth=500, operates={@GridOperate(type="edit", permission="ele:externalReader:edit", url="/eleExternalReader.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="ele:externalReader:del", url="/eleExternalReader.do?delete&ids=(id)&name=(name)", label="common_op_del"), @GridOperate(type="custom", permission="ele:externalReader:specificMask", click="eleEditExternalReaderSpecificMask", label="ele_mask_externalSpecificMask", filter="eleShowExternalSpecificMask"), @GridOperate(type="custom", permission="ele:externalReader:clearMask", click="eleClearExternalReaderSpecificMask", label="ele_mask_clearSpecificMask", filter="eleShowExternalSpecificMask")})
public class EleExternalReaderItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @GridColumn(columnType="edit", label="ele_reader_name", width="120", editPermission="ele:externalReader:edit")
    @Column(name="t.NAME")
    private String name;
    @GridColumn(label="ele_serviceConfig_name", width="140")
    @Column(name="c.NAME")
    private String serviceConfigName;
    @GridColumn(label="ele_manufacturer", width="120", columnType="custom", convert="convertEleManufacturer")
    @Column(name="t.MANUFACTURER")
    private String manufacturer;
    @GridColumn(label="ele_external_callType", width="120", i18n=true, format="-32766=ele_external_normalCall,-32768=ele_external_RCGIFCall,0=ele_external_manualCall,1=ele_external_autoCall")
    @Column(name="t.CALL_TYPE")
    private String callType;
    @Column(name="t.SOURCE_SIDE")
    private String sourceSide;
    @Column(name="t.INTEGRATION_DEVICE_ID")
    private String integrationDeviceId;
    @Column(name="t.DEVICE_READER_ID")
    private String deviceReaderId;
    @GridColumn(label="ele_external_deviceReader", width="130")
    @Column(name="t.DEVICE_READER_NAME")
    private String deviceReaderName;
    @GridColumn(label="ele_external_terminalId", width="100")
    @Column(name="t.TERMINAL_ID", equalTag="=")
    private String terminalId;
    @Column(name="t.FLOOR_ID")
    private String floorId;
    @Column(name="f.NAME")
    @GridColumn(label="ele_floor_name", width="140")
    private String floorName;
    @Column(name="f.FLOOR_NO")
    private Short floorNo;
    @Column(name="c.ID")
    private String serviceConfigId;
    @Column(name="t.OPEN_TIMEOUT")
    private Short openTimeout;
    @Column(name="t.ELEVATOR_GROUP_ID")
    private String elevatorGroupId;
    @Column(name="t.VERIFICATION_LOCATION")
    private Short verificationLocation;
    @Column(name="t.BUTTON_ATTRIBUTE")
    private Short buttonAttribute;
    @Column(name="t.CALL_REGISTRATION_MODE")
    private Short callRegistrationMode;
    @Column(name="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="c.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.ELEVATOR_GROUP_ID", equalTag="in")
    private String elevatorGroupIdIn;

    public EleExternalReaderItem() {
    }

    public EleExternalReaderItem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceConfigName() {
        return this.serviceConfigName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getCallType() {
        return this.callType;
    }

    public String getSourceSide() {
        return this.sourceSide;
    }

    public String getIntegrationDeviceId() {
        return this.integrationDeviceId;
    }

    public String getDeviceReaderId() {
        return this.deviceReaderId;
    }

    public String getDeviceReaderName() {
        return this.deviceReaderName;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public String getFloorId() {
        return this.floorId;
    }

    public String getFloorName() {
        return this.floorName;
    }

    public Short getFloorNo() {
        return this.floorNo;
    }

    public String getServiceConfigId() {
        return this.serviceConfigId;
    }

    public Short getOpenTimeout() {
        return this.openTimeout;
    }

    public String getElevatorGroupId() {
        return this.elevatorGroupId;
    }

    public Short getVerificationLocation() {
        return this.verificationLocation;
    }

    public Short getButtonAttribute() {
        return this.buttonAttribute;
    }

    public Short getCallRegistrationMode() {
        return this.callRegistrationMode;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getElevatorGroupIdIn() {
        return this.elevatorGroupIdIn;
    }

    public EleExternalReaderItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleExternalReaderItem setName(String name) {
        this.name = name;
        return this;
    }

    public EleExternalReaderItem setServiceConfigName(String serviceConfigName) {
        this.serviceConfigName = serviceConfigName;
        return this;
    }

    public EleExternalReaderItem setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    public EleExternalReaderItem setCallType(String callType) {
        this.callType = callType;
        return this;
    }

    public EleExternalReaderItem setSourceSide(String sourceSide) {
        this.sourceSide = sourceSide;
        return this;
    }

    public EleExternalReaderItem setIntegrationDeviceId(String integrationDeviceId) {
        this.integrationDeviceId = integrationDeviceId;
        return this;
    }

    public EleExternalReaderItem setDeviceReaderId(String deviceReaderId) {
        this.deviceReaderId = deviceReaderId;
        return this;
    }

    public EleExternalReaderItem setDeviceReaderName(String deviceReaderName) {
        this.deviceReaderName = deviceReaderName;
        return this;
    }

    public EleExternalReaderItem setTerminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    public EleExternalReaderItem setFloorId(String floorId) {
        this.floorId = floorId;
        return this;
    }

    public EleExternalReaderItem setFloorName(String floorName) {
        this.floorName = floorName;
        return this;
    }

    public EleExternalReaderItem setFloorNo(Short floorNo) {
        this.floorNo = floorNo;
        return this;
    }

    public EleExternalReaderItem setServiceConfigId(String serviceConfigId) {
        this.serviceConfigId = serviceConfigId;
        return this;
    }

    public EleExternalReaderItem setOpenTimeout(Short openTimeout) {
        this.openTimeout = openTimeout;
        return this;
    }

    public EleExternalReaderItem setElevatorGroupId(String elevatorGroupId) {
        this.elevatorGroupId = elevatorGroupId;
        return this;
    }

    public EleExternalReaderItem setVerificationLocation(Short verificationLocation) {
        this.verificationLocation = verificationLocation;
        return this;
    }

    public EleExternalReaderItem setButtonAttribute(Short buttonAttribute) {
        this.buttonAttribute = buttonAttribute;
        return this;
    }

    public EleExternalReaderItem setCallRegistrationMode(Short callRegistrationMode) {
        this.callRegistrationMode = callRegistrationMode;
        return this;
    }

    public EleExternalReaderItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public EleExternalReaderItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public EleExternalReaderItem setElevatorGroupIdIn(String elevatorGroupIdIn) {
        this.elevatorGroupIdIn = elevatorGroupIdIn;
        return this;
    }
}

