/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_EXT_BOARD t LEFT JOIN ELE_DEVICE ed ON ed.ID = t.DEV_ID LEFT JOIN AUTH_AREA aa ON aa.ID = ed.AUTH_AREA_ID")
@OrderBy(after="t.CREATE_TIME ASC")
@GridConfig(operate=true, idField="id", winHeight=300, winWidth=460, minWidth="170", operates={@GridOperate(type="edit", permission="ele:extBoard:edit", url="eleExtBoard.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="ele:extBoard:del", url="eleExtBoard.do?del&aliases=(alias)", label="common_op_del")})
public class EleExtBoardItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.ALIAS")
    @GridColumn(label="common_name", width="100", columnType="edit", sortNo=1, editUrl="/eleExtBoard.do?edit", editPermission="acc:auxIn:edit")
    private String alias;
    @Column(name="aa.ID", equalTag="=")
    private String authAreaId;
    @Column(name="aa.NAME")
    @GridColumn(label="base_area_name", width="100", sortNo=2, sort="na")
    private String authAreaName;
    @Column(name="ed.id")
    private String devId;
    @Column(name="ed.DEV_ALIAS")
    @GridColumn(label="common_ownedDev", width="120", sortNo=4)
    private String devAlias;
    @Column(name="ed.sn")
    @GridColumn(label="common_dev_sn", sortNo=5, width="120")
    private String devSn;
    @Column(name="t.PROTOCOL_TYPE")
    private Short protocolType;
    @Column(name="t.EXT_BOARD_NO")
    private String extBoardNo;
    @Column(name="t.EXT_BOARD_TYPE")
    @GridColumn(label="ele_extBoard_type", width="160", columnType="custom", convert="convertExtBoardType")
    private Short extBoardType;
    @Column(name="t.COMM_ADDRESS")
    @GridColumn(label="common_dev_rs485Address", width="120")
    private String commAddress;
    @Condition(value="ed.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    private String type;
    @Condition(value="aa.ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public EleExtBoardItem() {
    }

    public EleExtBoardItem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getDevId() {
        return this.devId;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public Short getProtocolType() {
        return this.protocolType;
    }

    public String getExtBoardNo() {
        return this.extBoardNo;
    }

    public Short getExtBoardType() {
        return this.extBoardType;
    }

    public String getCommAddress() {
        return this.commAddress;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public EleExtBoardItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleExtBoardItem setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public EleExtBoardItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public EleExtBoardItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public EleExtBoardItem setDevId(String devId) {
        this.devId = devId;
        return this;
    }

    public EleExtBoardItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public EleExtBoardItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public EleExtBoardItem setProtocolType(Short protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public EleExtBoardItem setExtBoardNo(String extBoardNo) {
        this.extBoardNo = extBoardNo;
        return this;
    }

    public EleExtBoardItem setExtBoardType(Short extBoardType) {
        this.extBoardType = extBoardType;
        return this;
    }

    public EleExtBoardItem setCommAddress(String commAddress) {
        this.commAddress = commAddress;
        return this;
    }

    public EleExtBoardItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public EleExtBoardItem setType(String type) {
        this.type = type;
        return this;
    }

    public EleExtBoardItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "EleExtBoardItem(id=" + this.getId() + ", alias=" + this.getAlias() + ", authAreaId=" + this.getAuthAreaId() + ", authAreaName=" + this.getAuthAreaName() + ", devId=" + this.getDevId() + ", devAlias=" + this.getDevAlias() + ", devSn=" + this.getDevSn() + ", protocolType=" + this.getProtocolType() + ", extBoardNo=" + this.getExtBoardNo() + ", extBoardType=" + this.getExtBoardType() + ", commAddress=" + this.getCommAddress() + ", areaIdIn=" + this.getAreaIdIn() + ", type=" + this.getType() + ", userId=" + this.getUserId() + ")";
    }
}

