/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_DIRECT_SELECTION t LEFT JOIN ELE_DEVICE ed ON t.DEV_ID = ed.ID")
@OrderBy(after="t.CREATE_TIME ASC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class EleDirectSelectionItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @Column(name="t.PERS_PERSON_PIN", equalTag="=")
    private String personPin;
    @Column(name="t.PERS_PERSON_ID", equalTag="=")
    private String personId;
    @Column(name="ed.DEV_ALIAS")
    @GridColumn(label="ele_dev_device", width="120")
    private String deviceName;
    @Condition(value="(LOWER (ed.DEV_ALIAS) LIKE LOWER (''%{0}%''))")
    private String likeDeviceName;
    @Column(name="t.DEV_ID")
    private String deviceId;
    @Column(name="ed.BUSINESS_ID")
    private Long businessId;
    @Column(name="t.DIRECT_FLOOR_NO")
    private Short directFloorNo;
    @GridColumn(label="ele_directSelection_directFloor", width="110")
    private String directFloorName;
    @Column(name="t.SELECTION_FLOOR_NOS")
    private String selectionFloorNos;
    private String selectionFloorIds;
    @GridColumn(label="ele_directSelection_otherFloor", width="100")
    private String selectionFloorNames;
    @GridColumn(label="ele_timeSeg_entity", width="120")
    private String timeSegName;
    @Column(name="t.TIMESEG_ID")
    private String timeSegId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;

    public EleDirectSelectionItem() {
    }

    public EleDirectSelectionItem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getLikeDeviceName() {
        return this.likeDeviceName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public Long getBusinessId() {
        return this.businessId;
    }

    public Short getDirectFloorNo() {
        return this.directFloorNo;
    }

    public String getDirectFloorName() {
        return this.directFloorName;
    }

    public String getSelectionFloorNos() {
        return this.selectionFloorNos;
    }

    public String getSelectionFloorIds() {
        return this.selectionFloorIds;
    }

    public String getSelectionFloorNames() {
        return this.selectionFloorNames;
    }

    public String getTimeSegName() {
        return this.timeSegName;
    }

    public String getTimeSegId() {
        return this.timeSegId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public EleDirectSelectionItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleDirectSelectionItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public EleDirectSelectionItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public EleDirectSelectionItem setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public EleDirectSelectionItem setLikeDeviceName(String likeDeviceName) {
        this.likeDeviceName = likeDeviceName;
        return this;
    }

    public EleDirectSelectionItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public EleDirectSelectionItem setBusinessId(Long businessId) {
        this.businessId = businessId;
        return this;
    }

    public EleDirectSelectionItem setDirectFloorNo(Short directFloorNo) {
        this.directFloorNo = directFloorNo;
        return this;
    }

    public EleDirectSelectionItem setDirectFloorName(String directFloorName) {
        this.directFloorName = directFloorName;
        return this;
    }

    public EleDirectSelectionItem setSelectionFloorNos(String selectionFloorNos) {
        this.selectionFloorNos = selectionFloorNos;
        return this;
    }

    public EleDirectSelectionItem setSelectionFloorIds(String selectionFloorIds) {
        this.selectionFloorIds = selectionFloorIds;
        return this;
    }

    public EleDirectSelectionItem setSelectionFloorNames(String selectionFloorNames) {
        this.selectionFloorNames = selectionFloorNames;
        return this;
    }

    public EleDirectSelectionItem setTimeSegName(String timeSegName) {
        this.timeSegName = timeSegName;
        return this;
    }

    public EleDirectSelectionItem setTimeSegId(String timeSegId) {
        this.timeSegId = timeSegId;
        return this;
    }

    public EleDirectSelectionItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public EleDirectSelectionItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }
}

