/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ELE_DEVICE_EVENT t LEFT JOIN ELE_DEVICE ed ON ed.ID = t.DEV_ID")
@OrderBy(after="ed.CREATE_TIME ASC, t.EVENT_NO ASC")
@GridConfig
public class EleDeviceEventItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(show=false)
    private String id;
    @Column(name="t.NAME", equalTag="in")
    @GridColumn(label="common_event_name", width="270", i18n=true)
    private String name;
    @Column(name="t.EVENT_NO")
    @GridColumn(label="common_event_number", width="150")
    private Short eventNo;
    @Column(name="t.EVENT_LEVEL")
    @GridColumn(label="common_event_level", columnType="custom", convert="convertToWordWithColor", width="150")
    private Short eventLevel;
    @Column(name="ed.ID")
    private String deviceId;
    @Column(name="ed.DEV_ALIAS")
    @GridColumn(label="common_dev_name", width="150")
    private String deviceAlias;
    @Column(name="ed.SN")
    @GridColumn(label="common_dev_sn", width="*")
    private String deviceSn;
    @Condition(value="ed.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    @Condition(value="ed.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public EleDeviceEventItem() {
    }

    public EleDeviceEventItem(Boolean equals) {
        super(equals);
    }

    public EleDeviceEventItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public EleDeviceEventItem(String id, Short eventNo, String name, Short eventLevel) {
        this.id = id;
        this.eventNo = eventNo;
        this.name = name;
        this.eventLevel = eventLevel;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Short getEventNo() {
        return this.eventNo;
    }

    public Short getEventLevel() {
        return this.eventLevel;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getUserId() {
        return this.userId;
    }

    public EleDeviceEventItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleDeviceEventItem setName(String name) {
        this.name = name;
        return this;
    }

    public EleDeviceEventItem setEventNo(Short eventNo) {
        this.eventNo = eventNo;
        return this;
    }

    public EleDeviceEventItem setEventLevel(Short eventLevel) {
        this.eventLevel = eventLevel;
        return this;
    }

    public EleDeviceEventItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public EleDeviceEventItem setDeviceAlias(String deviceAlias) {
        this.deviceAlias = deviceAlias;
        return this;
    }

    public EleDeviceEventItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public EleDeviceEventItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public EleDeviceEventItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

