/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ELE_CARD t LEFT JOIN PERS_PERSON p ON t.PERSON_PIN=p.PIN LEFT join AUTH_DEPARTMENT d on p.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class EleCardItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @Column(name="t.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", width="100", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="t.CARD_TYPE")
    @GridColumn(label="ele_offline_cardKind", format="8=ele_offline_icCard,24=ele_offline_icCard,32=ele_offline_cpuCard,40=ele_offline_cpuCard")
    private Short cardType;
    @Column(name="t.CARD_KIND")
    @GridColumn(label="ele_offline_cardType", format="0=,1=ele_offline_configCard,2=ele_offline_userCard,3=ele_offline_lossCard,4=ele_offline_readerConfigCard", width="100")
    private Short cardKind;
    @Column(name="t.PERSON_ID")
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="p.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Column(name="d.CODE")
    @GridColumn(label="pers_dept_deptNo", sort="na")
    private String deptCode;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_deptName", width="160", sort="na")
    private String deptName;
    @GridColumn(label="ele_dev_eleLevel", width="200")
    private String authorizeFloor;
    @Column(name="t.CARD_STATE")
    @GridColumn(label="pers_card_state", columnType="custom", convert="convertEleCardState")
    private String cardState;
    @Column(name="t.UPDATE_TIME")
    @GridColumn(label="pers_issueCard_date", width="140")
    private Date issueTime;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public String getId() {
        return this.id;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Short getCardType() {
        return this.cardType;
    }

    public Short getCardKind() {
        return this.cardKind;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getAuthorizeFloor() {
        return this.authorizeFloor;
    }

    public String getCardState() {
        return this.cardState;
    }

    public Date getIssueTime() {
        return this.issueTime;
    }

    public String getUserId() {
        return this.userId;
    }

    public EleCardItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleCardItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public EleCardItem setCardType(Short cardType) {
        this.cardType = cardType;
        return this;
    }

    public EleCardItem setCardKind(Short cardKind) {
        this.cardKind = cardKind;
        return this;
    }

    public EleCardItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public EleCardItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public EleCardItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public EleCardItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public EleCardItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public EleCardItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public EleCardItem setAuthorizeFloor(String authorizeFloor) {
        this.authorizeFloor = authorizeFloor;
        return this;
    }

    public EleCardItem setCardState(String cardState) {
        this.cardState = cardState;
        return this;
    }

    public EleCardItem setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
        return this;
    }

    public EleCardItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

