/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT JOIN PERS_CARD pc ON t.ID = pc.PERSON_ID LEFT JOIN AUTH_DEPARTMENT d ON t.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class EleCardBusinessSelectPersonRadioItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(columnType="ra", width="40")
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="65")
    private String personName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", width="65")
    private String personLastName;
    @Column(name="pc.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", width="65")
    private String cardNo;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String type;
    private String selectId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public EleCardBusinessSelectPersonRadioItem setId(String id) {
        this.id = id;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setType(String type) {
        this.type = type;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public EleCardBusinessSelectPersonRadioItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }
}

