/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.whatsapp.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=340)
public class WhatsappInit
implements CommandLineRunner {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthPermissionService authPermissionService;

    public void run(String ... strings) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("WhatsappInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initWhatsappParams();
            this.initLicense();
            this.baseSysParamService.setAlreadyInitModule("WhatsappInit");
        }
    }

    private void initLicense() {
        BaseSysParamItem item = new BaseSysParamItem("whatsapp.version", "true", "whatsapp", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
    }

    private void initAuthPermission() {
        AuthPermissionItem subMenuItem1;
        AuthPermissionItem systemItem = this.authPermissionService.getItemByCode("System");
        if (systemItem == null) {
            systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(999));
            systemItem = this.authPermissionService.initData(systemItem);
        }
        if ((subMenuItem1 = this.authPermissionService.getItemByCode("ThirdPartyDocking")) == null) {
            subMenuItem1 = new AuthPermissionItem("ThirdPartyDocking", "base_leftMenu_thirdParty", "third:party:docking", "menu", "true", Integer.valueOf(4));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setImg("base_extendManage.png");
            subMenuItem1.setImgHover("base_extendManage.png");
            subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        }
        AuthPermissionItem subMenuItem = new AuthPermissionItem("WhatsappManagement", "whatsapp_menu", "whatsapp:management", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("whatsappParams.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
    }

    private void initWhatsappParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("whatsapp.rapiwha.apikey", "", "WhatsApp RAPIWHA ApiKey"));
        this.baseSysParamService.initData(new BaseSysParamItem("whatsapp.twilio.sid", "", "WhatsApp Twilio SID"));
        this.baseSysParamService.initData(new BaseSysParamItem("whatsapp.twilio.token", "", "WhatsApp Twilio Token"));
        this.baseSysParamService.initData(new BaseSysParamItem("whatsapp.twilio.from", "", "WhatsApp Twilio \u53d1\u9001\u8005\u53f7\u7801"));
        this.baseSysParamService.initData(new BaseSysParamItem("whatsapp.webhookUrl", "", "WhatsApp \u7528\u4e8e\u63a5\u6536\u6d88\u606f\u7684\u56de\u8c03\u94fe\u63a5"));
        this.baseSysParamService.initData(new BaseSysParamItem("whatsapp.solutionProvider", "", "WhatsApp\u89e3\u51b3\u65b9\u6848\u63d0\u4f9b\u5546"));
    }
}

