/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web.listener;

import com.zkteco.zkbiosecurity.core.config.PropertiesListenerConfig;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.web.bean.SystemProperties;
import com.zkteco.zkbiosecurity.core.web.cache.SkinPropertyCache;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
public class SettingDataInitListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(SettingDataInitListener.class);

    public void onApplicationEvent(ContextRefreshedEvent event) {
        WebApplicationContext webApplicationContext = (WebApplicationContext)event.getApplicationContext();
        ServletContext servletContext = webApplicationContext.getServletContext();
        SkinPropertyCache.init();
        Set<String> propNames = SystemProperties.getKeys();
        Map<String, String> systemPropertyMap = PropertiesListenerConfig.getSystemProperty();
        for (String propName : propNames) {
            String value;
            String string = value = systemPropertyMap.containsKey(propName) ? systemPropertyMap.get(propName) : SpringContextUtil.getApplicationContext().getEnvironment().getProperty(propName);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            try {
                if (this.isISO88591(value)) {
                    servletContext.setAttribute(propName, (Object)new String(value.getBytes("ISO-8859-1"), "UTF-8"));
                    continue;
                }
                servletContext.setAttribute(propName, (Object)value);
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private boolean isISO88591(String s) throws UnsupportedEncodingException {
        return StringUtils.equals((CharSequence)new String(s.getBytes("ISO-8859-1"), "ISO-8859-1"), (CharSequence)s);
    }
}

