/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web.filter;

import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.web.cache.SkinPropertyCache;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@WebFilter(urlPatterns={"/*"}, filterName="springPropertyFilter")
public class SpringPropertyFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SpringPropertyFilter.class);
    @Value(value="${system.keepSkin:true}")
    private Boolean keepSkin;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        this.setRequestParamToAttribute(request, "leftHide");
        this.setRequestParamToAttribute(request, "topHide");
        this.setRequestParamToAttribute(request, "leftMenuHide");
        this.setRequestParamToAttribute(request, "selectSysCode");
        this.setRequestParamToAttribute(request, "selectMenuId");
        this.setRequestParamToAttribute(request, "structType");
        this.resolveSkin(request);
        chain.doFilter((ServletRequest)request, response);
    }

    private void resolveSkin(HttpServletRequest request) {
        String skin = request.getParameter("systemSkin");
        if (StringUtils.isNotBlank((CharSequence)skin)) {
            SkinPropertyCache.changeClientSkin(skin);
        }
        if (this.keepSkin.booleanValue()) {
            ServletContext ctx = request.getServletContext();
            String string = skin = StringUtils.isNotBlank((CharSequence)skin) ? skin : SkinPropertyCache.getClientSkin();
            if (StringUtils.isNotBlank((CharSequence)skin) && !skin.equals(ctx.getAttribute("system.skin"))) {
                SkinPropertyCache.loadSkinToApplication(skin, request);
            }
        }
    }

    private void setRequestParamToAttribute(HttpServletRequest request, String propName) {
        String paramValue = request.getParameter(propName);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            paramValue = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system." + propName);
        }
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            request.setAttribute(propName, (Object)paramValue);
        }
    }

    public void destroy() {
    }
}

