/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web.cache;

import com.zkteco.zkbiosecurity.core.utils.ResourceUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SkinPropertyCache {
    private static final Logger log = LoggerFactory.getLogger(SkinPropertyCache.class);
    private static Map<String, Map<String, String>> propMap;
    private static Map<String, String> clientSkin;

    public static void init() {
        SkinPropertyCache.loadSkinProperties();
        SkinPropertyCache.loadClientSkin();
    }

    private static void loadClientSkin() {
        Set keys;
        StringRedisTemplate stringRedisTemplate;
        if (Objects.isNull(clientSkin)) {
            clientSkin = new HashMap<String, String>();
        }
        if (Objects.nonNull(stringRedisTemplate = (StringRedisTemplate)SpringContextUtil.getBean(StringRedisTemplate.class)) && Objects.nonNull(keys = stringRedisTemplate.keys((Object)"system:skin:client:*"))) {
            for (String key : keys) {
                String val = (String)stringRedisTemplate.opsForValue().get((Object)key);
                clientSkin.put(key, val);
            }
        }
    }

    private static String getDefaultClientSkin() {
        return SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.skin");
    }

    public static void changeClientSkin(String skin) {
        String key = SkinPropertyCache.getClientKey();
        SkinPropertyCache.changeClientSkin(key, skin);
    }

    public static void changeClientSkin(String key, String skin) {
        clientSkin.put(key, skin);
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringContextUtil.getBean(StringRedisTemplate.class);
        if (Objects.nonNull(stringRedisTemplate)) {
            stringRedisTemplate.opsForValue().set((Object)key, (Object)skin);
        }
    }

    public static String getClientSkin() {
        String skin = null;
        if (Objects.nonNull(clientSkin)) {
            String key = SkinPropertyCache.getClientKey();
            skin = clientSkin.get(key);
        }
        return StringUtils.isBlank(skin) ? SkinPropertyCache.getDefaultClientSkin() : skin;
    }

    public static String getProperty(String propName) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        return SkinPropertyCache.getProperty(propName, request);
    }

    public static String getProperty(String propName, HttpServletRequest request) {
        if (Objects.isNull(clientSkin)) {
            SkinPropertyCache.init();
        }
        if (Objects.nonNull(request)) {
            String key = SkinPropertyCache.getClientKey(request);
            String skin = clientSkin.get(key);
            if (StringUtils.isBlank((CharSequence)skin)) {
                skin = SkinPropertyCache.getDefaultClientSkin();
            }
            if (StringUtils.isNotBlank((CharSequence)skin) && propMap.containsKey(skin)) {
                if ("system.skin".equals(propName) || "system.skins".equals(propName)) {
                    return skin;
                }
                return propMap.get(skin).get(propName);
            }
        }
        return null;
    }

    public static void loadSkinToApplication(String skin, HttpServletRequest request) {
        String string = skin = StringUtils.isBlank((CharSequence)skin) ? SkinPropertyCache.getClientSkin() : skin;
        if (propMap.containsKey(skin)) {
            Map<String, String> props = propMap.get(skin);
            ServletContext ctx = request.getServletContext();
            ctx.setAttribute("system.skin", (Object)skin);
            ctx.setAttribute("system.skins", (Object)skin);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                ctx.setAttribute(entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    private static String getClientKey(HttpServletRequest request) {
        if (Objects.nonNull(request)) {
            String ip = request.getHeader("X-Forwarded-For");
            if (StringUtils.isBlank((CharSequence)ip)) {
                ip = request.getRemoteAddr();
            }
            if ("0:0:0:0:0:0:0:1".equals(ip)) {
                ip = "127.0.0.1";
            }
            return "system:skin:client:" + ip;
        }
        return null;
    }

    private static String getClientKey() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        return SkinPropertyCache.getClientKey(request);
    }

    private static void loadSkinProperties() {
        Resource[] resources;
        if (Objects.isNull(propMap)) {
            propMap = new HashMap<String, Map<String, String>>();
        }
        Resource[] resourceArray = resources = ResourceUtil.loadResources((String)"/static/public/skins/*/skin.properties");
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            try {
                String path = resource.getURL().toString().replaceAll("[\\\\/]+", "/");
                String[] paths = path.split("/");
                String skin = paths[paths.length - 2];
                log.info("load skin property: " + skin.charAt(0) + StringUtils.repeat((String)"*", (int)(skin.length() - 2)) + skin.charAt(skin.length() - 1));
                HashMap<String, String> props = new HashMap<String, String>();
                Properties properties = new Properties();
                properties.load(resource.getInputStream());
                Enumeration<?> names = properties.propertyNames();
                while (names.hasMoreElements()) {
                    String key = (String)names.nextElement();
                    props.put(key, properties.getProperty(key));
                }
                propMap.put(skin, props);
            }
            catch (Exception e) {
                log.error("load skin property error", (Throwable)e);
            }
            ++n2;
        }
    }
}

