/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web.advice;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.exception.AuthorizationException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ExceptionHandlerAdvice
implements ResponseBodyAdvice {
    private ThreadLocal<Object> modelHolder = new ThreadLocal();
    private Logger logger = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);

    @ExceptionHandler(value={ZKBusinessException.class})
    @ResponseBody
    public ZKResultMsg handleResultException(ZKBusinessException e, HttpServletRequest request) {
        return this.getZkResultMsg(e);
    }

    private ZKResultMsg getZkResultMsg(ZKBusinessException e) {
        String level = "400";
        if (StringUtils.isNotBlank((CharSequence)e.getLevel())) {
            level = e.getLevel();
        }
        String msg = I18nUtil.i18nCode((String)e.getMessage(), (Object[])e.getObjects());
        ZKResultMsg resultMsg = new ZKResultMsg(level, msg);
        if (Objects.nonNull(e.getObjects()) && msg.contains("%s")) {
            resultMsg.setMsg(String.format(msg, e.getObjects()));
        }
        return resultMsg;
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public String handleResultException(AuthorizationException e, HttpServletRequest request) {
        request.setAttribute("noAuthDesc", (Object)I18nUtil.i18nCode((String)"common_no_authority_access", (Object[])new Object[0]));
        return "noAuthAccess";
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ZKResultMsg handleResultException(Exception e, HttpServletRequest request) {
        this.logger.error("ExceptionHandlerAdvice Desc", (Throwable)e);
        if (e instanceof ZKBusinessException) {
            return this.getZkResultMsg((ZKBusinessException)((Object)e));
        }
        String level = "400";
        this.logger.error("operate error", (Throwable)e);
        return new ZKResultMsg(level, I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
    }

    @InitBinder
    public void initBinder(WebDataBinder webDataBinder) {
        this.modelHolder.set(webDataBinder.getTarget());
    }

    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        this.modelHolder.remove();
        return body;
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ZKResultMsg handleConstraintViolationException(ConstraintViolationException e) {
        String msg = e.getMessage();
        Set constraintViolations = e.getConstraintViolations();
        Iterator iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation cvl = (ConstraintViolation)iterator.next();
            PathImpl path = (PathImpl)cvl.getPropertyPath();
            System.out.println(path.makeLeafNodeIterable().getName());
            msg = String.valueOf(path.makeLeafNodeIterable().getName()) + cvl.getMessage();
        }
        return new ZKResultMsg("400", msg);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ZKResultMsg handleIllegalParamException(MethodArgumentNotValidException e) {
        String msg = e.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).distinct().collect(Collectors.joining(";"));
        String fieldName = e.getBindingResult().getFieldError().getField();
        return new ZKResultMsg("400", String.valueOf(fieldName) + I18nUtil.i18nCode((String)msg, (Object[])new Object[0]));
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public ZKResultMsg handleBindException(BindException e) {
        String msg = e.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).distinct().collect(Collectors.joining(";"));
        String fieldName = e.getBindingResult().getFieldError().getField();
        return new ZKResultMsg("400", String.valueOf(fieldName) + I18nUtil.i18nCode((String)msg, (Object[])new Object[0]));
    }
}

