/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;

public class ExportController
extends BaseController {
    public static final String IMPORT_RESULT = "import-result:";
    public static final String EXPORT_RESULT = "export-result:";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Value(value="${system.maxExportCount:30000}")
    private Integer maxExportCount;

    public <T> List<T> excelImport(InputStream inputStream, Class<T> cls) {
        List<T> list = this.excelImport(inputStream, cls, null);
        return list;
    }

    public <T> List<T> excelImport(InputStream inputStream, Class<T> cls, Map<String, Map<String, String>> map) {
        this.stringRedisTemplate.opsForValue().set((Object)(IMPORT_RESULT + this.request.getSession().getId()), (Object)"start");
        List<T> list = ExcelUtil.excelImport(inputStream, cls, map);
        this.stringRedisTemplate.opsForValue().set((Object)(IMPORT_RESULT + this.request.getSession().getId()), (Object)"end");
        this.stringRedisTemplate.expire((Object)(IMPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        return list;
    }

    protected <T> void excelExportForDynamic(List<T> list, Class<T> cls, Map<String, Map<String, String>> map) {
        if (list == null || list.size() == 0) {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        String reportType = this.request.getParameter("reportType");
        String jsonColumn = this.request.getParameter("jsonColumn");
        String fileName = this.request.getParameter("tableNameParam");
        String tableName = this.request.getParameter("tableNameSearch");
        if (map != null && map.get("jsonColumn") != null) {
            Map<String, String> jsonColumnMap = map.get("jsonColumn");
            jsonColumn = jsonColumnMap.get("jsonColumn");
        }
        if (!StringUtils.isBlank((CharSequence)tableName)) {
            fileName = tableName;
        }
        if (map != null && map.get("tableName") != null) {
            Map<String, String> tableNameMap = map.get("tableName");
            fileName = tableNameMap.get("tableName");
        }
        String gridName = fileName;
        if (StringUtils.isBlank((CharSequence)reportType)) {
            reportType = "xlsx";
        }
        reportType = reportType.toLowerCase();
        try {
            try {
                String agent = this.request.getHeader("User-Agent").toLowerCase();
                if (this.request.getHeader("User-Agent") != null && agent.indexOf("edge") != -1) {
                    fileName = fileName.replaceAll(" ", "%20");
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    fileName = fileName.replace("%2520", " ");
                } else if (agent != null && (agent.indexOf("msie") != -1 || agent.indexOf("rv") != -1 && agent.indexOf("firefox") == -1)) {
                    fileName = fileName.replaceAll(" ", "%20");
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    fileName = fileName.replace("%2520", " ");
                } else {
                    fileName = agent != null && agent.indexOf("firefox") != -1 ? new String(fileName.getBytes("UTF-8"), "ISO-8859-1") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
                }
                this.response.setCharacterEncoding("utf-8");
                this.response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType + "\"");
                this.response.setContentType("application/octet-stream");
                ServletOutputStream os = this.response.getOutputStream();
                ExcelUtil.excelExportForDynamic(list, cls, jsonColumn, gridName, (OutputStream)os, reportType, map);
                os.flush();
            }
            catch (Exception e) {
                this.log.error(String.valueOf(fileName) + " export error", (Throwable)e);
                this.response.setHeader("Content-Disposition", "");
                this.response.setContentType("application/json");
                throw new ZKBusinessException("common_report_exportFaild");
            }
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        }
    }

    protected <T> void excelExportForDynamic(List<T> list, Class<T> cls) {
        this.excelExportForDynamic(list, cls, null);
    }

    protected <T> void excelExport(List<T> list, Class<T> cls) {
        this.excelExport(list, cls, null);
    }

    protected boolean isNeedValid(String mode) {
        Object value;
        block4: {
            try {
                Object authSecurityParamsService = SpringContextUtil.getBean((String)"authSecurityParamsServiceImpl");
                Object result = MethodUtils.invokeMethod((Object)authSecurityParamsService, (String)"getPwdRequiredForOperation");
                if (result == null || !"0".equals(result.toString())) break block4;
                return false;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
                return false;
            }
        }
        String id = WebContextUtil.getCurrentSessionId();
        String key = "valid_" + id;
        if (StringUtils.isNotBlank((CharSequence)mode) && mode.indexOf(":") != -1) {
            key = "valid_" + mode.split(":")[0].trim() + id;
        }
        return !Objects.nonNull(value = this.stringRedisTemplate.opsForValue().get((Object)key));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> void excelExport(List<T> list, Class<T> cls, Map<String, Map<String, String>> map) {
        if (list == null || list.size() == 0) {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            this.response.setHeader("Content-Disposition", "");
            this.response.setContentType("application/json");
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        String reportType = this.request.getParameter("reportType");
        String jsonColumn = this.request.getParameter("jsonColumn");
        String fileName = this.request.getParameter("tableNameParam");
        String tableName = this.request.getParameter("tableNameSearch");
        String isEncrypt = this.request.getParameter("isEncrypt");
        String encryptPassword = this.request.getParameter("encryptPassword");
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                Object authUserService = SpringContextUtil.getBean((String)"authUserServiceImpl");
                Object result = MethodUtils.invokeMethod((Object)authUserService, (String)"verifySecurity", (Object[])new Object[]{WebContextUtil.getCurrentSessionId(), loginPwd, "pwd"});
                if (!((Boolean)result).booleanValue()) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        if (map != null && map.get("jsonColumn") != null) {
            Map<String, String> jsonColumnMap = map.get("jsonColumn");
            jsonColumn = jsonColumnMap.get("jsonColumn");
        }
        if (!StringUtils.isBlank((CharSequence)tableName)) {
            fileName = tableName;
        }
        if (map != null && map.get("tableName") != null) {
            Map<String, String> tableNameMap = map.get("tableName");
            fileName = tableNameMap.get("tableName");
        }
        String encryptFileName = fileName;
        String gridName = fileName;
        if (StringUtils.isBlank((CharSequence)reportType)) {
            reportType = "xlsx";
        }
        reportType = reportType.toLowerCase();
        OutputStream fileOutputStream = null;
        try {
            try {
                String agent = this.request.getHeader("User-Agent").toLowerCase();
                if (this.request.getHeader("User-Agent") != null && agent.indexOf("edge") != -1) {
                    fileName = fileName.replaceAll(" ", "%20");
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    fileName = fileName.replace("%2520", " ");
                } else if (agent != null && (agent.indexOf("msie") != -1 || agent.indexOf("rv") != -1 && agent.indexOf("firefox") == -1)) {
                    fileName = fileName.replaceAll(" ", "%20");
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    fileName = fileName.replace("%2520", " ");
                } else {
                    fileName = agent != null && agent.indexOf("firefox") != -1 ? new String(fileName.getBytes("UTF-8"), "ISO-8859-1") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
                }
                if (StringUtils.isNotBlank((CharSequence)isEncrypt) && "1".equals(isEncrypt)) {
                    if (!StringUtils.isNotBlank((CharSequence)encryptPassword)) throw new ZKBusinessException("common_report_exportFaild");
                    encryptFileName = encryptFileName.replaceAll("\\+", " ");
                    this.encryptFileExport(tableName, encryptFileName, fileName, reportType, gridName, encryptPassword, (FileOutputStream)fileOutputStream, list, cls, map, jsonColumn);
                    return;
                } else {
                    this.response.setCharacterEncoding("utf-8");
                    this.response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType + "\"");
                    this.response.setContentType("application/octet-stream");
                    ServletOutputStream os = this.response.getOutputStream();
                    ExcelUtil.excelExport(list, cls, jsonColumn, gridName, (OutputStream)os, reportType, map);
                }
                return;
            }
            catch (Exception e) {
                this.log.error(String.valueOf(fileName) + " export error", (Throwable)e);
                this.response.setHeader("Content-Disposition", "");
                this.response.setContentType("application/json");
                throw new ZKBusinessException("common_report_exportFaild");
            }
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    ((FileOutputStream)fileOutputStream).close();
                }
            }
            catch (IOException e) {
                this.log.error("FileOutputStream:", (Throwable)e);
            }
        }
    }

    protected void setConditionValue(BaseItem conditionItem) {
        String[] conditionAry;
        this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"start");
        String queryCondition = this.request.getParameter("queryConditions");
        String sortOrder = this.request.getParameter("sortOrder");
        String sortName = this.request.getParameter("sortName");
        if (StringUtils.isNotBlank((CharSequence)sortOrder) && StringUtils.isNotBlank((CharSequence)sortName)) {
            conditionItem.setSortName(sortName);
            conditionItem.setSortOrder(sortOrder);
        }
        if (StringUtils.isBlank((CharSequence)queryCondition)) {
            return;
        }
        String[] stringArray = conditionAry = queryCondition.replaceAll("%20", " ").split("&");
        int n = conditionAry.length;
        int n2 = 0;
        while (n2 < n) {
            String condition = stringArray[n2];
            if (!StringUtils.isBlank((CharSequence)condition)) {
                String[] strAry = condition.split("=", 2);
                String fieldName = strAry[0];
                String fieldValue = strAry[1];
                try {
                    Field field = conditionItem.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    fieldValue = URLDecoder.decode(fieldValue, "UTF-8");
                    if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                        if (field.getType().getTypeName().equals("java.util.Date")) {
                            field.set(conditionItem, DateUtil.stringToDate((String)fieldValue));
                        } else if (field.getType().getTypeName().equals("java.sql.Timestamp")) {
                            field.set(conditionItem, new Timestamp(DateUtil.stringToDate((String)fieldValue).getTime()));
                        } else {
                            field.set(conditionItem, ConvertUtils.convert((String)fieldValue, field.getType()));
                        }
                    }
                }
                catch (Exception e) {
                    this.log.warn("setConditionValue: " + fieldName);
                }
            }
            ++n2;
        }
    }

    protected int getBeginIndex() {
        String exportType = this.request.getParameter("exportType");
        String recordStart = this.request.getParameter("recordstart");
        String recordCount = this.request.getParameter("recordcount");
        int beginIndex = 0;
        if ("3".equals(exportType) && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : beginIndex;
        }
        return beginIndex;
    }

    protected int getEndIndex() {
        String exportType = this.request.getParameter("exportType");
        String recordStart = this.request.getParameter("recordstart");
        String recordCount = this.request.getParameter("recordcount");
        int endIndex = this.maxExportCount - 1;
        if ("3".equals(exportType) && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            int beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : beginIndex;
            int maxCount = Integer.valueOf(recordCount) > this.maxExportCount ? this.maxExportCount : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        return endIndex;
    }

    protected <T> void encryptFileExport(String tableName, String encryptFileName, String fileName, String reportType, String gridName, String password, FileOutputStream fileOutputStream, List<T> list, Class<T> cls, Map<String, Map<String, String>> map, String jsonColumn) throws Exception {
        String fileNamePrefix = "";
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            fileNamePrefix = tableName;
        } else if (StringUtils.isNotBlank((CharSequence)encryptFileName)) {
            fileNamePrefix = encryptFileName;
        }
        fileName = String.valueOf(ClassUtil.getRootPath()) + File.separator + FileUtil.systemFilePath + File.separator + "upload" + File.separator + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase();
        File folder = new File(fileName);
        if (!folder.getParentFile().exists()) {
            folder.getParentFile().mkdirs();
        }
        fileOutputStream = new FileOutputStream(fileName);
        ExcelUtil.excelExport(list, cls, jsonColumn, gridName, fileOutputStream, reportType, map);
        ArrayList<File> files = new ArrayList<File>();
        File file = new File(fileName);
        if (file.exists()) {
            files.add(file);
        }
        String tempPath = String.valueOf(ClassUtil.getRootPath()) + File.separator + FileUtil.systemFilePath + File.separator + "upload" + File.separator + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + "zip";
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new ZKBusinessException("common_report_exportFaild");
        }
        this.response = FileUtil.fileEncryptZip((String)tempPath, files, (String)password, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        this.response.flushBuffer();
        File zipTempFile = new File(tempPath);
        if (zipTempFile.exists()) {
            zipTempFile.delete();
        }
        for (File f : files) {
            if (!f.exists()) continue;
            f.delete();
        }
    }
}

