/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.bean.GridColumnItem;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.BigExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.DynamicColumn;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.utils.ZKBaseFontUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExcelUtil {
    private static final Logger loger = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String XSLM = "xlsm";
    public static final String PDF = "pdf";
    public static final String CSV = "csv";
    public static final String TXT = "txt";
    public static final String ENCRYPT_PASSWORD_YES = "1";

    @Deprecated
    public static <T> List<T> excelImport(InputStream inputStream, Class<T> cls) {
        Workbook workbook = ExcelUtil.createImportWorkBook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Field[] fields = cls.getDeclaredFields();
        List fieldList = Arrays.stream(fields).filter(f -> f.getAnnotation(GridColumn.class) != null).collect(Collectors.toList());
        Row columnNames = sheet.getRow(1);
        DataFormatter formatter = new DataFormatter();
        ArrayList<T> list = new ArrayList<T>();
        try {
            for (Row row : sheet) {
                if (row.getRowNum() <= 1) continue;
                T t = cls.newInstance();
                for (Cell cell : row) {
                    Cell columnNameCell = columnNames.getCell(cell.getColumnIndex());
                    if (StringUtils.isEmpty((Object)formatter.formatCellValue(columnNameCell))) {
                        new ZKBusinessException("common_report_columnError");
                    }
                    if (columnNameCell == null) continue;
                    String columnName = formatter.formatCellValue(columnNameCell);
                    Field field = fieldList.stream().filter(f -> columnName.equals(I18nUtil.i18nCode((String)f.getAnnotation(GridColumn.class).label(), (Object[])new Object[0]))).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError"));
                    field.setAccessible(true);
                    if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                        DateType dateType = field.getAnnotation(DateType.class);
                        String format = ExcelUtil.getDateFormt(dateType);
                        if (cell.getCellType() == CellType.NUMERIC) {
                            if (!(cell.getNumericCellValue() > 0.0)) continue;
                            field.set(t, org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                            continue;
                        }
                        if (StringUtils.isEmpty((Object)formatter.formatCellValue(cell))) continue;
                        field.set(t, DateUtil.stringToDate((String)formatter.formatCellValue(cell), (String)format));
                        continue;
                    }
                    if (StringUtils.isEmpty((Object)formatter.formatCellValue(cell))) continue;
                    field.set(t, ConvertUtils.convert((String)formatter.formatCellValue(cell), field.getType()));
                }
                list.add(t);
            }
        }
        catch (ZKBusinessException e) {
            loger.error("import business error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            loger.error("import error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    public static <T> List<T> excelImport(InputStream inputStream, Class<T> cls, Map<String, Map<String, String>> map) {
        Workbook workbook = ExcelUtil.createImportWorkBook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Field[] fields = cls.getDeclaredFields();
        List fieldList = Arrays.stream(fields).filter(f -> f.getAnnotation(GridColumn.class) != null).collect(Collectors.toList());
        Row columnNames = sheet.getRow(1);
        DataFormatter formatter = new DataFormatter();
        ArrayList<T> list = new ArrayList<T>();
        try {
            for (Row row : sheet) {
                if (row.getRowNum() <= 1) continue;
                T t = cls.newInstance();
                for (Cell cell : row) {
                    Cell columnNameCell = columnNames.getCell(cell.getColumnIndex());
                    if (StringUtils.isEmpty((Object)formatter.formatCellValue(columnNameCell))) {
                        new ZKBusinessException("common_report_columnError");
                    }
                    if (columnNameCell == null) continue;
                    String columnName = formatter.formatCellValue(columnNameCell);
                    Field field = fieldList.stream().filter(f -> columnName.equals(I18nUtil.i18nCode((String)f.getAnnotation(GridColumn.class).label(), (Object[])new Object[0]))).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError"));
                    field.setAccessible(true);
                    if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                        DateType dateType = field.getAnnotation(DateType.class);
                        String format = ExcelUtil.getDateFormt(dateType);
                        if (cell.getCellType() == CellType.NUMERIC && cell.getNumericCellValue() > 0.0) {
                            field.set(t, org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                            continue;
                        }
                        if (StringUtils.isEmpty((Object)formatter.formatCellValue(cell))) continue;
                        field.set(t, DateUtil.stringToDate((String)formatter.formatCellValue(cell), (String)format));
                        continue;
                    }
                    String cellValue = formatter.formatCellValue(cell);
                    if (map != null && map.containsKey(field.getName())) {
                        cellValue = map.get(field.getName()).get(cellValue);
                    }
                    if (StringUtils.isEmpty((Object)cellValue)) continue;
                    field.set(t, ConvertUtils.convert((String)cellValue, field.getType()));
                }
                list.add(t);
            }
        }
        catch (ZKBusinessException e) {
            loger.error("import business error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            loger.error("import error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    private static Workbook getImportWorkBook(InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = null;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (FileMagic.valueOf((InputStream)inputStream) == FileMagic.OLE2) {
            workbook = new HSSFWorkbook(inputStream);
        } else if (FileMagic.valueOf((InputStream)inputStream) == FileMagic.OOXML) {
            workbook = new XSSFWorkbook(inputStream);
        } else {
            throw new ZKBusinessException("auth_license_fileIncorrectFormat");
        }
        return workbook;
    }

    private static Workbook createImportWorkBook(InputStream inputStream) {
        Workbook workbook = null;
        try {
            workbook = ExcelUtil.getImportWorkBook(inputStream);
        }
        catch (Exception ex) {
            if (ex instanceof ZKBusinessException) {
                throw new ZKBusinessException(ex.getMessage(), (Throwable)ex);
            }
            throw new ZKBusinessException("Open the EXCEL file flow failure!", (Throwable)ex);
        }
        return workbook;
    }

    public static <T> void excelExportForDynamic(List<T> list, Class<T> cls, String jsonColumn, String fileName, OutputStream outputStream, String reportType, Map<String, Map<String, String>> map) throws IOException {
        BufferedOutputStream ops = new BufferedOutputStream(outputStream, 8192);
        Object workbook = null;
        workbook = XLS.equals(reportType) ? new HSSFWorkbook() : new XSSFWorkbook();
        if (!StringUtils.isEmpty((Object)fileName)) {
            fileName = fileName.replaceAll("\\+", " ");
        }
        Sheet sheet = workbook.createSheet(fileName);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonColumn, (Feature[])new Feature[]{Feature.OrderedField});
        LinkedMap dynaField = new LinkedMap();
        ArrayList<String> fieldList = new ArrayList<String>();
        try {
            for (String column : jsonObject.keySet()) {
                Field field = ExcelUtil.getDeclaredField(cls, column);
                if (field != null && field.getAnnotation(GridColumn.class) != null) {
                    field.setAccessible(true);
                    if (!field.getAnnotation(GridColumn.class).isExportExcel()) continue;
                    fieldList.add(column);
                    continue;
                }
                fieldList.add(column);
            }
            CellStyle headStyle = workbook.createCellStyle();
            Font headFont = workbook.createFont();
            headFont.setFontName("ARIAL");
            headFont.setFontHeightInPoints((short)10);
            headFont.setBold(true);
            headStyle.setFont(headFont);
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            CellStyle dataStyle = workbook.createCellStyle();
            dataStyle.setBorderBottom(BorderStyle.THIN);
            dataStyle.setBorderLeft(BorderStyle.THIN);
            dataStyle.setBorderTop(BorderStyle.THIN);
            dataStyle.setBorderRight(BorderStyle.THIN);
            dataStyle.setWrapText(true);
            dataStyle.setAlignment(HorizontalAlignment.CENTER);
            Row row = sheet.createRow(0);
            Cell cell = row.createCell(0);
            cell.setCellStyle(headStyle);
            cell.setCellValue(fileName.replaceAll("\\+", " "));
            if (fieldList.size() > 1) {
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fieldList.size() - 1));
            }
            int isMergedRegion = 2;
            Row columnRow = sheet.createRow(1);
            Row columnRow3 = sheet.createRow(2);
            int mergedRow = 0;
            int mergedRowj = 0;
            int i = 0;
            while (i < fieldList.size()) {
                CellRangeAddress region;
                String width = "";
                String columValue = "";
                String secHeader = "";
                if (ExcelUtil.getDeclaredField(cls, (String)fieldList.get(i)) != null) {
                    width = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).width();
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).label();
                    secHeader = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).secHeader();
                } else {
                    width = "90";
                    columValue = (String)fieldList.get(i);
                    String dynaFieldName = columValue.split("_")[0];
                    Field _dynaField = cls.getDeclaredField(dynaFieldName);
                    if (_dynaField != null && _dynaField.getAnnotation(GridColumn.class) != null) {
                        _dynaField.setAccessible(true);
                        GridColumn _dynaGridItem = _dynaField.getAnnotation(GridColumn.class);
                        if (!StringUtils.isEmpty((Object)_dynaGridItem.dynamicColumn())) {
                            DynamicColumn dc = (DynamicColumn)SpringContextUtil.getBean((String)_dynaGridItem.dynamicColumn(), DynamicColumn.class);
                            List<GridColumnItem> dynaGridItems = dc.getColumn(dynaFieldName);
                            for (GridColumnItem item : dynaGridItems) {
                                if (!item.getName().equals(columValue)) continue;
                                columValue = item.getLabel();
                                secHeader = item.getSecHeader();
                                width = item.getWidth();
                                break;
                            }
                        }
                    }
                }
                if (StringUtils.isEmpty((Object)columValue)) {
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getName();
                }
                if (!StringUtils.isEmpty((Object)width) && !"*".equals(width)) {
                    sheet.setColumnWidth(i, 50 * Integer.parseInt(width));
                }
                Cell columCell = columnRow.createCell(i);
                if (!"".equals(secHeader) && !"#cspan".equals(columValue)) {
                    Cell columCell3 = columnRow3.createCell(i);
                    columCell3.setCellStyle(dataStyle);
                    columCell3.setCellValue(I18nUtil.i18nCode((String)secHeader, (Object[])new Object[0]));
                }
                if (!"".equals(secHeader) && "#cspan".equals(columValue)) {
                    ++mergedRow;
                    ++mergedRowj;
                    columCell = columnRow3.createCell(i);
                    columValue = secHeader;
                    isMergedRegion = 3;
                } else {
                    if (mergedRowj != 0) {
                        region = new CellRangeAddress(1, 1, i - mergedRowj - 1, i - 1);
                        sheet.addMergedRegion(region);
                        ExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                    }
                    mergedRowj = 0;
                }
                if (mergedRowj != 0 && i == fieldList.size() - 1) {
                    region = new CellRangeAddress(1, 1, i - mergedRowj, i);
                    sheet.addMergedRegion(region);
                    ExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                }
                if ("".equals(secHeader) && mergedRow != 0) {
                    region = new CellRangeAddress(1, 2, i, i);
                    sheet.addMergedRegion(region);
                    ExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                }
                columCell.setCellStyle(dataStyle);
                columCell.setCellValue(I18nUtil.i18nCode((String)columValue, (Object[])new Object[0]));
                ++i;
            }
            String cellValue = "";
            CreationHelper creationHelper = workbook.getCreationHelper();
            int i2 = 0;
            while (i2 < list.size()) {
                Row dataRows = sheet.createRow(i2 + isMergedRegion);
                int j = 0;
                while (j < fieldList.size()) {
                    Cell dataCell = dataRows.createCell(j);
                    dataCell.setCellStyle(dataStyle);
                    if (ExcelUtil.getDeclaredField(cls, (String)fieldList.get(j)) != null) {
                        Field field = cls.getDeclaredField((String)fieldList.get(j));
                        field.setAccessible(true);
                        Object cellObject = field.get(list.get(i2));
                        if (field.getName().contains("picture") && cellObject != null) {
                            Hyperlink hyperLink = creationHelper.createHyperlink(HyperlinkType.FILE);
                            hyperLink.setAddress((String)cellObject);
                            dataCell.setHyperlink(hyperLink);
                        }
                        if (!StringUtils.isEmpty((Object)cellObject)) {
                            if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                                DateType dateType = field.getAnnotation(DateType.class);
                                String format = ExcelUtil.getDateFormt(dateType);
                                cellValue = new SimpleDateFormat(format).format(cellObject);
                            } else if (map != null && map.containsKey(field.getName())) {
                                cellValue = String.valueOf(cellObject);
                                if (map.get(field.getName()).containsKey(cellValue)) {
                                    cellValue = I18nUtil.i18nCode((String)map.get(field.getName()).get(cellValue), (Object[])new Object[0]);
                                }
                            } else {
                                cellValue = String.valueOf(cellObject);
                                if (field.getAnnotation(GridColumn.class).i18n()) {
                                    cellValue = I18nUtil.i18nCode((String)cellValue, (Object[])new Object[0]);
                                }
                                if (!StringUtils.isEmpty((Object)field.getAnnotation(GridColumn.class).format())) {
                                    cellValue = I18nUtil.i18nCode((String)GridUtil.getDictionaryVal(field.getAnnotation(GridColumn.class).format(), cellValue), (Object[])new Object[0]);
                                }
                            }
                        } else {
                            cellValue = "";
                        }
                    } else {
                        String dynaFieldName = ((String)fieldList.get(j)).split("_")[0];
                        Field field = cls.getDeclaredField(dynaFieldName);
                        field.setAccessible(true);
                        Map extraDataMaps = (Map)field.get(list.get(i2));
                        cellValue = String.valueOf(extraDataMaps.get(fieldList.get(j)));
                    }
                    dataCell.setCellValue(cellValue);
                    if (StringUtils.isEmpty((Object)cellValue) || "null".equals(cellValue)) {
                        dataCell.setCellValue("");
                    }
                    ++j;
                }
                ++i2;
            }
            if (PDF.equals(reportType)) {
                ExcelUtil.ExecltoPdf((Workbook)workbook, ops);
            } else if (CSV.equals(reportType) || TXT.equals(reportType)) {
                ExcelUtil.ExecltoCsv((Workbook)workbook, ops);
            } else {
                workbook.write((OutputStream)ops);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((OutputStream)ops).flush();
        ((OutputStream)ops).close();
        outputStream.close();
    }

    private static Field getDeclaredField(Class<?> cls, String fieldName) {
        Field field = null;
        try {
            field = cls.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            loger.info("===" + e.getMessage());
        }
        return field;
    }

    public static <T> void generateExcel(List<T> list, Class<T> cls, String jsonColumn, String fileName, String reportType, String filePath, Map<String, Map<String, String>> map) {
        try {
            Workbook workbook = ExcelUtil.generateExcelAndFillData(list, cls, jsonColumn, fileName, reportType, map);
            FileOutputStream outputStream = new FileOutputStream(String.valueOf(filePath) + fileName);
            workbook.write((OutputStream)outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            loger.error("", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
    }

    public static boolean isBigExport() {
        String count = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.maxExportCount");
        if (!StringUtils.isEmpty((Object)count)) {
            return Integer.parseInt(count) > 30000;
        }
        return false;
    }

    public static <T> void excelExport(List<T> list, Class<T> cls, String jsonColumn, String fileName, OutputStream outputStream, String reportType, Map<String, Map<String, String>> map) throws IOException {
        block18: {
            if (ExcelUtil.isBigExport()) {
                try {
                    try {
                        BigExcelUtil.export(list, cls, jsonColumn, fileName, outputStream, reportType, map);
                        break block18;
                    }
                    catch (Exception e) {
                        loger.error("", (Throwable)e);
                        throw new ZKBusinessException("common_op_failed");
                    }
                }
                finally {
                    if (outputStream != null) {
                        outputStream.flush();
                        outputStream.close();
                    }
                }
            }
            BufferedOutputStream ops = new BufferedOutputStream(outputStream, 8192);
            try {
                try {
                    Workbook workbook = ExcelUtil.generateExcelAndFillData(list, cls, jsonColumn, fileName, reportType, map);
                    if (PDF.equals(reportType)) {
                        ExcelUtil.ExecltoPdf(workbook, ops);
                    } else if (CSV.equals(reportType) || TXT.equals(reportType)) {
                        ExcelUtil.ExecltoCsv(workbook, ops);
                    } else {
                        workbook.write((OutputStream)ops);
                    }
                }
                catch (Exception e) {
                    loger.error("", (Throwable)e);
                    throw new ZKBusinessException("common_op_failed");
                }
            }
            finally {
                if (ops != null) {
                    ((OutputStream)ops).flush();
                    ((OutputStream)ops).close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
        }
    }

    private static void addComment(Drawing drawing, String reportType, Cell cell, String comment) {
        if (StringUtils.isEmpty((Object)comment)) {
            return;
        }
        comment = I18nUtil.i18nCode((String)comment, (Object[])new Object[0]);
        if (XLS.equals(reportType)) {
            HSSFPatriarch patriarch = (HSSFPatriarch)drawing;
            HSSFComment cmt = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
            cmt.setString((RichTextString)new HSSFRichTextString(comment));
            cell.setCellComment((Comment)cmt);
        } else {
            XSSFDrawing patriarch = (XSSFDrawing)drawing;
            XSSFComment cmt = patriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
            cmt.setString((RichTextString)new XSSFRichTextString(comment));
            cell.setCellComment((Comment)cmt);
        }
    }

    private static <T> Workbook generateExcelAndFillData(List<T> list, Class<T> cls, String jsonColumn, String fileName, String reportType, Map<String, Map<String, String>> map) {
        Object workbook = null;
        workbook = XLS.equals(reportType) ? new HSSFWorkbook() : new XSSFWorkbook();
        if (!StringUtils.isEmpty((Object)fileName)) {
            fileName = fileName.replaceAll("\\+", " ");
        }
        Sheet sheet = workbook.createSheet(fileName);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonColumn, (Feature[])new Feature[]{Feature.OrderedField});
        LinkedMap extraDataMap = new LinkedMap();
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<String> extraDataNames = new ArrayList<String>();
        Drawing drawing = sheet.createDrawingPatriarch();
        try {
            for (String fieldName : jsonObject.keySet()) {
                Field field = cls.getDeclaredField(fieldName);
                field.setAccessible(true);
                if (field.getAnnotation(GridColumn.class) != null && !field.getAnnotation(GridColumn.class).isExportExcel()) continue;
                if ("java.util.Map".equals(cls.getDeclaredField(fieldName).getType().getTypeName())) {
                    Map extraMap = (Map)field.get(list.get(0));
                    extraDataMap.putAll(extraMap);
                    extraDataNames.add(fieldName);
                    for (Map.Entry entry : extraMap.entrySet()) {
                        fieldList.add((String)entry.getKey());
                    }
                    continue;
                }
                fieldList.add(fieldName);
            }
            CellStyle headStyle = workbook.createCellStyle();
            Font headFont = workbook.createFont();
            headFont.setFontName("ARIAL");
            headFont.setFontHeightInPoints((short)10);
            headFont.setBold(true);
            headStyle.setFont(headFont);
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            CellStyle dataStyle = workbook.createCellStyle();
            dataStyle.setBorderBottom(BorderStyle.THIN);
            dataStyle.setBorderLeft(BorderStyle.THIN);
            dataStyle.setBorderTop(BorderStyle.THIN);
            dataStyle.setBorderRight(BorderStyle.THIN);
            dataStyle.setWrapText(true);
            dataStyle.setAlignment(HorizontalAlignment.CENTER);
            Row row = sheet.createRow(0);
            Cell cell = row.createCell(0);
            cell.setCellStyle(headStyle);
            cell.setCellValue(fileName.replaceAll("\\+", " "));
            if (fieldList.size() > 1) {
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fieldList.size() - 1));
            }
            int isMergedRegion = 2;
            Row columnRow = sheet.createRow(1);
            Row columnRow3 = sheet.createRow(2);
            int mergedRow = 0;
            int mergedRowj = 0;
            GridColumn ca = null;
            int i = 0;
            while (i < fieldList.size()) {
                CellRangeAddress region;
                String width = "";
                String columValue = "";
                String secHeader = "";
                try {
                    ca = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class);
                }
                catch (Exception e) {
                    ca = null;
                }
                if (!extraDataMap.containsKey(fieldList.get(i))) {
                    width = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).width();
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).label();
                    secHeader = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).secHeader();
                } else {
                    width = "90";
                    columValue = (String)fieldList.get(i);
                }
                if (StringUtils.isEmpty((Object)columValue)) {
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getName();
                }
                if (!StringUtils.isEmpty((Object)width) && !"*".equals(width)) {
                    sheet.setColumnWidth(i, 50 * Integer.parseInt(width));
                }
                Cell columCell = columnRow.createCell(i);
                if (!"".equals(secHeader) && !"#cspan".equals(columValue)) {
                    Cell columCell3 = columnRow3.createCell(i);
                    columCell3.setCellStyle(dataStyle);
                    columCell3.setCellValue(I18nUtil.i18nCode((String)secHeader, (Object[])new Object[0]));
                }
                if (!"".equals(secHeader) && "#cspan".equals(columValue)) {
                    ++mergedRow;
                    ++mergedRowj;
                    columCell = columnRow3.createCell(i);
                    columValue = secHeader;
                    isMergedRegion = 3;
                } else {
                    if (mergedRowj != 0) {
                        region = new CellRangeAddress(1, 1, i - mergedRowj - 1, i - 1);
                        sheet.addMergedRegion(region);
                        ExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                    }
                    mergedRowj = 0;
                }
                if (mergedRowj != 0 && i == fieldList.size() - 1) {
                    region = new CellRangeAddress(1, 1, i - mergedRowj, i);
                    sheet.addMergedRegion(region);
                    ExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                }
                if ("".equals(secHeader) && mergedRow != 0) {
                    region = new CellRangeAddress(1, 2, i, i);
                    sheet.addMergedRegion(region);
                    ExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                }
                columCell.setCellStyle(dataStyle);
                columCell.setCellValue(I18nUtil.i18nCode((String)columValue, (Object[])new Object[0]));
                if (ca != null) {
                    ExcelUtil.addComment(drawing, reportType, columCell, ca.exportComment());
                }
                ++i;
            }
            String cellValue = "";
            CreationHelper creationHelper = workbook.getCreationHelper();
            int i2 = 0;
            while (i2 < list.size()) {
                Row dataRows = sheet.createRow(i2 + isMergedRegion);
                int j = 0;
                while (j < fieldList.size()) {
                    Cell dataCell = dataRows.createCell(j);
                    dataCell.setCellStyle(dataStyle);
                    if (!extraDataMap.containsKey(fieldList.get(j))) {
                        Field field = cls.getDeclaredField((String)fieldList.get(j));
                        field.setAccessible(true);
                        Object cellObject = field.get(list.get(i2));
                        if (field.getName().contains("picture") && cellObject != null) {
                            Hyperlink hyperLink = creationHelper.createHyperlink(HyperlinkType.FILE);
                            hyperLink.setAddress((String)cellObject);
                            dataCell.setHyperlink(hyperLink);
                        }
                        if (!StringUtils.isEmpty((Object)cellObject)) {
                            if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                                DateType dateType = field.getAnnotation(DateType.class);
                                String format = ExcelUtil.getDateFormt(dateType);
                                cellValue = new SimpleDateFormat(format).format(cellObject);
                            } else if (map != null && map.containsKey(field.getName())) {
                                cellValue = String.valueOf(cellObject);
                                if (map.get(field.getName()).containsKey(cellValue)) {
                                    cellValue = I18nUtil.i18nCode((String)map.get(field.getName()).get(cellValue), (Object[])new Object[0]);
                                }
                            } else {
                                cellValue = String.valueOf(cellObject);
                                if (field.getAnnotation(GridColumn.class).i18n()) {
                                    cellValue = I18nUtil.i18nCode((String)cellValue, (Object[])new Object[0]);
                                }
                                if (!StringUtils.isEmpty((Object)field.getAnnotation(GridColumn.class).format())) {
                                    cellValue = I18nUtil.i18nCode((String)GridUtil.getDictionaryVal(field.getAnnotation(GridColumn.class).format(), cellValue), (Object[])new Object[0]);
                                }
                            }
                        } else {
                            cellValue = "";
                        }
                    } else {
                        HashMap extraDataMaps = new HashMap();
                        for (String extraDataName : extraDataNames) {
                            Field field = cls.getDeclaredField(extraDataName);
                            field.setAccessible(true);
                            Map mapDta = (Map)field.get(list.get(i2));
                            extraDataMaps.putAll(mapDta);
                        }
                        cellValue = String.valueOf(extraDataMaps.get(fieldList.get(j)));
                    }
                    dataCell.setCellValue(cellValue);
                    if (StringUtils.isEmpty((Object)cellValue) || "null".equals(cellValue)) {
                        dataCell.setCellValue("");
                    }
                    ++j;
                }
                ++i2;
            }
        }
        catch (Exception e) {
            loger.error("", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return workbook;
    }

    public static String getDateFormt(DateType dateType) {
        String format;
        block13: {
            format = "yyyy-MM-dd HH:mm:ss";
            if (dateType == null) break block13;
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        return format;
    }

    public static void ExecltoPdf(Workbook workbook, OutputStream out) throws DocumentException, FileNotFoundException {
        try {
            Document iText_xls_2_pdf = new Document(PageSize.A3, 50.0f, 50.0f, 50.0f, 50.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)iText_xls_2_pdf, (OutputStream)out);
            Header header = new Header();
            writer.setPageEvent((PdfPageEvent)header);
            iText_xls_2_pdf.open();
            int sheetSize = workbook.getNumberOfSheets();
            int i = 0;
            while (i < sheetSize) {
                Sheet my_worksheet = workbook.getSheetAt(i);
                for (Row row : my_worksheet) {
                    int num = row.getPhysicalNumberOfCells();
                    if (num == 0) continue;
                    PdfPTable my_table = new PdfPTable(num);
                    my_table.setWidthPercentage(100.0f);
                    int[] widths = new int[num];
                    Iterator cellIterator = row.cellIterator();
                    while (cellIterator.hasNext()) {
                        Cell cell = (Cell)cellIterator.next();
                        switch (cell.getCellType()) {
                            case STRING: {
                                PdfPCell table_cell = new PdfPCell((Phrase)new Paragraph(cell.getStringCellValue(), ZKBaseFontUtil.getBodyFont(cell.getStringCellValue())));
                                table_cell.setHorizontalAlignment(1);
                                if (1 == cell.getRowIndex()) {
                                    table_cell.setBackgroundColor(new BaseColor(217, 217, 217));
                                } else if (cell.getRowIndex() == 0) {
                                    table_cell = new PdfPCell((Phrase)new Paragraph(cell.getStringCellValue(), ZKBaseFontUtil.getTitleFont(cell.getStringCellValue())));
                                    table_cell.setBorder(0);
                                    table_cell.setPaddingBottom(20.0f);
                                    table_cell.setHorizontalAlignment(1);
                                }
                                widths[cell.getColumnIndex()] = my_worksheet.getColumnWidth(cell.getColumnIndex());
                                my_table.addCell(table_cell);
                            }
                        }
                    }
                    my_table.setWidths(widths);
                    iText_xls_2_pdf.add((Element)my_table);
                }
                ++i;
            }
            iText_xls_2_pdf.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ExecltoCsv(Workbook workbook, OutputStream out) throws IOException {
        byte[] uft8bom = new byte[]{-17, -69, -65};
        out.write(uft8bom);
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        Sheet my_worksheet = workbook.getSheetAt(0);
        Iterator rowIterator = my_worksheet.iterator();
        try {
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                int num = row.getPhysicalNumberOfCells();
                if (num == 0) continue;
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    switch (cell.getCellType()) {
                        case STRING: {
                            bw.append("\"" + cell.getStringCellValue() + "\"");
                            bw.append(",");
                        }
                    }
                }
                bw.append(System.getProperty("line.separator"));
            }
            bw.flush();
            out.close();
            bw.close();
            osw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setBorderStyle(BorderStyle border, CellRangeAddress region, Sheet sheet) {
        RegionUtil.setBorderBottom((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
    }

    private static class Header
    extends PdfPageEventHelper {
        private Header() {
        }

        public void onEndPage(PdfWriter pdfWriter, Document document) {
            ColumnText.showTextAligned((PdfContentByte)pdfWriter.getDirectContent(), (int)2, (Phrase)new Phrase("Page:" + pdfWriter.getCurrentPageNumber()), (float)450.0f, (float)30.0f, (float)0.0f);
        }
    }
}

