/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.bean.GridColumnItem;
import com.zkteco.zkbiosecurity.core.utils.DynamicColumn;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.utils.ZKBaseFontUtil;
import com.zkteco.zkbiosecurity.core.web.bean.ExportParameterItem;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class BigExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(BigExcelUtil.class);
    private static final String DHX_CSPAN = "#cspan";
    private static final String COLUMN_TYPE_DIC = "dic";
    private static final String DEFAULT_COLUMN_WIDTH = "70";

    private static CellStyle getDataCellStyle(Workbook book) {
        CellStyle dataStyle = book.createCellStyle();
        dataStyle.setBorderBottom(BorderStyle.THIN);
        dataStyle.setBorderLeft(BorderStyle.THIN);
        dataStyle.setBorderTop(BorderStyle.THIN);
        dataStyle.setBorderRight(BorderStyle.THIN);
        dataStyle.setWrapText(true);
        dataStyle.setAlignment(HorizontalAlignment.CENTER);
        dataStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return dataStyle;
    }

    private static CellStyle getHeadCellStyle(Workbook book) {
        CellStyle headStyle = book.createCellStyle();
        Font font = book.createFont();
        font.setFontName("ARIAL");
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        headStyle.setFont(font);
        headStyle.setBorderBottom(BorderStyle.THIN);
        headStyle.setBorderLeft(BorderStyle.THIN);
        headStyle.setBorderTop(BorderStyle.THIN);
        headStyle.setBorderRight(BorderStyle.THIN);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return headStyle;
    }

    private static void loadDictionary(String key, Map<String, Map<String, String>> map) {
        if (!map.containsKey(key)) {
            try {
                Object service = SpringContextUtil.getBean((String)"baseDictionaryValueServiceImpl");
                Object values = MethodUtils.invokeMethod((Object)service, (String)"getDictionaryValues", (Object[])new Object[]{key});
                if (Objects.nonNull(values)) {
                    List items = (List)values;
                    HashMap<String, String> dictionary = new HashMap<String, String>();
                    for (Object item : items) {
                        Map dic = BeanUtils.describe(item);
                        String dicKey = (String)dic.get("code");
                        String dicVal = (String)dic.get("dictValue");
                        dictionary.put(dicKey, dicVal);
                    }
                    map.put(key, dictionary);
                }
            }
            catch (Exception e) {
                log.error("Load dictionary value failed", (Throwable)e);
            }
        }
    }

    private static <T> ExportParameterItem<T> convertToExportParameter(List<T> data, Class<T> cls, String jsonColumn, String fileName, OutputStream outputStream, String reportType, Map<String, Map<String, String>> map) {
        ExportParameterItem<T> params = new ExportParameterItem<T>();
        params.setData(data);
        params.setCls(cls);
        if (Objects.isNull(map)) {
            map = new HashMap<String, Map<String, String>>();
        }
        params.setMap(map);
        JSONObject columns = JSONObject.parseObject((String)jsonColumn, (Feature[])new Feature[]{Feature.OrderedField});
        params.setColumns(columns);
        List<GridColumnItem> fieldList = BigExcelUtil.getGridColumns(columns, cls, data);
        for (GridColumnItem item : fieldList) {
            String w = item.getWidth();
            if (StringUtils.isBlank((CharSequence)w) || !w.matches("[\\d]+")) {
                item.setWidth(DEFAULT_COLUMN_WIDTH);
            }
            if (!COLUMN_TYPE_DIC.equals(item.getColumnType())) continue;
            BigExcelUtil.loadDictionary(item.getKey(), params.getMap());
        }
        params.setColumnItems(fieldList);
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            params.setTableName(fileName.replaceAll("\\+", " "));
        }
        params.setReportType(reportType);
        params.setOutputStream(outputStream);
        return params;
    }

    public static <T> void export(List<T> data, Class<T> cls, String jsonColumn, String fileName, OutputStream outputStream, String reportType, Map<String, Map<String, String>> map) throws Exception {
        long start = System.currentTimeMillis();
        ExportParameterItem<T> params = BigExcelUtil.convertToExportParameter(data, cls, jsonColumn, fileName, outputStream, reportType, map);
        if ("pdf".equalsIgnoreCase(reportType)) {
            BigExcelUtil.exportPdf(params);
        } else if ("csv".equalsIgnoreCase(reportType) || "txt".equals(reportType)) {
            BigExcelUtil.exportCsv(params);
        } else {
            BigExcelUtil.exportXls(params);
        }
        log.info("Export data cost " + (System.currentTimeMillis() - start) + "ms");
    }

    private static <T> void exportXls(ExportParameterItem<T> params) throws IOException {
        BigExcelUtil.createHeaderForXls(params);
        BigExcelUtil.createBodyForXls(params);
        params.getBook().write(params.getOutputStream());
        params.getBook().close();
    }

    private static int getTotalWidth(List<GridColumnItem> fieldList) {
        int sum = 0;
        for (GridColumnItem column : fieldList) {
            String w = column.getWidth();
            sum += Integer.parseInt(w);
        }
        return sum;
    }

    private static <T> void createTitleRowForPdf(ExportParameterItem<T> params) throws DocumentException {
        String tableName = params.getTableName().replaceAll("\\+", " ");
        PdfPTable titleRow = new PdfPTable(1);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(tableName, ZKBaseFontUtil.getTitleFont(tableName)));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(1);
        cell.setBorder(0);
        cell.setPaddingBottom(20.0f);
        titleRow.addCell(cell);
        int w = BigExcelUtil.getTotalWidth(params.getColumnItems());
        titleRow.setWidths(new int[]{w});
        titleRow.setWidthPercentage(100.0f);
        params.getDoc().add((Element)titleRow);
    }

    private static <T> void createHeaderForPdf(ExportParameterItem<T> params) throws DocumentException {
        Document doc = new Document(PageSize.A3, 20.0f, 20.0f, 20.0f, 50.0f);
        params.setDoc(doc);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)params.getOutputStream());
        params.setPdfWriter(writer);
        Header header = new Header();
        writer.setPageEvent((PdfPageEvent)header);
        doc.open();
        List<GridColumnItem> fieldList = params.getColumnItems();
        int rowNum = 2;
        BigExcelUtil.createTitleRowForPdf(params);
        if (BigExcelUtil.isComplexColumn(fieldList)) {
            rowNum = 3;
            BigExcelUtil.createComplexHeaderForPdf(params);
        } else {
            PdfPTable row = new PdfPTable(fieldList.size());
            row.setWidthPercentage(100.0f);
            int[] w = new int[fieldList.size()];
            int i = 0;
            while (i < fieldList.size()) {
                GridColumnItem column = fieldList.get(i);
                BigExcelUtil.createHeaderCellForPdf(row, column.getLabel(), true);
                w[i] = Integer.parseInt(column.getWidth());
                ++i;
            }
            row.setWidths(w);
            params.getDoc().add((Element)row);
        }
        params.setHeadRowNumber(rowNum);
    }

    private static PdfPCell createHeaderCellForPdf(PdfPTable row, String value, boolean border) {
        value = I18nUtil.i18nCode((String)(StringUtils.isBlank((CharSequence)value) ? "" : value.replaceAll("\\+", " ")), (Object[])new Object[0]);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, ZKBaseFontUtil.getBodyFont(value)));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(1);
        cell.setBackgroundColor(new BaseColor(217, 217, 217));
        if (!border) {
            cell.setBorder(0);
        }
        if (Objects.nonNull(row)) {
            row.addCell(cell);
        }
        return cell;
    }

    private static void createCellForPdf(PdfPTable row, String value) {
        value = StringUtils.isBlank((CharSequence)value) ? "" : I18nUtil.i18nCode((String)value, (Object[])new Object[0]);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, ZKBaseFontUtil.getBodyFont(value)));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(1);
        row.addCell(cell);
    }

    private static int[] getHeadWidthsForPdf(List<GridColumnItem> fieldList) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (GridColumnItem column : fieldList) {
            int sum = DHX_CSPAN.equals(column.getLabel()) ? (Integer)list.remove(list.size() - 1) + Integer.parseInt(column.getWidth()) : Integer.parseInt(column.getWidth());
            list.add(sum);
        }
        return list.stream().mapToInt(Integer::valueOf).toArray();
    }

    private static <T> void createComplexHeaderForPdf(ExportParameterItem<T> params) throws DocumentException {
        List<GridColumnItem> fieldList = params.getColumnItems();
        int[] w = BigExcelUtil.getHeadWidthsForPdf(fieldList);
        PdfPTable row = new PdfPTable(w.length);
        row.setWidthPercentage(100.0f);
        PdfPTable row2 = null;
        int i = 0;
        while (i < fieldList.size()) {
            GridColumnItem column = fieldList.get(i);
            if (StringUtils.isBlank((CharSequence)column.getSecHeader())) {
                BigExcelUtil.createHeaderCellForPdf(row, column.getLabel(), true);
            } else {
                PdfPCell cell = new PdfPCell();
                cell.setPadding(0.0f);
                cell.setBackgroundColor(new BaseColor(217, 217, 217));
                PdfPTable row1 = new PdfPTable(1);
                row1.setWidthPercentage(100.0f);
                BigExcelUtil.createHeaderCellForPdf(row1, column.getLabel(), true);
                int sum = Integer.parseInt(column.getWidth());
                ArrayList<Integer> ww = new ArrayList<Integer>();
                ww.add(sum);
                ArrayList<PdfPCell> cols = new ArrayList<PdfPCell>();
                cols.add(BigExcelUtil.createHeaderCellForPdf(row2, column.getSecHeader(), false));
                while (++i < fieldList.size()) {
                    GridColumnItem col = fieldList.get(i);
                    if (!DHX_CSPAN.equals(col.getLabel())) {
                        --i;
                        break;
                    }
                    cols.add(BigExcelUtil.createHeaderCellForPdf(row2, col.getSecHeader(), true));
                    sum += Integer.parseInt(col.getWidth());
                    ww.add(Integer.parseInt(col.getWidth()));
                }
                row2 = new PdfPTable(cols.size());
                row2.setWidthPercentage(100.0f);
                row2.setExtendLastRow(true);
                for (PdfPCell c : cols) {
                    row2.addCell(c);
                }
                row1.setWidths(new int[]{sum});
                row2.setWidths(ww.stream().mapToInt(Integer::valueOf).toArray());
                cell.addElement((Element)row1);
                cell.addElement((Element)row2);
                row.addCell(cell);
            }
            ++i;
        }
        row.setWidths(w);
        params.getDoc().add((Element)row);
    }

    private static <T> void createHeaderForXls(ExportParameterItem<T> params) {
        SXSSFWorkbook book = new SXSSFWorkbook(1000);
        book.setCompressTempFiles(true);
        SXSSFSheet sheet = book.createSheet(params.getTableName());
        CellStyle headStyle = BigExcelUtil.getHeadCellStyle((Workbook)book);
        CellStyle dataStyle = BigExcelUtil.getDataCellStyle((Workbook)book);
        params.setBook((Workbook)book);
        params.setSheet((Sheet)sheet);
        params.setHeadStyle(headStyle);
        params.setDataStyle(dataStyle);
        List<GridColumnItem> fieldList = params.getColumnItems();
        int rowNum = 2;
        SXSSFRow titleRow = sheet.createRow(0);
        Cell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(params.getTableName().replaceAll("\\+", " "));
        titleCell.setCellStyle(params.getHeadStyle());
        if (fieldList.size() > 1) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fieldList.size() - 1));
        }
        if (BigExcelUtil.isComplexColumn(fieldList)) {
            rowNum = 3;
            BigExcelUtil.createComplexHeaderForXls(params);
        } else {
            SXSSFRow headRow = sheet.createRow(1);
            int i = 0;
            while (i < fieldList.size()) {
                GridColumnItem column = fieldList.get(i);
                BigExcelUtil.createCellForXls((Sheet)sheet, (Row)headRow, i, column.getWidth(), column.getLabel(), params.getDataStyle());
                ++i;
            }
        }
        params.setHeadRowNumber(rowNum);
        sheet.createFreezePane(0, rowNum, 0, rowNum);
    }

    private static void createCellForXls(Sheet sheet, Row row, int colInd, String width, String label, CellStyle style) {
        Cell cell = row.createCell(colInd);
        sheet.setColumnWidth(colInd, 50 * Integer.parseInt(width));
        cell.setCellValue(I18nUtil.i18nCode((String)(StringUtils.isBlank((CharSequence)label) ? "" : label), (Object[])new Object[0]));
        cell.setCellStyle(style);
    }

    private static <T> void createComplexHeaderForXls(ExportParameterItem<T> params) {
        Workbook book = params.getBook();
        Sheet sheet = params.getSheet();
        List<GridColumnItem> fieldList = params.getColumnItems();
        Row row1 = sheet.createRow(1);
        Row row2 = sheet.createRow(2);
        int firstColIndex = 0;
        int i = 0;
        while (i < fieldList.size()) {
            GridColumnItem column = fieldList.get(i);
            if (StringUtils.isBlank((CharSequence)column.getSecHeader())) {
                BigExcelUtil.createCellForXls(sheet, row1, i, column.getWidth(), column.getLabel(), params.getHeadStyle());
                BigExcelUtil.createCellForXls(sheet, row2, i, column.getWidth(), "", params.getHeadStyle());
                sheet.addMergedRegion(new CellRangeAddress(1, 2, i, i));
            } else {
                if (DHX_CSPAN.equals(column.getLabel())) {
                    if (i - firstColIndex > 1) {
                        sheet.removeMergedRegion(sheet.getNumMergedRegions() - 1);
                    }
                    BigExcelUtil.createCellForXls(sheet, row1, i, column.getWidth(), "", params.getHeadStyle());
                    sheet.addMergedRegion(new CellRangeAddress(1, 1, firstColIndex, i));
                } else {
                    BigExcelUtil.createCellForXls(sheet, row1, i, column.getWidth(), column.getLabel(), params.getHeadStyle());
                    firstColIndex = i;
                }
                BigExcelUtil.createCellForXls(sheet, row2, i, column.getWidth(), column.getSecHeader(), params.getHeadStyle());
            }
            ++i;
        }
    }

    private static boolean isComplexColumn(List<GridColumnItem> fieldList) {
        for (GridColumnItem item : fieldList) {
            if (!StringUtils.isNotBlank((CharSequence)item.getSecHeader())) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static <T> List<GridColumnItem> getGridColumns(JSONObject columns, Class<T> cls, List<T> data) {
        exportColumns = new ArrayList<GridColumnItem>();
        keys = columns.keySet();
        block4: for (String fieldName : keys) {
            try {
                field = cls.getDeclaredField(fieldName);
                field.setAccessible(true);
                columnAnno = field.getAnnotation(GridColumn.class);
                if (Objects.nonNull(columnAnno) && !columnAnno.isExportExcel()) continue;
                if (StringUtils.isNotBlank((CharSequence)columnAnno.dynamicColumn())) {
                    try {
                        dc = (DynamicColumn)SpringContextUtil.getBean((String)columnAnno.dynamicColumn(), DynamicColumn.class);
                        items = dc.getColumn(fieldName);
                        if (!Objects.nonNull(items)) continue;
                        exportColumns.addAll(items);
                        continue;
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        if (!"java.util.Map".equals(field.getType().getTypeName()) || !Objects.nonNull(data) || data.size() <= 0) continue;
                        extraMap = (Map)field.get(data.get(0));
                        ** for (key : extraMap.keySet())
                    }
lbl-1000:
                    // 1 sources

                    {
                        column = new GridColumnItem();
                        column.setFieldName(fieldName);
                        column.setLabel(key);
                        column.setName(key);
                        exportColumns.add(column);
                        continue;
lbl28:
                        // 1 sources

                        continue block4;
                    }
                }
                if ("java.util.Map".equals(field.getType().getTypeName()) && Objects.nonNull(data) && data.size() > 0) {
                    extraMap = (Map)field.get(data.get(0));
                    for (String key : extraMap.keySet()) {
                        column = new GridColumnItem();
                        column.setFieldName(fieldName);
                        column.setLabel(key);
                        column.setName(key);
                        exportColumns.add(column);
                    }
                    continue;
                }
                column = new GridColumnItem(columnAnno);
                column.setFieldName(fieldName);
                column.setName(fieldName);
                exportColumns.add(column);
            }
            catch (Exception e) {
                BigExcelUtil.log.error("Get Columm Field Failure", (Throwable)e);
            }
        }
        return exportColumns;
    }

    private static <T> void createBodyForXls(ExportParameterItem<T> params) {
        List<T> data = params.getData();
        Sheet sheet = params.getSheet();
        List<GridColumnItem> fieldList = params.getColumnItems();
        if (Objects.nonNull(data) && data.size() > 0) {
            int i = 0;
            while (i < data.size()) {
                T item = data.get(i);
                Row row = sheet.createRow(params.getHeadRowNumber() + i);
                int j = 0;
                while (j < fieldList.size()) {
                    String value = BigExcelUtil.getFieldValue(item, fieldList.get(j), params.getMap());
                    BigExcelUtil.createCellForXls(sheet, row, j, fieldList.get(j).getWidth(), value, params.getDataStyle());
                    ++j;
                }
                ++i;
            }
        }
    }

    private static <T> void createBodyForPdf(ExportParameterItem<T> params) throws DocumentException {
        List<T> data = params.getData();
        List<GridColumnItem> fieldList = params.getColumnItems();
        if (Objects.nonNull(data) && data.size() > 0) {
            for (T item : data) {
                PdfPTable row = new PdfPTable(fieldList.size());
                row.setWidthPercentage(100.0f);
                int[] w = new int[fieldList.size()];
                int j = 0;
                while (j < fieldList.size()) {
                    GridColumnItem column = fieldList.get(j);
                    String value = BigExcelUtil.getFieldValue(item, column, params.getMap());
                    BigExcelUtil.createCellForPdf(row, value);
                    w[j] = Integer.parseInt(column.getWidth());
                    ++j;
                }
                row.setWidths(w);
                params.getDoc().add((Element)row);
            }
        }
    }

    private static <T> String getFieldValue(T obj, GridColumnItem column, Map<String, Map<String, String>> map) {
        String value = "";
        if (Objects.nonNull(obj) && StringUtils.isNotBlank((CharSequence)column.getName())) {
            try {
                Field field = obj.getClass().getDeclaredField(column.getFieldName());
                field.setAccessible(true);
                Object cellObject = field.get(obj);
                if (Objects.isNull(cellObject)) {
                    return value;
                }
                if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                    DateType dateType = field.getAnnotation(DateType.class);
                    String format = ExcelUtil.getDateFormt(dateType);
                    value = new SimpleDateFormat(format).format(cellObject);
                } else if (cellObject instanceof Map) {
                    Map map1 = (Map)cellObject;
                    if (Objects.nonNull(map1.get(column.getName()))) {
                        value = map1.get(column.getName()).toString();
                    } else if (StringUtils.isNotBlank((CharSequence)column.getLabel()) && Objects.nonNull(map1.get(I18nUtil.i18nCode((String)column.getLabel(), (Object[])new Object[0])))) {
                        value = map1.get(I18nUtil.i18nCode((String)column.getLabel(), (Object[])new Object[0])).toString();
                    }
                } else if (COLUMN_TYPE_DIC.equals(column.getColumnType())) {
                    if (map.containsKey(column.getKey())) {
                        value = map.get(column.getKey()).get(cellObject.toString());
                    }
                    if (StringUtils.isBlank((CharSequence)value)) {
                        value = cellObject.toString();
                    }
                } else {
                    value = StringUtils.isNotBlank((CharSequence)column.getFormat()) ? GridUtil.getDictionaryVal(column.getFormat(), cellObject) : (map.containsKey(column.getFieldName()) ? map.get(column.getFieldName()).get(cellObject.toString()) : cellObject.toString());
                }
                if (Objects.isNull(value)) {
                    value = cellObject.toString();
                }
            }
            catch (Exception e) {
                log.error("Get Field Value Failure!", (Throwable)e);
                e.printStackTrace();
            }
        }
        return value;
    }

    public static <T> void exportPdf(ExportParameterItem<T> params) throws Exception {
        BigExcelUtil.createHeaderForPdf(params);
        BigExcelUtil.createBodyForPdf(params);
        params.getDoc().close();
        params.getPdfWriter().close();
    }

    public static <T> void exportCsv(ExportParameterItem<T> params) throws IOException {
        byte[] uft8bom = new byte[]{-17, -69, -65};
        params.getOutputStream().write(uft8bom);
        OutputStreamWriter osw = new OutputStreamWriter(params.getOutputStream(), StandardCharsets.UTF_8);
        BufferedWriter bw = new BufferedWriter(osw);
        params.setBw(bw);
        BigExcelUtil.createHeaderForCsv(params);
        BigExcelUtil.createBodyForCsv(params);
        bw.flush();
        params.getOutputStream().close();
        bw.close();
        osw.close();
    }

    private static void createCellForCsv(BufferedWriter bw, String value) throws IOException {
        value = StringUtils.isBlank((CharSequence)value) ? "" : I18nUtil.i18nCode((String)value, (Object[])new Object[0]);
        bw.append("\"");
        bw.append(value);
        bw.append("\"");
        bw.append(",");
    }

    private static <T> void createHeaderForCsv(ExportParameterItem<T> params) throws IOException {
        List<GridColumnItem> fieldList = params.getColumnItems();
        BufferedWriter bw = params.getBw();
        BigExcelUtil.createCellForCsv(bw, params.getTableName().replaceAll("\\+", " "));
        bw.append(System.getProperty("line.separator"));
        for (GridColumnItem column : fieldList) {
            String value = StringUtils.isNotBlank((CharSequence)column.getSecHeader()) ? column.getSecHeader() : column.getLabel();
            value = value.replaceAll("\\+", " ");
            BigExcelUtil.createCellForCsv(bw, value);
        }
        bw.append(System.getProperty("line.separator"));
    }

    private static <T> void createBodyForCsv(ExportParameterItem<T> params) throws IOException {
        List<T> data = params.getData();
        List<GridColumnItem> fieldList = params.getColumnItems();
        BufferedWriter bw = params.getBw();
        if (Objects.nonNull(data) && data.size() > 0) {
            for (T item : data) {
                for (GridColumnItem column : fieldList) {
                    String value = BigExcelUtil.getFieldValue(item, column, params.getMap());
                    BigExcelUtil.createCellForCsv(bw, value);
                }
                bw.append(System.getProperty("line.separator"));
            }
        }
    }

    public static boolean isBaseType(Object obj) {
        if (obj instanceof Integer || obj instanceof Long) {
            return true;
        }
        if (obj instanceof Double || obj instanceof Float) {
            return true;
        }
        if (obj instanceof Boolean || obj instanceof Short) {
            return true;
        }
        return obj instanceof Byte;
    }

    private static class Header
    extends PdfPageEventHelper {
        private Header() {
        }

        public void onEndPage(PdfWriter pdfWriter, Document document) {
            ColumnText.showTextAligned((PdfContentByte)pdfWriter.getDirectContent(), (int)2, (Phrase)new Phrase("Page:" + pdfWriter.getCurrentPageNumber()), (float)450.0f, (float)30.0f, (float)0.0f);
        }
    }
}

