/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.web.cache.SkinPropertyCache;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ApplicationPropertiesUtil {
    public static String getProperty(String key, String def) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String value = request.getParameter(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getSession().getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = SkinPropertyCache.getProperty(key, request);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getServletContext().getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = SpringContextUtil.getApplicationContext().getEnvironment().getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return def;
    }
}

