/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.config;

import com.zkteco.zkbiosecurity.core.web.converter.StringToDateConverter;
import com.zkteco.zkbiosecurity.core.web.converter.StringToTimeConverter;
import com.zkteco.zkbiosecurity.core.web.listener.WebAppInitListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@ConditionalOnWebApplication
@Configuration
public class WebConfig
implements WebMvcConfigurer {
    @Autowired
    private RequestMappingHandlerAdapter handlerAdapter;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Value(value="${server.session.cookie.http-only:false}")
    private Boolean httpOnly;
    @Value(value="${server.session.cookie.secure:false}")
    private Boolean secure;
    public static String language;

    @Value(value="${system.language:}")
    public void setLanguage(String systemLanguage) {
        language = systemLanguage;
    }

    @PostConstruct
    public void initEditableValidation() {
        ConfigurableWebBindingInitializer initializer = (ConfigurableWebBindingInitializer)this.handlerAdapter.getWebBindingInitializer();
        if (initializer.getConversionService() != null) {
            GenericConversionService genericConversionService = (GenericConversionService)initializer.getConversionService();
            genericConversionService.addConverter((Converter)new StringToDateConverter());
            genericConversionService.addConverter((Converter)new StringToTimeConverter());
        }
    }

    public MappingJackson2HttpMessageConverter customJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(new MediaType(MediaType.TEXT_HTML, Charset.forName("UTF-8")));
        jsonConverter.setSupportedMediaTypes(supportedMediaTypes);
        return jsonConverter;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.customJackson2HttpMessageConverter());
    }

    @Bean
    public ServletListenerRegistrationBean<WebAppInitListener> contextListenerBean() {
        ServletListenerRegistrationBean contextListener = new ServletListenerRegistrationBean((EventListener)((Object)new WebAppInitListener()));
        return contextListener;
    }

    @Bean
    public LocaleResolver localeResolver() {
        CookieLocaleResolver slr = new CookieLocaleResolver();
        Locale locale = null;
        if (StringUtils.isNotBlank((CharSequence)language)) {
            if (language.contains("_")) {
                String[] languageCountry = language.split("_");
                locale = new Locale(languageCountry[0], languageCountry[1]);
            } else {
                locale = new Locale(language);
            }
        }
        if (this.httpOnly.booleanValue()) {
            slr.setCookieHttpOnly(true);
        }
        if (this.secure.booleanValue()) {
            slr.setCookieSecure(true);
        }
        slr.setDefaultLocale(locale == null ? Locale.US : locale);
        return slr;
    }

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor lci = new LocaleChangeInterceptor();
        lci.setParamName("lang");
        return lci;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:" + new File(this.systemFilePath).getAbsolutePath() + "/upload/"}).setCacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.HOURS).cachePublic());
    }
}

