/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.provider.AuthInitDataProvider;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsGroupService;
import com.zkteco.zkbiosecurity.ivs.service.IvsIntelApplicationService;
import com.zkteco.zkbiosecurity.ivs.service.IvsParamsService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGroupItem;
import com.zkteco.zkbiosecurity.system.constants.BaseDataConstants;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryItem;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=190)
public class IvsInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(IvsInit.class);
    @Autowired(required=false)
    private BaseSysParamService baseSysParamService;
    @Autowired(required=false)
    private AuthPermissionService authPermissionService;
    @Autowired(required=false)
    private AuthInitDataProvider authInitDataProvider;
    @Autowired(required=false)
    private BaseDictionaryService baseDictionaryService;
    @Autowired(required=false)
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private IvsParamsService ivsParamsService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;
    @Autowired
    private IvsIntelApplicationService ivsIntelApplicationService;
    @Autowired
    private IvsGroupService ivsGroupService;
    @Value(value="${system.language}")
    private String language;
    @Value(value="${system.productCode}")
    private String productCode;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;

    public void run(String ... strings) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("IvsInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initIvsDictionary();
            this.initIvsVidParams();
            this.ivsEdgeDeviceService.initDataToRedis();
            this.ivsIntelApplicationService.initDataToRedis();
            this.initUpgradeVersion();
            this.initUpgradeMenu();
            this.baseSysParamService.setAlreadyInitModule("IvsInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = null;
        AuthPermissionItem parentMenuItem = null;
        AuthPermissionItem childMenuItem = null;
        AuthPermissionItem buttonMenuItem = null;
        systemItem = new AuthPermissionItem("IVS", "ivs_integrated_video", "ivs", "system", "true", Integer.valueOf(19));
        systemItem = this.authInitDataProvider.initPermissionData(systemItem);
        parentMenuItem = new AuthPermissionItem("IvsVideoView", "ivs_view_video", "ivs:video:view", "menu", "true", Integer.valueOf(1));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("ivs_record.png");
        parentMenuItem.setImgHover("ivs_record_over.png");
        parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("IvsVidPreview", "ivs_iClient_videoPreView", "ivs:preview", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsPreview.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginPreview", "ivs_iClient_videoPreView", "iClient:plugin:preview", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginPTZConsole", "ivs_plugin_ptzConsole", "iClient:plugin:ptzConsole", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginSnapShot", "ivs_intercom_capture", "iClient:plugin:snapShot", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginRecord", "ivs_record_enable", "iClient:plugin:record", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginEnlarge", "ivs_plugin_enlarge", "iClient:plugin:enlarge", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginPTZVoice", "ivs_plugin_voice", "iClient:plugin:voice", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("IvsVidPlayback", "ivs_iClient_videoPlayback", "ivs:playback", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsPlayback.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginPlayback", "ivs_iClient_videoPlayback", "iClient:plugin:playback", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginDownLoad", "ivs_plugin_downLoad", "iClient:plugin:downLoad", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginPBSnapShot", "ivs_intercom_capture", "iClient:plugin:PB:snapShot", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IClientPluginPBEnlarge", "ivs_plugin_enlarge", "iClient:plugin:PB:enlarge", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("IvsDeviceManagement", "ivs_device_management", "ivs:device:management", "menu", "true", Integer.valueOf(2));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("ivs_device.png");
        parentMenuItem.setImgHover("ivs_device_over.png");
        parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("IvsVidClientDevice", "ivs_ext_device_manager", "ivs:parentDevice", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsClientParentDevice.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceRefresh", "common_op_refresh", "ivs:parentDevice:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceAdd", "common_op_new", "ivs:parentDevice:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceSearchDev", "common_dev_searchDev", "ivs:parentDevice:searchDev", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceDel", "common_op_del", "ivs:parentDevice:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceSynchronize", "ivs_iClient_synchronization", "ivs:parentDevice:synchronize", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceEdit", "common_op_edit", "ivs:parentDevice:edit", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        if (!"ZKBioAccess".equals(this.productCode)) {
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceTargetAnalysis", "ivs_target_analysis", "ivs:parentDevice:targetAnalysis", "button", "true", Integer.valueOf(7));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        }
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceMaintenanceApp", "ivs_iClient_maintenanceApp", "ivs:parentDevice:maintenanceApp", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceView", "ivs_viewInformation", "ivs:parentDevice:view", "button", "true", Integer.valueOf(9));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        if (!"ZKBioAccess".equals(this.productCode)) {
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceFrequency", "ivs_persFrequencyAnalysis", "ivs:parentDevice:frequency", "button", "true", Integer.valueOf(10));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceFace", "ivs_iClient_face_control", "ivs:parentDevice:suspect", "button", "true", Integer.valueOf(11));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceVehicle", "ivs_iClient_vehicle_control", "ivs:parentDevice:suspect", "button", "true", Integer.valueOf(12));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceAlarmManage", "ivs_iClient_alarm_manage", "ivs:parentDevice:alarmManagement", "button", "true", Integer.valueOf(13));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceVehicleList", "ivs_iClient_vehicle_list_database", "ivs:parentDevice:vehicleList", "button", "true", Integer.valueOf(14));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceTaskManage", "ivs_iClient_task_manage", "ivs:parentDevice:taskManage", "button", "true", Integer.valueOf(15));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceFaceList", "ivs_iClient_face_list_database", "ivs:parentDevice:faceList", "button", "true", Integer.valueOf(16));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceStorageManage", "ivs_iClient_storage_manage", "ivs:parentDevice:storageManage", "button", "true", Integer.valueOf(17));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsMainDeviceAlgorithm", "ivs_third_algorithm_configuration", "ivs:parentDevice:algorithm", "button", "true", Integer.valueOf(18));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        }
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceSubscription", "ivs_vid_parentDevice_subscription", "ivs:parentDevice:subscription", "button", "true", Integer.valueOf(19));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceUnsuscription", "ivs_vid_parentDevice_unsuscription", "ivs:parentDevice:unsuscription", "button", "true", Integer.valueOf(20));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceSyncTime", "ivs_vid_parentDevice_syncTime", "ivs:parentDevice:syncTime", "button", "true", Integer.valueOf(21));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceReboot", "ivs_ext_device_reboot", "ivs:parentDevice:reboot", "button", "true", Integer.valueOf(22));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMainDeviceEmailConfig", "ivs_iClient_email_config", "ivs:parentDevice:emailConfig", "button", "true", Integer.valueOf(26));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsSubDeviceArea", "ivs_iClient_adjustment_area", "ivs:subDevice:area", "button", "true", Integer.valueOf(31));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsParentDeviceBasicConfig", "ivs_basicConfig", "ivs:parentDevice:basicConfig", "button", "true", Integer.valueOf(33));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsSubDeviceCapture", "ivs_alarm_linkCapture", "ivs:subDevice:capture", "button", "true", Integer.valueOf(34));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsSubDeviceMaintenance", "ivs_iClient_maintenanceApp", "ivs:subDevice:maintenance", "button", "true", Integer.valueOf(35));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsSubDeviceStream", "ivs_rtsp_stream", "ivs:subDevice:stream", "button", "true", Integer.valueOf(36));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("IvsVidChannel", "ivs_camera", "ivs:clientDevice:channel", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsDevice.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsAllDeviceRefresh", "common_op_refresh", "ivs:subDevice:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsSdcDeviceAdd", "common_op_new", "vid:device:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsSdcDeviceDel", "common_op_del", "ivs:device:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsSdcDeviceSearch", "common_dev_searchDev", "ivs:device:searchDev", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsSubDeviceReboot", "ivs_ext_device_reboot", "ivs:device:reboot", "button", "true", Integer.valueOf(32));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsChannelRefresh", "common_op_refresh", "ivs:channel:refresh", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("IvsChannel", "ivs_group_management", "ivs:channelGroup", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsChannel.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGroupChannelRefresh", "common_op_refresh", "ivs:channelGroup:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGroupChannelAdd", "common_op_new", "ivs:channelGroup:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGroupChannelEdit", "common_op_edit", "ivs:channelGroup:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGroupChannelDel", "common_op_del", "ivs:channelGroup:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsChannelDeviceRefresh", "common_op_refresh", "ivs:channel:refresh", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsChannelDeviceEdit", "ivs_iClient_add_camera", "ivs:channel:edit", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsChannelDeviceDel", "common_op_del", "ivs:channel:del", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("IvsTvWallManager", "ivs_decoder_decodingOnWall", "ivs:tvWallManager", "menu", "true", Integer.valueOf(3));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("ivs_decodingOnWall.png");
        parentMenuItem.setImgHover("ivs_decodingOnWall_over.png");
        parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("IvsDecoder", "ivs_decoder", "ivs:decoder", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsDecoder.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsDecoderRefresh", "common_op_refresh", "ivs:decoder:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsDecoderAdd", "common_op_new", "ivs:decoder:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsDecoderEdit", "common_op_edit", "ivs:decoder:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsDecoderDel", "common_op_del", "ivs:decoder:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("IvsTvWall", "ivs_iClient_TVWall", "ivs:tvWall", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsTvWall.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsTvWallRefresh", "common_op_refresh", "ivs:tvWall:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsTvWallAdd", "common_op_new", "ivs:tvWall:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsTvWallEdit", "common_op_edit", "ivs:tvWall:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsTvWallDel", "common_op_del", "ivs:tvWall:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("IvsSchemeManager", "ivs_decoder_screenControl", "ivs:schemeManager", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsSchemeManager.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        if ("zh_CN".equals(this.language)) {
            parentMenuItem = new AuthPermissionItem("IvsRetrieval", "ivs_retrieval", "ivs:retrieval:manager", "menu", "true", Integer.valueOf(4));
            parentMenuItem.setParentId(systemItem.getId());
            parentMenuItem.setImg("ivs_retrieval.png");
            parentMenuItem.setImgHover("ivs_retrieval_over.png");
            parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
            childMenuItem = new AuthPermissionItem("IvsFaceSearch", "ivs_faceSearch", "ivs:face:search", "menu", "true", Integer.valueOf(1));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsFaceSearch.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsFaceSearchExport", "common_op_export", "ivs:faceSearch:export", "button", "true", Integer.valueOf(1));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            childMenuItem = new AuthPermissionItem("IvsVehicleRetrieval", "ivs_vehicleRetrieval", "ivs:retrieval:vehicle", "menu", "true", Integer.valueOf(2));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsVehicleRetrieval.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsVehicleRetrievalExport", "common_op_export", "ivs:vehicleRetrieval:export", "button", "true", Integer.valueOf(1));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            childMenuItem = new AuthPermissionItem("IvsFaceComparison", "ivs_face_comparison", "ivs:retrieval:comparison", "menu", "true", Integer.valueOf(4));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsFaceComparison.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            childMenuItem = new AuthPermissionItem("IvsSearchByImage", "ivs_searchByImage", "ivs:search:image", "menu", "true", Integer.valueOf(5));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsSearchByImage.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsSearchByImageExport", "common_op_export", "ivs:searchByImage:export", "button", "true", Integer.valueOf(1));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        }
        parentMenuItem = new AuthPermissionItem("IvsStatistic", "ivs_iClient_intelligent", "ivs:ext:statistic", "menu", "true", Integer.valueOf(5));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("ivs_intelligent.png");
        parentMenuItem.setImgHover("ivs_intelligent_over.png");
        parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
        if ("zh_CN".equals(this.language)) {
            childMenuItem = new AuthPermissionItem("IvsAlgorithm", "ivs_algorithm", "ivs:ext:algorithm", "menu", "true", Integer.valueOf(1));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("algorithm.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsAlgorithmRefresh", "common_op_refresh", "ivs:algorithm:refresh", "button", "true", Integer.valueOf(1));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsAlgorithmSynchronize", "ivs_getAlgorithm", "ivs:algorithm:synchronize", "button", "true", Integer.valueOf(2));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsAlgorithmEdit", "ivs_setAlgorithm", "ivs:algorithm:edit", "button", "true", Integer.valueOf(3));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
            childMenuItem = new AuthPermissionItem("IvsFaceIntelligent", "ivs_intelligent_face", "ivs:ext:faceIntelligent", "menu", "true", Integer.valueOf(2));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("faceIntelligent.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        }
        childMenuItem = new AuthPermissionItem("IvsBehaviouralAnalysis ", "ivs_vid_behaviorAnalysis", "ivs:ext:behaviouralAnalysis", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("behaviouralAnalysis.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        childMenuItem = new AuthPermissionItem("IvsCrowdSituational", "ivs_crowd_situational", "ivs:ext:crowdSituational", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("crowdSituational.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        childMenuItem = new AuthPermissionItem("IvsGeneralIntel", "ivs_generalIntelligence", "ivs:ext:ivsGeneralIntel", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsGeneralIntel.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        if ("zh_CN".equals(this.language)) {
            childMenuItem = new AuthPermissionItem("IvsVehicleIntelligence", "ivs_VehicleIntelligence", "ivs:ext:vehicleIntelligence", "menu", "true", Integer.valueOf(6));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsVehicleIntelligence.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        }
        if ("zh_CN".equals(this.language)) {
            childMenuItem = new AuthPermissionItem("IvsIntelApplication", "ivs_intelligent_application", "ivs:ext:intelligenceApplication", "menu", "true", Integer.valueOf(8));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsIntelApplication.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsIntelApplicationMixeCheck", "ivs_mixeCheck_largeScreen", "ivs:intelApplication:mixeCheck", "button", "true", Integer.valueOf(1));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsIntelApplicationAlarmLatest", "ivs_alarm_live", "ivs:intelApplication:alarmLatest", "button", "true", Integer.valueOf(2));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        } else {
            childMenuItem = new AuthPermissionItem("IvsIntelApplicationAlarmLatest", "ivs_alarm_live", "ivs:intelApplication:alarmLatest", "menu", "true", Integer.valueOf(8));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsAlarmLatest.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        }
        childMenuItem = new AuthPermissionItem("IvsGlobalLinkage", "ivs_leftMenu_globalLinkage", "ivs:ext:globalLinkage", "menu", "true", Integer.valueOf(9));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsGlobalLinkage.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkageRefresh", "common_op_refresh", "ivs:globalLinkage:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkageAdd", "common_op_add", "ivs:globalLinkage:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkageEdit", "common_op_edit", "ivs:globalLinkage:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkageDel", "common_op_del", "ivs:globalLinkage:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkageAddPerson", "pers_common_addPerson", "ivs:globalLinkage:addPerson", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkageDelPerson", "pers_common_delPerson", "ivs:globalLinkage:delPerson", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkageEnable", "common_enable", "ivs:globalLinkage:enable", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkageDisable", "common_disable", "ivs:globalLinkage:disable", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("IvsGlobalLinkTransaction", "ivs_leftMenu_globalLinkTransaction", "ivs:ext:globalLinkTransaction", "menu", "true", Integer.valueOf(10));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsGlobalLinkageTransaction.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkTransactionRefresh", "common_op_refresh", "ivs:globalLinkTransaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsGlobalLinkTransactionClearData", "common_op_clearData", "ivs:globalLinkTransaction:clearData", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("IvsVidStatistics", "ivs_iClient_statistics", "ivs:statistics:manager", "menu", "true", Integer.valueOf(6));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("ivs_statistics.png");
        parentMenuItem.setImgHover("ivs_statistics_over.png");
        parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
        if ("zh_CN".equals(this.language)) {
            childMenuItem = new AuthPermissionItem("IvsCcStatistics", "ivs_ext_ccStatistics", "ivs:ext:ccStatistics", "menu", "true", Integer.valueOf(3));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsCcStatistics.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsCcStatisticsRefresh", "common_op_refresh", "ivs:ccStatistics:refresh", "button", "true", Integer.valueOf(1));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsCcStatisticsExport", "common_op_export", "ivs:ccStatistics:export", "button", "true", Integer.valueOf(2));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
            childMenuItem = new AuthPermissionItem("IvsHeatMapStatistics", "ivs_ext_heatMapStatistics", "ivs:ext:heatMapStatistics", "menu", "true", Integer.valueOf(4));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsHeatMapStatistics.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            childMenuItem = new AuthPermissionItem("IvsHeatMapStatisticsRefresh", "common_op_refresh", "ivs:heatMapStatistics:refresh", "button", "true", Integer.valueOf(1));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            childMenuItem = new AuthPermissionItem("IvsHeatMapStatisticsExport", "common_op_export", "ivs:heatMapStatistics:export", "button", "true", Integer.valueOf(2));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            childMenuItem = new AuthPermissionItem("IvsObjectStatistics", "ivs_ObjectStatistics", "ivs:objectStatistics", "menu", "true", Integer.valueOf(5));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsObjectStatistics.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        }
        childMenuItem = new AuthPermissionItem("IvsAlarmHistory", "ivs_alarm_history", "ivs:alarmHistory", "menu", "true", Integer.valueOf(7));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsAlarmHistory.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsAlarmHistoryExport", "common_op_export", "ivs:alarmHistory:export", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsAlarmHistoryDetail", "vid_common_details", "esdc:transaction:viewDetail", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        this.initSubMenuItemIvsPatrolReport(parentMenuItem, 8);
        this.initSubMenuItemIvsPatrolAlarmReport(parentMenuItem, 9);
        parentMenuItem = this.initMenuItemIvsPatrolManagement(systemItem, 7);
        this.initSubMenuItemIvsPatrolGroup(parentMenuItem, 1);
        this.initSubMenuItemIvsPatrolPlan(parentMenuItem, 2);
        this.initSubMenuItemVidRtPatrol(parentMenuItem, 3);
        parentMenuItem = new AuthPermissionItem("IvsMap", "ivs_map_management", "ivs:map", "menu", "true", Integer.valueOf(8));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("map.png");
        parentMenuItem.setImgHover("map_over.png");
        parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("IvsMapVideo", "ivs_map_video", "ivs:map:video", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsMap.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMapRefresh", "common_op_refresh", "ivs:map:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMapAdd", "common_op_add", "ivs:map:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMapEdit", "common_op_edit", "ivs:map:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMapDel", "common_op_del", "ivs:map:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMapSaveMapPos", "common_op_savePositon", "ivs:map:saveMapPos", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsMapAddChannelToMap", "ivs_iClient_add_camera", "ivs:map:addChannelToMap", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        if (!"zh_CN".equals(this.language)) {
            parentMenuItem = new AuthPermissionItem("IvsIntercom", "ivs_intercom", "ivs:intercom", "menu", "true", Integer.valueOf(9));
            parentMenuItem.setParentId(systemItem.getId());
            parentMenuItem.setImg("ivs_intercom.png");
            parentMenuItem.setImgHover("ivs_intercom_over.png");
            parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
            childMenuItem = new AuthPermissionItem("IvsIntercomDevice", "ivs_intercom_Device", "ivs:intercomDevice", "menu", "true", Integer.valueOf(1));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsIntercomDevice.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsIntercomDeviceRefresh", "common_op_refresh", "ivs:intercomDevice:refresh", "button", "true", Integer.valueOf(2));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.initData(buttonMenuItem);
            childMenuItem = new AuthPermissionItem("IvsIntercomTransaction", "ivs_intercom_transaction", "ivs:intercomTransaction", "menu", "true", Integer.valueOf(1));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("ivsIntercomTransaction.do");
            childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsIntercomTransactionRefresh", "common_op_refresh", "ivs:intercomTransaction:refresh", "button", "true", Integer.valueOf(1));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.initData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsIntercomTransactionClearAll", "common_op_clearData", "ivs:intercomTransaction:del", "button", "true", Integer.valueOf(2));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.initData(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("IvsIntercomTransactionExport", "common_op_export", "ivs:intercomTransaction:export", "button", "true", Integer.valueOf(3));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.initData(buttonMenuItem);
        }
        parentMenuItem = new AuthPermissionItem("VindicateMangeManagement", "ivs_maintenance_configuration", "ivs:vindicateMangeManagement", "menu", "true", Integer.valueOf(10));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("ivs_operation.png");
        parentMenuItem.setImgHover("ivs_operation_over.png");
        parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("IvsDevelopersLog", "ivs_system_developerLog", "system:developersLog", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsDevelopersLog.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        childMenuItem = new AuthPermissionItem("IvsClientRequestLog", "ivs_IcClientRequestLog", "ivs:ClientRequestLog", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsClientRequestLog.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsClientRequestLogRefresh", "common_op_refresh", "ivs:ClientRequestLog:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsClientRequestLogClear", "common_op_clearData", "ivs:ClientRequestLog:clear", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsClientRequestLogExport", "common_op_export", "ivs:ClientRequestLog:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("IvsRequestLog", "ivs_requestLog", "ivs:requestLog", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsRequestLog.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsRequestLogRefresh", "common_op_refresh", "ivs:ivsRequestLog:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsRequestLogClear", "common_op_clearData", "ivs:ivsRequestLog:clear", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("IvsRequestLogExport", "common_op_export", "ivs:ivsRequestLog:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authInitDataProvider.initPermissionData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("IvsParams", "common_leftMenu_paramSet", "system:params", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsParams.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
        parentMenuItem = new AuthPermissionItem("IvsRtmpStream", "ivs_rtmp_stream", "ivs:rtmp:stream", "menu", "true", Integer.valueOf(11));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("ivs_operation.png");
        parentMenuItem.setImgHover("ivs_operation_over.png");
        parentMenuItem = this.authInitDataProvider.initPermissionData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("IvsRtmpStreamManage", "ivs_rtmp_stream_manage", "ivs:rtmp:stream:manage", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("ivsRtmpStream.do");
        childMenuItem = this.authInitDataProvider.initPermissionData(childMenuItem);
    }

    private AuthPermissionItem initMenuItemIvsPatrolManagement(AuthPermissionItem systemItem, Integer topMenuItemOrderNo) {
        AuthPermissionItem topMenuItem = new AuthPermissionItem("IvsPatrolManagement", "ivs_leftMenu_ivsPatrolManagement", "ivs:patrol:manager", "menu", "true", topMenuItemOrderNo);
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setActionLink("ivsPatrolPlan.do");
        topMenuItem.setImg("ivs_patrol.png");
        topMenuItem.setImgHover("ivs_patrol_over.png");
        topMenuItem = this.authPermissionService.saveItem(topMenuItem);
        return topMenuItem;
    }

    private void initSubMenuItemIvsPatrolGroup(AuthPermissionItem topMenuItem, Integer subMenuItemOrderNo) {
        Integer subButtonItemOrderNo;
        AuthPermissionItem subMenuItem = new AuthPermissionItem("IvsPatrolGroup", "ivs_leftMenu_ivsPatrolGroup", "ivs:patrolGroup", "menu", "true", subMenuItemOrderNo);
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("ivsPatrolGroup.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = null;
        Integer n = subButtonItemOrderNo = Integer.valueOf(0);
        Integer n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolGroupRefresh", "common_op_refresh", "ivs:patrolGroup:refresh", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolGroupAdd", "common_op_new", "ivs:patrolGroup:add", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolGroupEdit", "common_op_edit", "ivs:patrolGroup:edit", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolGroupDel", "common_op_del", "ivs:patrolGroup:del", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolGroupRefreshUser", "common_op_refresh", "ivs:patrolGroup:refreshUser", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolGroupAddUser", "ivs_patrolGroup_addUser", "ivs:patrolGroup:addUser", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolGroupDelUser", "ivs_patrolGroup_delUser", "ivs:patrolGroup:delUser", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
    }

    private void initSubMenuItemIvsPatrolPlan(AuthPermissionItem topMenuItem, Integer subMenuItemOrderNo) {
        Integer subButtonItemOrderNo;
        AuthPermissionItem subMenuItem = new AuthPermissionItem("IvsPatrolPlan", "ivs_leftMenu_ivsPatrolPlan", "ivs:patrolPlan", "menu", "true", subMenuItemOrderNo);
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("ivsPatrolPlan.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        AuthPermissionItem subButtonItem = null;
        Integer n = subButtonItemOrderNo = Integer.valueOf(0);
        Integer n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolPlanRefresh", "common_op_refresh", "ivs:patrolPlan:refresh", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolPlanAdd", "common_op_new", "ivs:patrolPlan:add", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolPlanEdit", "common_op_edit", "ivs:patrolPlan:edit", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolPlanDel", "common_op_del", "ivs:patrolPlan:del", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolPlanSendEmail", "ivs_sendEmail", "ivs:patrolPlan:sendEmail", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
    }

    private void initSubMenuItemVidRtPatrol(AuthPermissionItem topMenuItem, Integer subMenuItemOrderNo) {
        AuthPermissionItem subMenuItem = new AuthPermissionItem("IvsRtPatrol", "ivs_leftMenu_vidRtPatrol", "ivs:rtpatrol", "menu", "true", subMenuItemOrderNo);
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("ivsRtPatrol.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
    }

    private void initSubMenuItemIvsPatrolReport(AuthPermissionItem topMenuItem, Integer subMenuItemOrderNo) {
        Integer subButtonItemOrderNo;
        AuthPermissionItem subMenuItem = new AuthPermissionItem("IvsPatrolReport", "ivs_leftMenu_ivsPatrolTransaction", "ivs:patrolReport", "menu", "true", subMenuItemOrderNo);
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("ivsPatrolReport.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        AuthPermissionItem subButtonItem = null;
        Integer n = subButtonItemOrderNo = Integer.valueOf(0);
        Integer n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolReportRefresh", "common_op_refresh", "ivs:patrolReport:refresh", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolReportExport", "common_op_export", "ivs:patrolReport:export", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
    }

    private void initSubMenuItemIvsPatrolAlarmReport(AuthPermissionItem topMenuItem, Integer subMenuItemOrderNo) {
        Integer subButtonItemOrderNo;
        AuthPermissionItem subMenuItem = new AuthPermissionItem("IvsPatrolAlarmReport", "ivs_leftMenu_ivsPatrolAlarm", "ivs:patrolAlarmReport", "menu", "true", subMenuItemOrderNo);
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("ivsPatrolAlarmReport.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        AuthPermissionItem subButtonItem = null;
        Integer n = subButtonItemOrderNo = Integer.valueOf(0);
        Integer n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolAlarmReportRefresh", "common_op_refresh", "ivs:patrolAlarmReport:refresh", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        n = subButtonItemOrderNo;
        n2 = subButtonItemOrderNo = Integer.valueOf(subButtonItemOrderNo + 1);
        subButtonItem = new AuthPermissionItem("IvsPatrolAlarmReportExport", "common_op_export", "ivs:patrolAlarmReport:export", "button", "true", n);
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
    }

    private void initClientMenu() {
        AuthPermissionItem appModuleItem = null;
        AuthPermissionItem appMenuItem = null;
        AuthPermissionItem appButtonItem = null;
        appModuleItem = new AuthPermissionItem("iClient", "common_clients", "iClient", "system", "false", Integer.valueOf(997));
        this.authInitDataProvider.initPermissionData(appModuleItem);
        appMenuItem = new AuthPermissionItem("iClientVideoPreview", "ivs_iClient_videoPreView", "iClient:videoPreView", "menu", "true", Integer.valueOf(1));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientVideoPlayback", "ivs_iClient_videoPlayback", "iClient:videoPlayback", "menu", "true", Integer.valueOf(2));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientVideoSearch", "ivs_iClient_search", "iClient:search", "menu", "true", Integer.valueOf(3));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientStatistics", "ivs_iClient_statistics", "iClient:statistics", "menu", "true", Integer.valueOf(4));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientIntelligent", "ivs_iClient_intelligent", "iClient:intelligent", "menu", "true", Integer.valueOf(5));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientTVWall", "ivs_iClient_TVWall", "iClient:TVWall", "menu", "true", Integer.valueOf(6));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientMediaInfo", "ivs_iClient_mediaInfo", "iClient:mediaInfo", "menu", "true", Integer.valueOf(7));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientVideoAlarm", "ivs_iClient_videoAlarm", "iClient:videoAlarm", "app_menu", "true", Integer.valueOf(8));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientVideoDevice", "ivs_iClient_videoDevice", "iClient:videoDevice", "menu", "true", Integer.valueOf(9));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        AuthPermissionItem appMenuItem1 = this.authPermissionService.getItemByCode("iClientVideoDevice");
        appMenuItem = new AuthPermissionItem("iClientDeviceList", "ivs_iClient_vid_ext_device_list", "iClient:videoDevice:deviceList", "menu", "true", Integer.valueOf(1));
        appMenuItem.setParentId(appMenuItem1.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListRefresh", "common_op_refresh", "iClient:videoDevice:deviceList:refresh", "button", "true", Integer.valueOf(1));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListAddMaster", "ivs_iClient_add_master", "iClient:videoDevice:deviceList:addMaster", "button", "true", Integer.valueOf(2));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListEdit", "common_op_edit", "iClient:videoDevice:deviceList:edit", "button", "true", Integer.valueOf(3));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListDel", "common_op_del", "iClient:videoDevice:deviceList:del", "button", "true", Integer.valueOf(4));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListManageApp", "ivs_iClient_maintenanceApp", "iClient:videoDevice:deviceList:maintenanceApp", "button", "true", Integer.valueOf(5));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListFaceControl", "ivs_iClient_face_control", "iClient:videoDevice:deviceList:faceControl", "button", "true", Integer.valueOf(6));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListFaceListDatabase", "ivs_iClient_face_list_database", "iClient:videoDevice:deviceList:faceListDatabase", "button", "true", Integer.valueOf(7));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListVehicleControl", "ivs_iClient_vehicle_control", "iClient:videoDevice:deviceList:vehicleControl", "button", "true", Integer.valueOf(8));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListVehicleListDatabase", "ivs_iClient_vehicle_list_database", "iClient:videoDevice:deviceList:vehicleListDatabase", "button", "true", Integer.valueOf(9));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListVehicletTaskManage", "ivs_iClient_task_manage", "iClient:videoDevice:deviceList:taskManage", "button", "true", Integer.valueOf(10));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListCameraAccess", "ivs_iClient_camera_access", "iClient:videoDevice:deviceList:cameraAccess", "button", "true", Integer.valueOf(11));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListStorageManage", "ivs_iClient_storage_manage", "iClient:videoDevice:deviceList:storageManage", "button", "true", Integer.valueOf(12));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListAlarmManage", "ivs_iClient_alarm_manage", "iClient:videoDevice:deviceList:alarmManage", "button", "true", Integer.valueOf(13));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListRepeatCustomerAlert", "ivs_iClient_repeat_customer_alert", "iClient:videoDevice:deviceList:repeatCustomerAlert", "button", "true", Integer.valueOf(14));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListFaceAnalysis", "ivs_iClient_face_analysis", "iClient:videoDevice:deviceList:faceAnalysis", "button", "true", Integer.valueOf(15));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListAdjustmentArea", "ivs_iClient_adjustment_area", "iClient:videoDevice:deviceList:adjustmentArea", "button", "true", Integer.valueOf(16));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListAddCamera", "ivs_iClient_add_camera", "iClient:videoDevice:deviceList:addCamera", "button", "true", Integer.valueOf(17));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListDelete", "ivs_iClient_camera_delete", "iClient:videoDevice:deviceList:delete", "button", "true", Integer.valueOf(18));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListRestart", "ivs_iClient_restart", "iClient:videoDevice:deviceList:restart", "button", "true", Integer.valueOf(19));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListSynchronization", "ivs_iClient_synchronization", "iClient:videoDevice:deviceList:synchronization", "button", "true", Integer.valueOf(20));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListConfigure", "ivs_iClient_configure", "iClient:videoDevice:deviceList:configure", "button", "true", Integer.valueOf(21));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListCameraManage", "ivs_iClient_camera_management", "iClient:videoDevice:deviceList:cameraManagement", "button", "true", Integer.valueOf(22));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientDeviceListThirdPartyAlgorithm", "ivs_iClient_thirdParty_algorithm", "iClient:videoDevice:deviceList:thirdPartyAlgorithm", "button", "true", Integer.valueOf(23));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        AuthPermissionItem appMenuItem2 = this.authPermissionService.getItemByCode("iClientVideoDevice");
        appMenuItem = new AuthPermissionItem("iClientPacketDevice", "ivs_iClient_vid_ext_packet_device", "iClient:videoDevice:packetDevice", "menu", "true", Integer.valueOf(2));
        appMenuItem.setParentId(appMenuItem2.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appButtonItem = new AuthPermissionItem("iClientPacketDeviceAddGroup", "ivs_iClient_add_Group", "iClient:videoDevice:packetDevice:addGroup", "button", "true", Integer.valueOf(1));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientPacketDeviceEdit", "common_op_edit", "iClient:videoDevice:packetDevice:edit", "button", "true", Integer.valueOf(2));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientPacketDeviceDelGroup", "ivs_iClient_del_Group", "iClient:videoDevice:packetDevice:delGroup", "button", "true", Integer.valueOf(3));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientPacketDeviceAddCamera", "ivs_iClient_add_camera", "iClient:videoDevice:packetDevice:addCamera", "button", "true", Integer.valueOf(4));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("iClientPacketDeviceDelete", "ivs_iClient_camera_delete", "iClient:videoDevice:packetDevice:delete", "button", "true", Integer.valueOf(5));
        appButtonItem.setParentId(appMenuItem.getId());
        appButtonItem = this.authPermissionService.initData(appButtonItem);
        appMenuItem = new AuthPermissionItem("iClientPersonalConfig", "ivs_iClient_personalConfig", "iClient:personalConfig", "menu", "true", Integer.valueOf(9));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientLocalConfig", "ivs_iClient_localConfig", "iClient:localConfig", "menu", "true", Integer.valueOf(10));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appMenuItem = new AuthPermissionItem("iClientBaseManage", "ivs_iClient_baseManage", "iClient:baseManage", "menu", "true", Integer.valueOf(11));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
    }

    private void initIvsDictionary() {
        BaseDictionaryItem baseDictionaryItem = new BaseDictionaryItem("ivsParentdeviceFormType", "ivs_parentdevice_form_type", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "IVS1800", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "NVR800", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "ivs_cloud_services", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("MicroCardMode", "ivs_MicroCardMode", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("FaceCardMode", "ivs_FaceCardMode", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("BehaviorAnalyseMode", "ivs_BehaviorAnalyseMode", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsCarYear", "ivs_car_year", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "ivs_car_unknown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2021", "2021", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2020", "2020", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2019", "2019", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2018", "2018", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2017", "2017", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2016", "2016", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2015", "2015", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2014", "2014", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2013", "2013", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2012", "2012", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2011", "2011", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsCarType", "ivs_car_carType", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "ivs_car_unknown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "ivs_car_car", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "ivs_car_truck", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "ivs_car_van", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", "ivs_car_bus", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", "ivs_car_smallTruck", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", "SUV", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("7", "ivs_car_mediumBus", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("8", "ivs_car_motorcycle", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("9", "ivs_car_other", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsCarColor", "ivs_car_carColor", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("9", "ivs_color_unknown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "ivs_color_white", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "ivs_color_gray", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "ivs_car_yellow", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "ivs_color_pink", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", "ivs_color_red", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", "ivs_color_green", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", "ivs_color_blue", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("7", "ivs_color_brown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("8", "ivs_color_black", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("10", "ivs_color_purple", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsSpecialVehicleType", "ivs_car_specialCar", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "ivs_car_notSpecialCar", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "ivs_car_schoolBus", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsPlateColor", "ivs_car_pColor", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("9", "ivs_color_unknown", Integer.valueOf(1), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "ivs_color_white", Integer.valueOf(2), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "ivs_car_yellow", Integer.valueOf(3), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", "ivs_color_green", Integer.valueOf(4), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", "ivs_color_blue", Integer.valueOf(5), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("8", "ivs_color_black", Integer.valueOf(6), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("10", "ivs_color_GradientGreen", Integer.valueOf(7), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("11", "ivs_color_yellowAndGreen", Integer.valueOf(8), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("12", "ivs_color_red", Integer.valueOf(9), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("13", "ivs_color_gray", Integer.valueOf(10), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(11), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsPtype", "ivs_car_pType", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "common_unknown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "ivs_vehicle_singleBlue", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "ivs_vehicle_singleBlack", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "ivs_vehicle_singleYellow", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", "ivs_vehicle_doubleYellow", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", "ivs_vehicle_whitePolice", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", "ivs_vehicle_whiteArmed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("7", "ivs_vehicle_personalPlate", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("8", "ivs_vehicle_singleLayer", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("9", "ivs_vehicle_doubleDecker", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsDirec", "ivs_car_direction", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "ivs_car_unknown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "ivs_car_left", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "ivs_car_right", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "ivs_car_on", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", "ivs_car_under", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsUpperColor", "ivs_car_upperColor", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "ivs_car_unknown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "ivs_car_black", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "ivs_car_green", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "ivs_car_blue", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", "ivs_car_whiteGrey", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", "ivs_car_yellOrangeBrown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", "ivs_car_redPinkPur", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsVehicleBrand", "ivs_vehicle_vehicleBrand", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "ivs_car_unlimited", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("228", "common_unknown", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "GMC", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "Jeep", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "MG", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", "MINI", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", "smart", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", "ivs_vehicle_FAW", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("65", "ivs_vehicle_Changan", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("86", "ivs_vehicle_Ferrari", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("ivsStreamType", "ivs_stream_type", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "ivs_not_specify", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "ivs_main_stream", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "ivs_auxiliary_stream_1", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "ivs_auxiliary_stream_2", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("provinceCity", "ivs_priority_province_city", Boolean.valueOf(false), "ivs_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u65e0", "\u65e0", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u4eac", "\u4eac", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6d25", "\u6d25", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u5180", "\u5180", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u664b", "\u664b", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u8499", "\u8499", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u8fbd", "\u8fbd", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u5409", "\u5409", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u9ed1", "\u9ed1", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6caa", "\u6caa", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u82cf", "\u82cf", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6d59", "\u6d59", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u7696", "\u7696", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u95fd", "\u95fd", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u8d63", "\u8d63", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u9c81", "\u9c81", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u8c6b", "\u8c6b", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u9102", "\u9102", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6e58", "\u6e58", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u7ca4", "\u7ca4", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6842", "\u6842", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u743c", "\u743c", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6e1d", "\u6e1d", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u5ddd", "\u5ddd", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u9ed4", "\u9ed4", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6ec7", "\u6ec7", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u85cf", "\u85cf", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u9655", "\u9655", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u7518", "\u7518", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u9752", "\u9752", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u5b81", "\u5b81", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u65b0", "\u65b0", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u53f0", "\u53f0", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6e2f", "\u6e2f", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("\u6fb3", "\u6fb3", Integer.valueOf(0), baseDictionaryItem.getId()));
    }

    public void initIvsVidParams() {
        BaseSysParamItem item = new BaseSysParamItem("ivs.serverUrl", "http://127.0.0.1:58098", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.wsUrl", "ws://127.0.0.1:58098/websocket", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.config", "1", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.retryTimes", "2", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.debugLog", "false", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.accessLog", "false", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.cloud.url", "https://api-ivm-sh.myhuaweicloud.com", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.ds.url", "127.0.0.1", "\u6d41\u5a92\u4f53\u670d\u52a1\u5bf9\u63a5");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.ds.vhost", "127.0.0.1", "\u6d41\u5a92\u4f53\u670d\u52a1\u57df\u540d");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.ds.secret", "035c73f7-bb6b-4889-a715-d9eb2d1925cc", "\u6d41\u5a92\u4f53\u670d\u52a1\u79d8\u94a5");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.ds.isEnable", "0", "\u662f\u5426\u542f\u7528\u6d41\u5a92\u4f53\u670d\u52a1");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ivs.enableLog", "false", "\u662f\u5426\u6253\u5f00\u65e5\u5fd7");
        this.baseSysParamService.initData(item);
        File file = new File(this.systemFilePath + "/" + "upload/ivs/dsServer/snapshot/");
        item = new BaseSysParamItem("ivs.snapshot.path", file.getAbsolutePath(), "\u6293\u62cd\u56fe\u7247\u5b58\u50a8\u5730\u5740");
        this.baseSysParamService.initData(item);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(this.systemFilePath + "/" + "upload/ivs/dsServer/video/");
        item = new BaseSysParamItem("ivs.video.path", file.getAbsolutePath(), "\u5f55\u50cf\u5b58\u50a8\u5730\u5740");
        this.baseSysParamService.initData(item);
        if (!file.exists()) {
            file.mkdirs();
        }
        List ipList = this.ivsParamsService.getServerIpList();
        String ip = "127.0.0.1";
        if (!CollectionUtil.isEmpty((Collection)ipList)) {
            ip = (String)ipList.get(0);
        }
        item = new BaseSysParamItem("ivs.callbackIp", ip);
        this.baseSysParamService.initData(item);
        IvsGroupItem ivsGroupItem = new IvsGroupItem(I18nUtil.i18nCode((String)"ivs_default_group", (Object[])new Object[0]), true);
        this.ivsGroupService.initData(ivsGroupItem);
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"7");
        values.put("runtime", (Object)"01:00:00");
        values.put("keptType", (Object)BaseDataConstants.DATA_CLEAN_KEPTDAY);
        values.put("imme", (Object)"1");
        values.put("cleanAction", (Object)"ivsDiskDataCleanRemote.do?immediateClean");
        values.put("cleanTip", (Object)"base_diskData_isCleanAllPhoto");
        item = new BaseSysParamItem("ivsDiskDataClean", values.toString(), "base_diskData_ivsPhotos");
        this.baseSysParamService.initData(item);
        this.baseSysParamService.initData(new BaseSysParamItem("ivs.information.snapshot", "true", "\u6293\u62cd\u7167\u7247\u52a0\u5bc6\u663e\u793a"));
        item = new BaseSysParamItem("ivspatrol.version", "true", "ivspatrol License", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
    }

    private void initUpgradeVersion() {
        BaseSysParamItem baseSysParamItem;
        String curVersion = VersionUtil.getReleaseGitTags((String)"ivs");
        if (StringUtils.isNotBlank((CharSequence)curVersion) && StringUtils.isBlank((CharSequence)(baseSysParamItem = this.baseSysParamService.findByParamName("IvsUpgradeVersion")).getId())) {
            baseSysParamItem = new BaseSysParamItem("IvsUpgradeVersion", curVersion, "Ivs Upgrade Version", Boolean.valueOf(true));
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }

    private void initUpgradeMenu() {
        AuthPermissionItem systemItem = this.authPermissionService.getItemByCode("Vid");
        if (Objects.nonNull(systemItem)) {
            systemItem.setAvailable("false");
            this.authPermissionService.saveItem(systemItem);
            return;
        }
        systemItem = this.authPermissionService.getItemByCode("Vms");
        if (Objects.nonNull(systemItem)) {
            systemItem.setAvailable("false");
            this.authPermissionService.saveItem(systemItem);
        }
    }
}

