/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.config.DataSourceConfig;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.utils.ZkBeanUtil;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class SQLUtil {
    private static Pattern prePattern = Pattern.compile(":[\\w]+");
    public static final String DATE_TOCHAR_DAY = "DAY";
    public static final String DATE_TOCHAR_MONTH = "MONTH";
    public static final String DATE_TOCHAR_YEAR = "YEAR";
    public static final String DATE_TOCHAR_HOUR = "HOUR";

    public static String getSqlByItem(BaseItem baseItem) {
        StringBuffer sql = new StringBuffer("SELECT ");
        Class<?> itemCls = baseItem.getClass();
        Field[] fields = itemCls.getDeclaredFields();
        String tag = "";
        String fieldValue = "";
        boolean equals = baseItem.getEquals();
        StringBuffer condition = new StringBuffer(" ");
        StringBuffer havingCondition = new StringBuffer(" ");
        String orderByCloumn = "";
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Column column = field.getAnnotation(Column.class);
            Condition cond = field.getAnnotation(Condition.class);
            if (column != null || cond != null) {
                if (column != null) {
                    if (StringUtils.isNotBlank((CharSequence)baseItem.getSortName()) && baseItem.getSortName().equals(field.getName())) {
                        orderByCloumn = column.name();
                    }
                    sql.append(column.name()).append(" AS ").append(field.getName()).append(",");
                    fieldValue = ZkBeanUtil.getProperty(baseItem, field.getName());
                    if (column.encryptConverter() && StringUtils.isNotBlank((CharSequence)fieldValue)) {
                        fieldValue = SQLUtil.getFieldValue(column.equalTag(), fieldValue);
                    }
                    if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
                        condition.append(SQLUtil.getTagLinkValue(equals, column.linkTag(), column.equalTag(), column.name(), field, fieldValue, column.toDate(), column.encryptConverter()));
                    }
                }
                if (cond != null) {
                    if (cond.coditionType().equals("where")) {
                        SQLUtil.createCodition(cond, field, baseItem, condition);
                    } else if (cond.coditionType().equals("having")) {
                        SQLUtil.createCodition(cond, field, baseItem, havingCondition);
                    }
                }
            }
            ++n2;
        }
        sql = new StringBuffer(sql.toString().substring(0, sql.length() - 1));
        From from = itemCls.getAnnotation(From.class);
        if (StringUtils.isNotBlank((CharSequence)from.after())) {
            sql.append(" FROM " + SQLUtil.convertPreSQL(from.after(), baseItem));
        }
        Where where = itemCls.getAnnotation(Where.class);
        sql.append(" WHERE 1=1 ");
        if (where != null) {
            sql.append(where.after());
        }
        sql.append(condition.toString());
        GroupBy groupBy = itemCls.getAnnotation(GroupBy.class);
        if (groupBy != null) {
            sql.append(" GROUP BY " + groupBy.after());
        }
        if (StringUtils.isNotBlank((CharSequence)havingCondition)) {
            sql.append(" HAVING 1=1 " + havingCondition);
        }
        OrderBy orderBy = itemCls.getAnnotation(OrderBy.class);
        boolean pageNeedOrder = false;
        if (StringUtils.isNotBlank((CharSequence)orderByCloumn) && StringUtils.isNotBlank((CharSequence)baseItem.getSortOrder())) {
            pageNeedOrder = true;
            sql.append(" ORDER BY " + orderByCloumn + " " + baseItem.getSortOrder());
        }
        if (orderBy != null && !pageNeedOrder) {
            sql.append(" ORDER BY " + SQLUtil.convertPreSQL(orderBy.after(), baseItem));
        }
        return SQLUtil.resolveUncommonWords(sql.toString());
    }

    private static String resolveUncommonWords(String sql) {
        String dbType = DataSourceConfig.getDbType();
        if ("sqlserver".equals(dbType)) {
            String newSql = "";
            int i = sql.toLowerCase().indexOf(" like ");
            while (i != -1) {
                int k = sql.indexOf("'%", i);
                if (k == -1) break;
                newSql = String.valueOf(newSql) + sql.substring(0, k) + "N";
                sql = sql.substring(k);
                i = sql.toLowerCase().indexOf(" like ");
            }
            return String.valueOf(newSql) + sql;
        }
        return sql;
    }

    private static String getFieldValue(String equalTag, String fieldValue) {
        if (StrUtil.toUpperCase((String)equalTag).equals("IN") || StrUtil.toUpperCase((String)equalTag).equals("NOT IN")) {
            return fieldValue;
        }
        return FoldexUtil.encryptByRandomSey((String)fieldValue);
    }

    private static void createCodition(Condition cond, Field field, BaseItem baseItem, StringBuffer condition) {
        String fieldValue = ZkBeanUtil.getProperty(baseItem, field.getName());
        if (cond.encryptConverter() && StringUtils.isNotBlank((CharSequence)fieldValue)) {
            fieldValue = SQLUtil.getFieldValue(cond.equalTag(), fieldValue);
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            if (StringUtils.isBlank((CharSequence)cond.equalTag()) && StringUtils.isNotBlank((CharSequence)cond.value())) {
                if (StringUtils.isNotBlank((CharSequence)cond.formatType())) {
                    fieldValue = SQLUtil.formatConditionData(fieldValue, cond.formatType());
                }
                String condVal = cond.value();
                String _fieldValue = SQLUtil.conditionValueProcess(field, fieldValue, cond.toDate());
                if (StringUtils.isNotBlank((CharSequence)_fieldValue)) {
                    condVal.toLowerCase().contains("lower(");
                }
                if (condVal.contains("%s")) {
                    condition.append(" " + cond.linkTag() + " " + String.format(condVal, _fieldValue));
                } else {
                    condition.append(" " + cond.linkTag() + " " + MessageFormat.format(condVal, _fieldValue));
                }
            } else {
                condition.append(SQLUtil.getTagLinkValue(false, cond.linkTag(), cond.equalTag(), cond.value(), field, fieldValue, cond.toDate(), cond.encryptConverter()));
            }
        } else if ("notNull".equals(cond.equalTag())) {
            condition.append(SQLUtil.notNullProcess(cond.linkTag(), cond.value(), field));
        }
    }

    private static String conditionValueProcess(Field field, String fieldValue, boolean toDate) {
        if (SQLUtil.isBaseNumber(field.getType())) {
            return fieldValue;
        }
        if (field.getType() == Character.TYPE || field.getType() == Character.class) {
            return fieldValue;
        }
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            return SQLUtil.booleanProcess(fieldValue);
        }
        if (field.getType() == String.class) {
            if (toDate) {
                return SQLUtil.dateValue(fieldValue);
            }
            return fieldValue;
        }
        if (field.getType() == Date.class) {
            return SQLUtil.dateValue(fieldValue);
        }
        return "";
    }

    public static String dateValue(String fieldValue) {
        String dbType = DataSourceConfig.getDbType();
        if ("postgresql".equals(dbType)) {
            return "'" + fieldValue + "'";
        }
        if ("oracle".equals(dbType)) {
            return "to_date('" + fieldValue + "','yyyy-mm-dd hh24:mi:ss')";
        }
        if ("sqlserver".equals(dbType)) {
            return "'" + fieldValue + "'";
        }
        if ("mysql".equals(dbType)) {
            return "'" + fieldValue + "'";
        }
        return "'" + fieldValue + "'";
    }

    private static String formatConditionData(String fieldValue, String formatType) {
        String rs = fieldValue;
        if ("quote".equals(formatType)) {
            rs = StrUtil.withSingleQuote((String)fieldValue);
        }
        return rs;
    }

    private static String getTagLinkValue(boolean equals, String linkTag, String equalTag, String name, Field field, String fieldValue, boolean toDate, boolean encryptConverter) {
        String tag = equalTag;
        if (equals) {
            tag = "=";
        }
        if ("notNull".equals(equalTag)) {
            return SQLUtil.notNullProcess(linkTag, name, field);
        }
        if (SQLUtil.isBaseNumber(field.getType())) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                tag = "=";
            }
            return " " + linkTag + " " + name + " " + tag + " " + fieldValue;
        }
        if (field.getType() == Character.TYPE || field.getType() == Character.class) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                tag = "=";
            }
            return " " + linkTag + " " + name + " " + tag + " '" + fieldValue + "'";
        }
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            return " " + linkTag + " " + name + " = " + SQLUtil.booleanProcess(fieldValue);
        }
        if (field.getType() == String.class) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                tag = name.endsWith(".ID") ? "=" : "LIKE";
            }
            if (StrUtil.toUpperCase((String)tag).equals("LIKE")) {
                return " " + linkTag + " lower(" + name + ") " + tag + " lower('%" + fieldValue + "%')";
            }
            if (StrUtil.toUpperCase((String)tag).equals("LIKEPRE")) {
                return " " + linkTag + " " + name + " " + tag + " '%" + fieldValue + "'";
            }
            if (StrUtil.toUpperCase((String)tag).equals("LIKEPOS")) {
                return " " + linkTag + " " + name + " " + tag + " '" + fieldValue + "%'";
            }
            if (StrUtil.toUpperCase((String)tag).equals("IN") || StrUtil.toUpperCase((String)tag).equals("NOT IN")) {
                return SQLUtil.containInTagProcess(linkTag, name, tag, fieldValue, encryptConverter);
            }
            if (toDate) {
                return SQLUtil.dateProcess(linkTag, name, fieldValue, tag);
            }
            return " " + linkTag + " " + name + " " + tag + " '" + fieldValue + "'";
        }
        if (field.getType() == Date.class) {
            return SQLUtil.dateProcess(linkTag, name, fieldValue, tag);
        }
        return "";
    }

    private static String containInTagProcess(String linkTag, String name, String tag, String fieldValue, boolean encryptConverter) {
        String[] array = fieldValue.split(",");
        int length = array.length;
        if (array.length < 1000) {
            return " " + linkTag + " " + name + " " + tag + " (" + SQLUtil.withSingleQuote(fieldValue, encryptConverter) + ")";
        }
        ArrayList<String> fieldValueList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append(String.valueOf(array[i]) + ",");
            if ((i + 1) % 999 == 0) {
                fieldValueList.add(sb.toString());
                sb = new StringBuffer();
            }
            ++i;
        }
        if (sb.length() > 0) {
            fieldValueList.add(sb.toString());
        }
        if ("IN".equals(StrUtil.toUpperCase((String)tag))) {
            sb = new StringBuffer(" " + linkTag + " (1=0 ");
            for (String fl : fieldValueList) {
                sb.append("or (" + name + " " + tag + " (" + SQLUtil.withSingleQuote(fl, encryptConverter) + "))");
            }
            sb.append(")");
        } else if ("NOT IN".equals(StrUtil.toUpperCase((String)tag))) {
            sb = new StringBuffer("");
            for (String fl : fieldValueList) {
                sb.append(" " + linkTag + " (" + name + " " + tag + " (" + SQLUtil.withSingleQuote(fl, encryptConverter) + "))");
            }
        }
        return sb.toString();
    }

    public static String withSingleQuote(String str, boolean encryptConverter) {
        String[] array;
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array = str.split(",");
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (encryptConverter) {
                s = FoldexUtil.encryptByRandomSey((String)s);
            }
            sb.append("'" + s + "',");
            ++n2;
        }
        return StrUtil.removeLastChar((String)sb.toString());
    }

    private static String booleanProcess(String fieldValue) {
        String dbType = DataSourceConfig.getDbType();
        if ("postgresql".equals(dbType)) {
            return "true".equals(fieldValue) ? "'t'" : "'f'";
        }
        if ("oracle".equals(dbType)) {
            return "true".equals(fieldValue) ? "1" : "0";
        }
        if ("mysql".equals(dbType)) {
            return "true".equals(fieldValue) ? "1" : "0";
        }
        if ("sqlserver".equals(dbType)) {
            return "true".equals(fieldValue) ? "1" : "0";
        }
        return "true".equals(fieldValue) ? "1" : "0";
    }

    private static String notNullProcess(String linkTag, String name, Field field) {
        String dbType = DataSourceConfig.getDbType();
        if (field.getType() == String.class) {
            if ("oracle".equals(dbType)) {
                return " " + linkTag + " " + name + " is not null";
            }
            return " " + linkTag + " (" + name + " <> '' and " + name + " is not null)";
        }
        return " " + linkTag + " " + name + " is not null";
    }

    private static String dateProcess(String linkTag, String name, String fieldValue, String tag) {
        return " " + linkTag + " " + name + " " + tag + " " + SQLUtil.dateValue(fieldValue);
    }

    public String getPageSql(String tableName, String start, String size) {
        String sql = "SELECT * FROM " + tableName + "  limit " + size + " OFFSET " + start;
        String dbType = DataSourceConfig.getDbType();
        if ("oracle".equals(dbType)) {
            sql = "SELECT * FROM (select t.*,rownum as rowno from " + tableName + " ) where rowno between " + start + " and " + start + size;
        } else if ("sqlserver".equals(dbType)) {
            sql = "SELECT top " + size + " * FROM " + tableName + " WHERE id>" + start;
        } else if ("mysql".equals(dbType)) {
            sql = "SELECT * FROM " + tableName + "  LIMIT " + start + "," + size;
        }
        return sql;
    }

    public static String dateToChar(String field, String dateType) {
        Assert.notNull((Object)dateType, (String)"dateType must not be null!");
        String dbType = DataSourceConfig.getDbType();
        if ("postgresql".equals(dbType) || "oracle".equals(dbType)) {
            String dateFormat = "";
            if (DATE_TOCHAR_DAY.equals(dateType)) {
                dateFormat = "yyyy-mm-dd";
            } else if (DATE_TOCHAR_MONTH.equals(dateType)) {
                dateFormat = "yyyy-mm";
            } else if (DATE_TOCHAR_YEAR.equals(dateType)) {
                dateFormat = "yyyy";
            } else if (DATE_TOCHAR_HOUR.equals(dateType)) {
                dateFormat = "yyyy-mm-dd hh24";
            }
            return "TO_CHAR(" + field + ",'" + dateFormat + "')";
        }
        if ("sqlserver".equals(dbType)) {
            String dateFormat = "";
            if (DATE_TOCHAR_DAY.equals(dateType)) {
                dateFormat = "10";
            } else if (DATE_TOCHAR_MONTH.equals(dateType)) {
                dateFormat = "7";
            } else if (DATE_TOCHAR_YEAR.equals(dateType)) {
                dateFormat = "4";
            } else if (DATE_TOCHAR_HOUR.equals(dateType)) {
                dateFormat = "13";
            }
            return "CONVERT(VARCHAR(" + dateFormat + ")," + field + ",120)";
        }
        if ("mysql".equals(dbType)) {
            String dateFormat = "";
            if (DATE_TOCHAR_DAY.equals(dateType)) {
                dateFormat = "%Y-%m-%d";
            } else if (DATE_TOCHAR_MONTH.equals(dateType)) {
                dateFormat = "%Y-%m";
            } else if (DATE_TOCHAR_YEAR.equals(dateType)) {
                dateFormat = "%Y";
            } else if (DATE_TOCHAR_HOUR.equals(dateType)) {
                dateFormat = "%Y-%m-%d %h";
            }
            return "DATE_FORMAT(" + field + ",'" + dateFormat + "')";
        }
        return field;
    }

    public static String convertPreSQL(String sql, BaseItem item) {
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            Matcher matcher = prePattern.matcher(sql);
            while (matcher.find()) {
                String fieldName = matcher.group().substring(1);
                try {
                    String fieldValue = ZkBeanUtil.getProperty(item, fieldName);
                    Field field = item.getClass().getDeclaredField(fieldName);
                    if (Objects.nonNull(field) && StringUtils.isNotBlank((CharSequence)fieldValue)) {
                        if (!SQLUtil.isBaseNumber(field.getType())) {
                            fieldValue = field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? SQLUtil.booleanProcess(fieldValue) : (field.getType() == Date.class ? SQLUtil.dateValue(fieldValue) : "'" + fieldValue.replaceAll("'", "''") + "'");
                        }
                        sql = sql.replace(":" + fieldName, fieldValue);
                        continue;
                    }
                    sql = sql.replace(":" + fieldName, "''");
                }
                catch (Exception e) {
                    sql = sql.replace(":" + fieldName, "''");
                }
            }
        }
        return sql;
    }

    public static boolean isBaseNumber(Class<?> cls) {
        return cls == Long.TYPE || cls == Long.class || cls == Integer.TYPE || cls == Integer.class || cls == Short.TYPE || cls == Short.class || cls == Double.TYPE || cls == Double.class || cls == Float.TYPE || cls == Float.class || cls == Byte.TYPE || cls == Byte.class;
    }
}

