/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.config.DataSourceConfig;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.SQLBean;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.utils.ZkBeanUtil;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SQLPrePareUtil {
    private static final Logger log = LoggerFactory.getLogger(SQLPrePareUtil.class);
    static String QUESTION_MARK = "?";
    static String QUESTION_MARK_ORDER_BY = "#";
    private static Pattern prePattern = Pattern.compile(":[\\w]+");
    public static final String DATE_TOCHAR_DAY = "DAY";
    public static final String DATE_TOCHAR_MONTH = "MONTH";
    public static final String DATE_TOCHAR_YEAR = "YEAR";
    public static final String DATE_TOCHAR_HOUR = "HOUR";

    public static SQLBean getSqlByItem(BaseItem baseItem) {
        SQLBean bean = new SQLBean();
        HashMap<Integer, Object> valueMap = new HashMap<Integer, Object>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer("SELECT ");
        Class<?> itemCls = baseItem.getClass();
        Field[] fields = itemCls.getDeclaredFields();
        Object fieldValue = "";
        boolean equals = baseItem.getEquals();
        StringBuffer condition = new StringBuffer(" ");
        StringBuffer havingCondition = new StringBuffer(" ");
        String orderByCloumn = "";
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Column column = field.getAnnotation(Column.class);
            Condition cond = field.getAnnotation(Condition.class);
            if (column != null || cond != null) {
                if (column != null) {
                    if (StringUtils.isNotBlank((CharSequence)baseItem.getSortName()) && baseItem.getSortName().equals(field.getName())) {
                        orderByCloumn = column.name();
                    }
                    sql.append(column.name()).append(" AS ").append(field.getName()).append(",");
                    fieldValue = SQLPrePareUtil.getObject(baseItem, fieldValue, field, column.encryptConverter());
                    if (fieldValue != null) {
                        condition.append(SQLPrePareUtil.getTagLinkValue(equals, column.linkTag(), column.equalTag(), column.name(), field, fieldValue, valueMap, valueList, column.toDate()));
                    }
                }
                if (cond != null) {
                    if (cond.coditionType().equals("where")) {
                        SQLPrePareUtil.createCodition(valueMap, valueList, cond, field, baseItem, condition);
                    } else if (cond.coditionType().equals("having")) {
                        SQLPrePareUtil.createCodition(valueMap, valueList, cond, field, baseItem, havingCondition);
                    }
                }
            }
            ++n2;
        }
        sql = new StringBuffer(sql.toString().substring(0, sql.length() - 1));
        From from = itemCls.getAnnotation(From.class);
        if (StringUtils.isNotBlank((CharSequence)from.after())) {
            sql.append(" FROM ").append(SQLPrePareUtil.convertPreSQL(from.after(), baseItem, valueMap, valueList));
        }
        Where where = itemCls.getAnnotation(Where.class);
        sql.append(" WHERE 1=1 ");
        if (where != null) {
            sql.append(where.after());
        }
        sql.append(condition.toString());
        GroupBy groupBy = itemCls.getAnnotation(GroupBy.class);
        if (groupBy != null) {
            sql.append(" GROUP BY ").append(groupBy.after());
        }
        if (StringUtils.isNotBlank((CharSequence)havingCondition)) {
            sql.append(" HAVING 1=1 ").append(havingCondition);
        }
        OrderBy orderBy = itemCls.getAnnotation(OrderBy.class);
        boolean pageNeedOrder = false;
        if (StringUtils.isNotBlank((CharSequence)orderByCloumn) && StringUtils.isNotBlank((CharSequence)baseItem.getSortOrder())) {
            pageNeedOrder = true;
            sql.append(" ORDER BY ").append(orderByCloumn).append(" ").append(baseItem.getSortOrder());
        }
        if (orderBy != null && !pageNeedOrder) {
            sql.append(" ORDER BY ").append(SQLPrePareUtil.convertPreSQLOrderBy(orderBy.after(), baseItem, valueMap, valueList));
        }
        bean.setSql(sql.toString());
        bean.setList(valueList);
        bean.setValueMap(valueMap);
        return bean;
    }

    private static Object getObject(BaseItem baseItem, Object fieldValue, Field field, boolean encrypt) {
        try {
            fieldValue = BeanUtilsBean.getInstance().getPropertyUtils().getNestedProperty((Object)baseItem, field.getName());
            ZkBeanUtil.getProperty(baseItem, field.getName());
            if (encrypt && StringUtils.isNotBlank((CharSequence)String.valueOf(fieldValue))) {
                fieldValue = FoldexUtil.encryptByRandomSey((String)String.valueOf(fieldValue));
            }
        }
        catch (Exception e) {
            log.error("get fieldValue error", (Throwable)e);
        }
        return fieldValue;
    }

    private static void changeValue(Map<Integer, Object> valueMap, List<Object> valueList, Object fieldValue, String tag, boolean toDate, boolean equals, Field field) {
        if (equals) {
            tag = "=";
        }
        if (field.getType() == Integer.class || field.getType() == Short.TYPE || field.getType() == Long.TYPE || field.getType() == Long.class || field.getType() == Integer.TYPE || field.getType() == Short.class || field.getType() == Double.TYPE || field.getType() == Double.class || field.getType() == Float.TYPE || field.getType() == Float.class || field.getType() == Character.TYPE || field.getType() == Character.class) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                tag = "=";
            }
        } else if (field.getType() == String.class && StringUtils.isBlank((CharSequence)tag)) {
            tag = "LIKE";
        }
        if (fieldValue.getClass() == String.class && toDate) {
            String date = fieldValue.toString();
            valueList.add(DateUtil.stringToDate((String)date));
        } else if (SQLPrePareUtil.isLikeTag(tag) && fieldValue.getClass() == String.class) {
            valueList.add("%" + fieldValue + "%");
        } else {
            valueList.add(fieldValue);
        }
    }

    private static boolean isLikeTag(String tag) {
        return StrUtil.toUpperCase((String)tag).equals("LIKE");
    }

    private static void createCodition(Map<Integer, Object> valueMap, List<Object> valueList, Condition cond, Field field, BaseItem baseItem, StringBuffer condition) {
        Object fieldValue = null;
        try {
            fieldValue = BeanUtilsBean.getInstance().getPropertyUtils().getNestedProperty((Object)baseItem, field.getName());
        }
        catch (Exception e) {
            log.error("get fieldValue error", (Throwable)e);
        }
        if (cond.encryptConverter() && StringUtils.isNotBlank((CharSequence)String.valueOf(fieldValue))) {
            fieldValue = FoldexUtil.encryptByRandomSey((String)String.valueOf(fieldValue));
        }
        if (fieldValue != null) {
            if (StringUtils.isBlank((CharSequence)cond.equalTag()) && StringUtils.isNotBlank((CharSequence)cond.value())) {
                String condVal = cond.value();
                String condValStr = cond.value();
                if (condVal.contains("%s")) {
                    condition.append(" ").append(cond.linkTag()).append(" ").append(condVal.replace("%s", QUESTION_MARK));
                    condValStr = condVal.replace("%s", QUESTION_MARK);
                } else if (condVal.contains("''{0}''") || condVal.contains("''%{0}%''")) {
                    condition.append(" ").append(cond.linkTag()).append(" ").append(condVal.replace("''{0}''", QUESTION_MARK).replace("''%{0}%''", QUESTION_MARK));
                    condValStr = condVal.replace("%s", QUESTION_MARK).replace("''%{0}%''", QUESTION_MARK);
                }
                String[] split = condValStr.split("\\?");
                int len = condValStr.endsWith("\\?") ? split.length : split.length - 1;
                int i = 0;
                while (i < len) {
                    SQLPrePareUtil.changeValue(valueMap, valueList, fieldValue, cond.equalTag(), cond.toDate(), baseItem.getEquals(), field);
                    ++i;
                }
            } else {
                condition.append(SQLPrePareUtil.getTagLinkValue(false, cond.linkTag(), cond.equalTag(), cond.value(), field, fieldValue, valueMap, valueList, cond.toDate()));
            }
        } else if ("notNull".equals(cond.equalTag())) {
            condition.append(SQLPrePareUtil.notNullProcess(cond.linkTag(), cond.value()));
        }
    }

    public static String dateValue(String fieldValue) {
        String dbType = DataSourceConfig.getDbType();
        if ("postgresql".equals(dbType)) {
            return fieldValue;
        }
        if ("oracle".equals(dbType)) {
            return "to_date(" + fieldValue + ",'yyyy-mm-dd hh24:mi:ss')";
        }
        if ("sqlserver".equals(dbType)) {
            return fieldValue;
        }
        if ("mysql".equals(dbType)) {
            return fieldValue;
        }
        return fieldValue;
    }

    private static String getTagLinkValue(boolean equals, String linkTag, String equalTag, String name, Field field, Object fieldValue, Map<Integer, Object> valueMap, List<Object> valueList, boolean toDate) {
        String conditionSql;
        block23: {
            String tag;
            block25: {
                block28: {
                    block27: {
                        block26: {
                            block24: {
                                block22: {
                                    tag = equalTag;
                                    conditionSql = "";
                                    if (equals) {
                                        tag = "=";
                                    }
                                    if (!"notNull".equals(equalTag)) break block22;
                                    conditionSql = SQLPrePareUtil.notNullProcess(linkTag, name);
                                    break block23;
                                }
                                if (field.getType() != Long.TYPE && field.getType() != Long.class && field.getType() != Integer.TYPE && field.getType() != Integer.class && field.getType() != Short.TYPE && field.getType() != Short.class && field.getType() != Double.TYPE && field.getType() != Double.class && field.getType() != Float.TYPE && field.getType() != Float.class) break block24;
                                if (StringUtils.isBlank((CharSequence)tag)) {
                                    tag = "=";
                                }
                                conditionSql = " " + linkTag + " " + name + " " + tag + " " + QUESTION_MARK;
                                break block25;
                            }
                            if (field.getType() != Character.TYPE && field.getType() != Character.class) break block26;
                            if (StringUtils.isBlank((CharSequence)tag)) {
                                tag = "=";
                            }
                            conditionSql = " " + linkTag + " " + name + " " + tag + " " + QUESTION_MARK;
                            break block25;
                        }
                        if (field.getType() != Boolean.TYPE && field.getType() != Boolean.class) break block27;
                        conditionSql = " " + linkTag + " " + name + " = " + QUESTION_MARK;
                        break block25;
                    }
                    if (field.getType() != String.class) break block28;
                    if (StringUtils.isBlank((CharSequence)tag)) {
                        tag = name.endsWith(".ID") ? "=" : "LIKE";
                    }
                    switch (StrUtil.toUpperCase((String)tag)) {
                        case "LIKE": {
                            conditionSql = " " + linkTag + " lower(" + name + ") " + tag + " lower(" + QUESTION_MARK + ")";
                            break;
                        }
                        case "LIKEPOS": 
                        case "LIKEPRE": {
                            conditionSql = " " + linkTag + " " + name + " " + tag + " " + QUESTION_MARK;
                            break;
                        }
                        case "NOT IN": 
                        case "IN": {
                            conditionSql = SQLPrePareUtil.containInTagProcess(linkTag, name, tag, String.valueOf(fieldValue));
                            break;
                        }
                        default: {
                            conditionSql = " " + linkTag + " " + name + " " + tag + " " + QUESTION_MARK;
                            break;
                        }
                    }
                    break block25;
                }
                if (field.getType() == Date.class) {
                    conditionSql = " " + linkTag + " " + name + " " + tag + " " + QUESTION_MARK;
                }
            }
            SQLPrePareUtil.changeValue(valueMap, valueList, fieldValue, tag, toDate, equals, field);
        }
        return conditionSql;
    }

    private static String containInTagProcess(String linkTag, String name, String tag, String fieldValue) {
        String[] array = fieldValue.split(",");
        int length = array.length;
        if (array.length < 1000) {
            return " " + linkTag + " " + name + " " + tag + " (" + QUESTION_MARK + ")";
        }
        ArrayList<String> fieldValueList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append(array[i]).append(",");
            if ((i + 1) % 999 == 0) {
                fieldValueList.add(sb.toString());
                sb = new StringBuffer();
            }
            ++i;
        }
        if (sb.length() > 0) {
            fieldValueList.add(sb.toString());
        }
        if ("IN".equals(StrUtil.toUpperCase((String)tag))) {
            sb = new StringBuffer(" " + linkTag + " (1=0 ");
            for (String ignored : fieldValueList) {
                sb.append("or (").append(name).append(" ").append(tag).append(" (").append(QUESTION_MARK).append("))");
            }
            sb.append(")");
        } else if ("NOT IN".equals(StrUtil.toUpperCase((String)tag))) {
            sb = new StringBuffer();
            for (String ignored : fieldValueList) {
                sb.append(" ").append(linkTag).append(" (").append(name).append(" ").append(tag).append(" (").append(QUESTION_MARK).append("))");
            }
        }
        return sb.toString();
    }

    private static String notNullProcess(String linkTag, String name) {
        String dbType = DataSourceConfig.getDbType();
        if ("postgresql".equals(dbType)) {
            return " " + linkTag + " " + name + " !=''";
        }
        if ("oracle".equals(dbType)) {
            return " " + linkTag + " " + name + " is not null";
        }
        if ("sqlserver".equals(dbType)) {
            return " " + linkTag + " " + name + " !=''";
        }
        if ("mysql".equals(dbType)) {
            return " " + linkTag + " " + name + " !=''";
        }
        return " " + linkTag + " " + name + " !=''";
    }

    public String getPageSql(String tableName, String start, String size) {
        String sql = "SELECT * FROM " + tableName + "  limit " + size + " OFFSET " + start;
        String dbType = DataSourceConfig.getDbType();
        if ("oracle".equals(dbType)) {
            sql = "SELECT * FROM (select t.*,rownum as rowno from " + tableName + " ) where rowno between " + start + " and " + start + size;
        } else if ("sqlserver".equals(dbType)) {
            sql = "SELECT top " + size + " * FROM " + tableName + " WHERE id>" + start;
        } else if ("mysql".equals(dbType)) {
            sql = "SELECT * FROM " + tableName + "  LIMIT " + start + "," + size;
        }
        return sql;
    }

    public static String dateToChar(String field, String dateType) {
        block52: {
            String dbType;
            block50: {
                block48: {
                    Assert.notNull((Object)dateType, (String)"dateType must not be null!");
                    dbType = DataSourceConfig.getDbType();
                    if (!"postgresql".equals(dbType) && !"oracle".equals(dbType)) break block48;
                    String dateFormat = "";
                    switch (dateType) {
                        case "DAY": {
                            dateFormat = "yyyy-mm-dd";
                            break;
                        }
                        case "MONTH": {
                            dateFormat = "yyyy-mm";
                            break;
                        }
                        case "YEAR": {
                            dateFormat = "yyyy";
                            break;
                        }
                        case "HOUR": {
                            dateFormat = "yyyy-mm-dd hh24";
                        }
                    }
                    return "TO_CHAR(" + field + ",'" + dateFormat + "')";
                }
                if (!"sqlserver".equals(dbType)) break block50;
                String dateFormat = "";
                switch (dateType) {
                    case "DAY": {
                        dateFormat = "10";
                        break;
                    }
                    case "MONTH": {
                        dateFormat = "7";
                        break;
                    }
                    case "YEAR": {
                        dateFormat = "4";
                        break;
                    }
                    case "HOUR": {
                        dateFormat = "13";
                    }
                }
                return "CONVERT(VARCHAR(" + dateFormat + ")," + field + ",120)";
            }
            if (!"mysql".equals(dbType)) break block52;
            String dateFormat = "";
            switch (dateType) {
                case "DAY": {
                    dateFormat = "%Y-%m-%d";
                    break;
                }
                case "MONTH": {
                    dateFormat = "%Y-%m";
                    break;
                }
                case "YEAR": {
                    dateFormat = "%Y";
                    break;
                }
                case "HOUR": {
                    dateFormat = "%Y-%m-%d %h";
                }
            }
            return "DATE_FORMAT(" + field + ",'" + dateFormat + "')";
        }
        return field;
    }

    public static String convertPreSQL(String sql, BaseItem item, Map<Integer, Object> valueMap, List<Object> valueList) {
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            Matcher matcher = prePattern.matcher(sql);
            while (matcher.find()) {
                String fieldName = matcher.group().substring(1);
                try {
                    String fieldValue = ZkBeanUtil.getProperty(item, fieldName);
                    Field field = item.getClass().getDeclaredField(fieldName);
                    if (Objects.nonNull(field) && StringUtils.isNotBlank((CharSequence)fieldValue)) {
                        if (!SQLPrePareUtil.isBaseNumber(field.getType())) {
                            fieldValue = field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? SQLPrePareUtil.booleanProcess(fieldValue) : (field.getType() == Date.class ? SQLPrePareUtil.dateValue(fieldValue) : "'" + fieldValue.replaceAll("'", "''") + "'");
                        }
                        sql = sql.replace(":" + fieldName, QUESTION_MARK_ORDER_BY);
                        valueList.add(fieldValue);
                        continue;
                    }
                    sql = sql.replace(":" + fieldName, QUESTION_MARK_ORDER_BY);
                    valueList.add("''");
                }
                catch (Exception e) {
                    sql = sql.replace(":" + fieldName, QUESTION_MARK_ORDER_BY);
                    valueList.add("''");
                }
            }
        }
        return sql;
    }

    public static String convertPreSQLOrderBy(String sql, BaseItem item, Map<Integer, Object> valueMap, List<Object> valueList) {
        String preSql = sql;
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            Matcher matcher = prePattern.matcher(sql);
            while (matcher.find()) {
                String fieldName = matcher.group().substring(1);
                try {
                    String fieldValue = ZkBeanUtil.getProperty(item, fieldName);
                    Field field = item.getClass().getDeclaredField(fieldName);
                    if (Objects.nonNull(field) && StringUtils.isNotBlank((CharSequence)fieldValue)) {
                        if (!SQLPrePareUtil.isBaseNumber(field.getType())) {
                            fieldValue = field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? SQLPrePareUtil.booleanProcess(fieldValue) : (field.getType() == Date.class ? SQLPrePareUtil.dateValue(fieldValue) : "'" + fieldValue.replaceAll("'", "''") + "'");
                        }
                        sql = sql.replace(":" + fieldName, QUESTION_MARK_ORDER_BY);
                        valueMap.put(valueList.size(), fieldValue);
                        valueList.add(fieldValue);
                        continue;
                    }
                    sql = sql.replace(":" + fieldName, QUESTION_MARK_ORDER_BY);
                    valueMap.put(valueList.size(), "''");
                    valueList.add("''");
                }
                catch (Exception e) {
                    sql = sql.replace(":" + fieldName, QUESTION_MARK_ORDER_BY);
                    valueMap.put(valueList.size(), "''");
                    valueList.add("''");
                }
            }
        }
        return sql;
    }

    public static boolean isBaseNumber(Class<?> cls) {
        return cls == Long.TYPE || cls == Long.class || cls == Integer.TYPE || cls == Integer.class || cls == Short.TYPE || cls == Short.class || cls == Double.TYPE || cls == Double.class || cls == Float.TYPE || cls == Float.class || cls == Byte.TYPE || cls == Byte.class;
    }

    private static String booleanProcess(String fieldValue) {
        String dbType = DataSourceConfig.getDbType();
        if ("postgresql".equals(dbType)) {
            return "true".equals(fieldValue) ? "'t'" : "'f'";
        }
        if ("oracle".equals(dbType)) {
            return "true".equals(fieldValue) ? "1" : "0";
        }
        if ("mysql".equals(dbType)) {
            return "true".equals(fieldValue) ? "1" : "0";
        }
        if ("sqlserver".equals(dbType)) {
            return "true".equals(fieldValue) ? "1" : "0";
        }
        return "true".equals(fieldValue) ? "1" : "0";
    }
}

