/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.model.BaseModel;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class ModelUtil {
    public static boolean modelIsExsit(BaseModel baseModel) {
        return StringUtils.isNotBlank((CharSequence)baseModel.getId());
    }

    public static <T> T copyProperties(Object source, T target) {
        try {
            BeanUtils.copyProperties((Object)source, target);
            return target;
        }
        catch (Exception e) {
            throw new ZKBusinessException("", "bean copy error");
        }
    }

    public static <T> T copyPropertiesIgnoreId(Object source, T target) {
        try {
            BeanUtils.copyProperties((Object)source, target, (String[])new String[]{"id"});
            return target;
        }
        catch (Exception e) {
            throw new ZKBusinessException("", "bean copy ignoreId error");
        }
    }

    public static <T> T copyPropertiesWithIgnore(Object source, T target, String ... ignoreProperties) {
        try {
            BeanUtils.copyProperties((Object)source, target, (String[])ignoreProperties);
            return target;
        }
        catch (Exception e) {
            throw new ZKBusinessException("", "bean ignoreProperties error");
        }
    }

    public static <T> List<T> copyListProperties(Collection list, Class<T> classs) {
        try {
            ArrayList<T> targetList = new ArrayList<T>();
            for (Object source : list) {
                targetList.add(ModelUtil.copyProperties(source, classs.newInstance()));
            }
            return targetList;
        }
        catch (Exception e) {
            throw new ZKBusinessException("", "bean error");
        }
    }

    public static <T> List<T> copyListPropertiesWithIgnore(Collection list, Class<T> classs, String ... ignoreProperties) {
        try {
            ArrayList<T> targetList = new ArrayList<T>();
            for (Object source : list) {
                targetList.add(ModelUtil.copyPropertiesWithIgnore(source, classs.newInstance(), ignoreProperties));
            }
            return targetList;
        }
        catch (Exception e) {
            throw new ZKBusinessException("", "bean ignoreProperties error");
        }
    }

    public static String[] getNullPropertyNames(Object source, String ... ignoreProperties) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<Object> emptyNames = new HashSet<Object>();
        Object[] objectArray = pds;
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = objectArray[n2];
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue == null) {
                emptyNames.add(pd.getName());
            }
            ++n2;
        }
        if (ignoreProperties != null) {
            objectArray = ignoreProperties;
            n = ignoreProperties.length;
            n2 = 0;
            while (n2 < n) {
                Object ig = objectArray[n2];
                emptyNames.add(ig);
                ++n2;
            }
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static <T> T copyPropertiesIgnoreNull(Object source, T target) {
        return ModelUtil.copyPropertiesWithIgnore(source, target, ModelUtil.getNullPropertyNames(source, new String[0]));
    }

    public static <T> T copyPropertiesIgnoreNullWithProperties(Object source, T target, String ... ignoreProperties) {
        return ModelUtil.copyPropertiesWithIgnore(source, target, ModelUtil.getNullPropertyNames(source, ignoreProperties));
    }
}

