/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.model.BaseModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class CollectionUtil
extends CollectionUtils {
    public static final int splitSize = 800;

    public static Collection<String> strToList(String str) {
        return Optional.ofNullable(str).filter(arg0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{arg0})).map(s -> Arrays.asList(StringUtils.split((String)s, (String)",")).stream().distinct().collect(Collectors.toList())).orElse(new ArrayList());
    }

    public static Collection<String> getModelIdsList(Collection<? extends BaseModel> list) {
        return CollectionUtil.getPropertyList(list, BaseModel::getId, "-1");
    }

    public static Collection<String> getItemIdsList(Collection<? extends BaseItem> list) {
        return CollectionUtil.getPropertyList(list, BaseItem::getId, "-1");
    }

    public static String getModelIds(Collection<? extends BaseModel> list) {
        return CollectionUtil.getPropertys(list, BaseModel::getId);
    }

    public static String getItemIds(Collection<? extends BaseItem> list) {
        return CollectionUtil.getPropertys(list, BaseItem::getId);
    }

    public static <T, K> Collection<T> getPropertyList(Collection<K> list, Function<K, T> mapper, T def) {
        return Optional.ofNullable(list).filter(l -> !l.isEmpty()).map(l -> l.stream().map(mapper).filter(Objects::nonNull).distinct().collect(Collectors.toList())).orElseGet(() -> Optional.ofNullable(def).filter(Objects::nonNull).map(Collections::singletonList).orElse(null));
    }

    public static <T, K> List<List<T>> getPropertyList(Collection<K> list, Function<K, T> mapper, int splitSize) {
        Long group = (long)Math.ceil((double)list.size() / (double)splitSize);
        return Stream.iterate(0, n2 -> n2 + splitSize).limit(group).map(i -> list.stream().skip(i.intValue()).limit(splitSize).map(mapper).filter(Objects::nonNull).distinct().collect(Collectors.toList())).collect(Collectors.toList());
    }

    public static <T, K> String getPropertys(Collection<K> list, Function<K, T> mapper) {
        return Optional.ofNullable(list).filter(l -> !l.isEmpty()).map(l -> list.stream().map(mapper).filter(Objects::nonNull).map(String::valueOf).distinct().collect(Collectors.joining(","))).orElse("-1");
    }

    public static <T extends BaseModel> Map<String, T> modelListToIdMap(Collection<T> list) {
        return CollectionUtil.listToKeyMap(list, BaseModel::getId);
    }

    public static <T extends BaseItem> Map<String, T> itemListToIdMap(Collection<T> list) {
        return CollectionUtil.listToKeyMap(list, BaseItem::getId);
    }

    public static <T, K> Map<K, T> listToKeyMap(Collection<T> list, Function<T, K> keyMapper) {
        return Optional.ofNullable(list).filter(l -> !l.isEmpty()).map(l -> l.stream().collect(Collectors.toMap(keyMapper, Function.identity(), (x, y) -> y))).orElse(Collections.emptyMap());
    }

    public static <T, K> Set<K> listToPropertySet(Collection<T> list, Function<T, K> setMapper) {
        return Optional.ofNullable(list).filter(l -> !l.isEmpty()).map(l -> l.stream().map(setMapper).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public static <T> List<List<T>> split(Collection<T> list, int splitSize) {
        Long group = (long)Math.ceil((double)list.size() / (double)splitSize);
        return Stream.iterate(0, n2 -> n2 + splitSize).limit(group).map(i -> list.stream().skip(i.intValue()).limit(splitSize).collect(Collectors.toList())).collect(Collectors.toList());
    }
}

