/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.dao.ext;

import com.zkteco.zkbiosecurity.core.config.DataSourceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;

public class SqlParser {
    private static final List<SelectItem> COUNT_ITEM = new ArrayList<SelectItem>();
    private static final Alias TABLE_ALIAS;

    static {
        COUNT_ITEM.add((SelectItem)new SelectExpressionItem((Expression)new Column("count(0)")));
        TABLE_ALIAS = new Alias("table_count");
        TABLE_ALIAS.setUseAs(false);
    }

    public String getSmartCountSql(String sql) {
        return this.getSmartCountSql(sql, 0L);
    }

    public String getSmartCountSql(String sql, long limit) {
        Statement stmt = null;
        try {
            stmt = CCJSqlParserUtil.parse((String)sql);
        }
        catch (Throwable e) {
            String countSql = this.getSimpleCountSql(sql);
            return countSql;
        }
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        this.processSelectBody(selectBody);
        this.processWithItemsList(select.getWithItemsList());
        if (limit > 0L) {
            this.sqlToCountLimit(select, limit);
        } else {
            this.sqlToCount(select);
        }
        String result = select.toString();
        return result;
    }

    public String getSimpleCountSql(String sql) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(0) from (");
        stringBuilder.append(sql);
        stringBuilder.append(") tmp_count");
        return stringBuilder.toString();
    }

    private List<SelectItem> createSelectItem(Alias alias, String ... columnNames) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        if (Objects.nonNull(columnNames)) {
            String[] stringArray = columnNames;
            int n = columnNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Column column = new Column(name);
                if (Objects.nonNull(alias)) {
                    column.setColumnName(alias + "." + name);
                }
                items.add((SelectItem)new SelectExpressionItem((Expression)column));
                ++n2;
            }
        }
        return items;
    }

    public void sqlToCountLimit(Select select, long limit) {
        SelectBody selectBody = select.getSelectBody();
        String dbType = DataSourceConfig.getDbType();
        if (selectBody instanceof PlainSelect) {
            PlainSelect pSelectBody = (PlainSelect)selectBody;
            Alias alias = pSelectBody.getFromItem().getAlias();
            if ("oracle".equals(dbType)) {
                if (this.isSimpleCount(pSelectBody)) {
                    pSelectBody.setSelectItems(this.createSelectItem(null, "rownum"));
                } else {
                    SubSelect sub = new SubSelect();
                    sub.setSelectBody((SelectBody)pSelectBody);
                    PlainSelect ps = new PlainSelect();
                    ps.setFromItem((FromItem)sub);
                    ps.setSelectItems(this.createSelectItem(null, "rownum"));
                    pSelectBody = ps;
                }
                Expression where = pSelectBody.getWhere();
                if (Objects.isNull(where)) {
                    where = new EqualsTo();
                    ((EqualsTo)where).setLeftExpression((Expression)new LongValue("1"));
                    ((EqualsTo)where).setRightExpression((Expression)new LongValue("1"));
                }
                MinorThanEquals rownumExp = new MinorThanEquals();
                Column rownum = new Column("rownum");
                rownumExp.setLeftExpression((Expression)rownum);
                rownumExp.setRightExpression((Expression)new LongValue(limit));
                AndExpression newWhere = new AndExpression(where, (Expression)rownumExp);
                pSelectBody.setWhere((Expression)newWhere);
            } else if ("sqlserver".equals(dbType)) {
                if (this.isSimpleCount(pSelectBody)) {
                    pSelectBody.setSelectItems(this.createSelectItem(alias, "id"));
                }
                Top top = new Top();
                top.setExpression((Expression)new LongValue(limit));
                pSelectBody.setTop(top);
            } else {
                if (this.isSimpleCount(pSelectBody)) {
                    pSelectBody.setSelectItems(this.createSelectItem(alias, "id"));
                }
                Limit limitExp = new Limit();
                limitExp.setRowCount((Expression)new LongValue(limit));
                pSelectBody.setLimit(limitExp);
            }
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody((SelectBody)pSelectBody);
            subSelect.setAlias(TABLE_ALIAS);
            PlainSelect plainSelect = new PlainSelect();
            plainSelect.setFromItem((FromItem)subSelect);
            plainSelect.setSelectItems(COUNT_ITEM);
            select.setSelectBody((SelectBody)plainSelect);
        }
    }

    public void sqlToCount(Select select) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect && this.isSimpleCount((PlainSelect)selectBody)) {
            ((PlainSelect)selectBody).setSelectItems(COUNT_ITEM);
        } else {
            PlainSelect plainSelect = new PlainSelect();
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody(selectBody);
            subSelect.setAlias(TABLE_ALIAS);
            plainSelect.setFromItem((FromItem)subSelect);
            plainSelect.setSelectItems(COUNT_ITEM);
            select.setSelectBody((SelectBody)plainSelect);
        }
    }

    public boolean isSimpleCount(PlainSelect select) {
        if (select.getGroupBy() != null && select.getGroupBy().getGroupByExpressions() != null) {
            return false;
        }
        if (select.getDistinct() != null) {
            return false;
        }
        for (SelectItem item : select.getSelectItems()) {
            if (item.toString().contains("?")) {
                return false;
            }
            if (!(item instanceof SelectExpressionItem) || !(((SelectExpressionItem)item).getExpression() instanceof Function)) continue;
            return false;
        }
        return true;
    }

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    this.processSelectBody(plainSelect);
                }
            }
            if (!this.orderByHashParameters(operationList.getOrderByElements())) {
                operationList.setOrderByElements(null);
            }
        }
    }

    public void processPlainSelect(PlainSelect plainSelect) {
        if (!this.orderByHashParameters(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem());
            }
        }
    }

    public void processWithItemsList(List<WithItem> withItemsList) {
        if (withItemsList != null && withItemsList.size() > 0) {
            for (WithItem item : withItemsList) {
                this.processSelectBody(item.getSelectBody());
            }
        }
    }

    public void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null) {
                for (Join join : subJoin.getJoinList()) {
                    this.processFromItem(join.getRightItem());
                }
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    public boolean orderByHashParameters(List<OrderByElement> orderByElements) {
        if (orderByElements == null) {
            return false;
        }
        for (OrderByElement orderByElement : orderByElements) {
            if (!orderByElement.toString().contains("?")) continue;
            return true;
        }
        return false;
    }
}

