/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.dao.ext;

import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.core.model.BaseModel;
import com.zkteco.zkbiosecurity.security.SecurityService;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class JpaAspect {
    @Autowired(required=false)
    private SecurityService securityService;

    @Pointcut(value="execution(* com.zkteco.zkbiosecurity..dao..save(..)) || execution(* com.zkteco.zkbiosecurity..dao..saveAndFlush(..)) ")
    public void saveOrUpdate() {
    }

    @Pointcut(value="execution(* com.zkteco.zkbiosecurity.core.dao.BaseDao.saveAll(..)) || execution(* org.springframework.data.repository.CrudRepository.saveAll(..)) || execution(* org.springframework.data.jpa.repository.JpaRepository.saveAll(..)) ")
    public void saveOrUpdateAll() {
    }

    @Around(value="saveOrUpdateAll() && target(tar) && args(entity)")
    public Object aroundSaveAll(ProceedingJoinPoint point, Object tar, Object entity) throws Throwable {
        return this.aroundSave(point, tar, entity);
    }

    @Around(value="saveOrUpdate() && target(tar) && args(entity)")
    public Object aroundSave(ProceedingJoinPoint point, Object tar, Object entity) throws Throwable {
        if (entity instanceof BaseModel) {
            this.updateBaseInfo(entity);
        } else if (entity instanceof Iterable) {
            Iterable iterable = (Iterable)entity;
            for (Object obj : iterable) {
                if (!(obj instanceof BaseModel)) continue;
                this.updateBaseInfo(obj);
            }
        }
        return point.proceed();
    }

    private void updateBaseInfo(Object entity) throws IllegalAccessException, InvocationTargetException {
        SecuritySubject securitySubject;
        String sessionId;
        if (this.securityService != null && (sessionId = JpaAspect.getCurrentSessionId()) != null && (securitySubject = this.securityService.getSecuritySubject(JpaAspect.getCurrentSessionId())) != null) {
            BeanUtils.setProperty((Object)entity, (String)"createrId", (Object)securitySubject.getUserId());
            BeanUtils.setProperty((Object)entity, (String)"createrCode", (Object)securitySubject.getUserCode());
            BeanUtils.setProperty((Object)entity, (String)"createrName", (Object)securitySubject.getUserName());
            BeanUtils.setProperty((Object)entity, (String)"updaterId", (Object)securitySubject.getUserId());
            BeanUtils.setProperty((Object)entity, (String)"updaterCode", (Object)securitySubject.getUserCode());
            BeanUtils.setProperty((Object)entity, (String)"updaterName", (Object)securitySubject.getUserName());
            if (!securitySubject.getIsSuperuser().booleanValue() && StringUtils.isNotBlank((CharSequence)securitySubject.getUserType()) && ("1".equals(securitySubject.getUserType()) || "2".equals(securitySubject.getUserType()) || "3".equals(securitySubject.getUserType()))) {
                BeanUtils.setProperty((Object)entity, (String)"companyId", (Object)securitySubject.getCompanyId());
            }
        }
        BeanUtils.setProperty((Object)entity, (String)"createTime", (Object)new Date());
        BeanUtils.setProperty((Object)entity, (String)"updateTime", (Object)new Date());
    }

    public static String getCurrentSessionId() {
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attrs == null) {
            return null;
        }
        return attrs.getRequest().getSession().getId();
    }
}

