/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.dao.ext;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyChainedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyFieldImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasToBeanExtResultTransformer
extends AliasedTupleSubsetResultTransformer {
    private static final Logger log = LoggerFactory.getLogger(AliasToBeanExtResultTransformer.class);
    private final Class resultClass;
    private boolean isInitialized;
    private String[] aliases;
    private Setter[] setters;

    public AliasToBeanExtResultTransformer(Class resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass cannot be null");
        }
        this.isInitialized = false;
        this.resultClass = resultClass;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        Object result;
        try {
            if (!this.isInitialized) {
                this.initialize(aliases);
            } else {
                this.check(aliases);
            }
            result = this.resultClass.newInstance();
            Field[] fields = this.resultClass.getDeclaredFields();
            HashSet<String> deFields = new HashSet<String>();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Column column = field.getAnnotation(Column.class);
                if (column != null && column.encryptConverter()) {
                    deFields.add(field.getName());
                }
                ++n2;
            }
            int i = 0;
            while (i < aliases.length) {
                if (this.setters[i] != null) {
                    Object value = tuple[i];
                    if (deFields.contains(aliases[i]) && Objects.nonNull(value) && StringUtils.isNotBlank((CharSequence)("" + value))) {
                        try {
                            value = FoldexUtil.decryptByRandomSey((String)("" + value));
                        }
                        catch (Exception e) {
                            log.error("decrypt error ", (Throwable)e);
                        }
                    }
                    this.setters[i].set(result, value, null);
                }
                ++i;
            }
        }
        catch (InstantiationException e) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        return result;
    }

    private void initialize(String[] aliases) {
        PropertyAccessStrategyChainedImpl propertyAccessStrategy = new PropertyAccessStrategyChainedImpl(new PropertyAccessStrategy[]{PropertyAccessStrategyBasicImpl.INSTANCE, PropertyAccessStrategyFieldImpl.INSTANCE, PropertyAccessStrategyMapImpl.INSTANCE});
        this.aliases = new String[aliases.length];
        this.setters = new Setter[aliases.length];
        int i = 0;
        while (i < aliases.length) {
            String alias = aliases[i];
            if (alias != null) {
                this.aliases[i] = alias;
                this.setters[i] = propertyAccessStrategy.buildPropertyAccess(this.resultClass, alias).getSetter();
            }
            ++i;
        }
        this.isInitialized = true;
    }

    private void check(String[] aliases) {
        if (!Arrays.equals(aliases, this.aliases)) {
            throw new IllegalStateException("aliases are different from what is cached; aliases=" + Arrays.asList(aliases) + " cached=" + Arrays.asList(this.aliases));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AliasToBeanExtResultTransformer that = (AliasToBeanExtResultTransformer)((Object)o);
        if (!this.resultClass.equals(that.resultClass)) {
            return false;
        }
        return Arrays.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        int result = this.resultClass.hashCode();
        result = 31 * result + (this.aliases != null ? Arrays.hashCode(this.aliases) : 0);
        return result;
    }
}

