/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.dao;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.core.dao.BaseDao;
import com.zkteco.zkbiosecurity.core.dao.ext.AddScalar;
import com.zkteco.zkbiosecurity.core.dao.ext.AliasToBeanExtResultTransformer;
import com.zkteco.zkbiosecurity.core.dao.ext.SqlParser;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.SQLBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Table;
import org.apache.commons.beanutils.BeanMap;
import org.hibernate.SQLQuery;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class BaseDaoImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BaseDao<T, ID> {
    private final EntityManager entityManager;

    @Override
    public List<T> findByIdList(Collection<ID> ids) {
        Query query = this.entityManager.createQuery("FROM " + this.getDomainClass().getName() + " t WHERE t.id IN (:ids)");
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    @Override
    public List<T> findByIdList(List<ID> ids) {
        Query query = this.entityManager.createQuery("FROM " + this.getDomainClass().getName() + " t WHERE t.id IN (:ids)");
        query.setParameter("ids", ids);
        return query.getResultList();
    }

    public BaseDaoImpl(Class<T> domainClass, EntityManager entityManager) {
        super(domainClass, entityManager);
        this.entityManager = entityManager;
    }

    @Override
    public List getItemsBySql(Class target, String sql) {
        return this.getItemsDataBySql(target, sql, null, true);
    }

    public List getItemsDataBySql(Class target, String sql, Pager pager, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        NativeQuery sqlQuery = this.createSqlQuery(sql);
        if (toItem) {
            AddScalar.addSclar((SQLQuery)sqlQuery, target);
            sqlQuery.setResultTransformer((ResultTransformer)new AliasToBeanExtResultTransformer(target));
        }
        if (pager != null) {
            sqlQuery.setFirstResult(pager.getOffset());
            sqlQuery.setMaxResults(pager.getSize());
        }
        return sqlQuery.list();
    }

    @Override
    public List getItemsDataBySql(Class target, String sql, int beginIndex, int endIndex, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        NativeQuery sqlQuery = this.createSqlQuery(sql);
        if (toItem) {
            AddScalar.addSclar((SQLQuery)sqlQuery, target);
            sqlQuery.setResultTransformer((ResultTransformer)new AliasToBeanExtResultTransformer(target));
        }
        sqlQuery.setFirstResult(beginIndex);
        sqlQuery.setMaxResults(endIndex - beginIndex + 1);
        return sqlQuery.list();
    }

    private NativeQuery createSqlQuery(String sql) {
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        return (NativeQuery)nativeQuery.unwrap(NativeQueryImpl.class);
    }

    @Override
    public List createSqlQueryPage(String sql, int start, int size) {
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        nativeQuery.setFirstResult(start);
        nativeQuery.setMaxResults(size);
        return nativeQuery.getResultList();
    }

    private Query createHqlQuery(String hql) {
        Query query = this.entityManager.createQuery(hql);
        return query;
    }

    @Override
    public List<Object[]> getArrayData(String sql) {
        return this.createSqlQuery(sql).list();
    }

    @Override
    public Pager getItemsBySql(Class target, String sql, int page, int size) {
        return this.getItemsBySql(target, sql, page, size, 0L);
    }

    @Override
    public Pager getItemsBySql(Class target, String sql, int page, int size, long limit) {
        Pager pager = new Pager(page, size);
        pager.setTotal(this.getCountBySql(sql, limit));
        pager.setData(this.getItemsDataBySql(target, sql, pager, true));
        return pager;
    }

    @Override
    public Pager getArrayItemsBySql(Class target, String sql, int page, int size) {
        return this.getArrayItemsBySql(target, sql, page, size, 0L);
    }

    @Override
    public Pager getArrayItemsBySql(Class target, String sql, int page, int size, long limit) {
        Pager pager = new Pager(page, size);
        pager.setTotal(this.getCountBySql(sql, limit));
        pager.setData(this.getItemsDataBySql(target, sql, pager, false));
        return pager;
    }

    @Override
    public Optional<T> findById(ID id) {
        Object t = this.entityManager.find(this.getDomainClass(), id);
        return Optional.ofNullable(t);
    }

    @Override
    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        Optional<T> optional = this.findById(id);
        if (optional.isPresent()) {
            this.delete(optional.get());
        } else {
            new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.getDomainClass(), id), 1);
        }
    }

    public int getCountBySql(String sql) {
        return this.getCountBySql(sql, 0L);
    }

    public int getCountBySql(String sql, long limit) {
        String countSql = new SqlParser().getSmartCountSql(sql, limit);
        try {
            String countNum = this.createSqlQuery(countSql).uniqueResult().toString();
            int count = Integer.valueOf(countNum);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("sql can't be auto count, sql is:" + countSql, e);
        }
    }

    @Override
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        return super.saveAll(entities);
    }

    public void deleteAll() {
        Query query = this.entityManager.createQuery("DELETE FROM " + this.getDomainClass().getName());
        query.executeUpdate();
    }

    @Override
    public void truncateAll() {
        Query query = this.entityManager.createNativeQuery("TRUNCATE TABLE " + this.getDomainClass().getAnnotation(Table.class).name());
        query.executeUpdate();
    }

    @Override
    public T findOne(ID id) {
        return this.findById(id).get();
    }

    @Override
    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        return this.saveAll(entities);
    }

    @Override
    public void delete(Iterable<? extends T> entities) {
        this.deleteAll(entities);
    }

    @Override
    @Transactional
    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        T entity = this.findOne(id);
        if (entity == null) {
            new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.getDomainClass(), id), 1);
        }
        this.delete(entity);
    }

    @Override
    public List<T> findAll(Iterable<ID> ids) {
        return this.findAllById(ids);
    }

    @Override
    public List getItemsBySql(Class target, SQLBean sql) {
        return this.getItemsDataBySql(target, sql, null, true);
    }

    public List getItemsDataBySql(Class target, SQLBean sql, Pager pager, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        NativeQuery sqlQuery = this.createPrePareSqlQuery(sql.getSql(), sql.getList());
        if (toItem) {
            AddScalar.addSclar((SQLQuery)sqlQuery, target);
            sqlQuery.setResultTransformer((ResultTransformer)new AliasToBeanExtResultTransformer(target));
        }
        if (pager != null) {
            sqlQuery.setFirstResult(pager.getOffset());
            sqlQuery.setMaxResults(pager.getSize());
        }
        return sqlQuery.list();
    }

    @Override
    public List getItemsDataBySql(Class target, SQLBean sql, int beginIndex, int endIndex, boolean toItem) {
        Assert.notNull((Object)target, (String)"target class is not null");
        NativeQuery sqlQuery = this.createPrePareSqlQuery(sql.getSql(), sql.getList());
        if (toItem) {
            AddScalar.addSclar((SQLQuery)sqlQuery, target);
            sqlQuery.setResultTransformer((ResultTransformer)new AliasToBeanExtResultTransformer(target));
        }
        sqlQuery.setFirstResult(beginIndex);
        sqlQuery.setMaxResults(endIndex - beginIndex + 1);
        return sqlQuery.list();
    }

    @Override
    public Pager getItemsBySql(Class target, SQLBean sql, int page, int size) {
        return this.getItemsBySql(target, sql, page, size, 0L);
    }

    @Override
    public Pager getItemsBySql(Class target, SQLBean sql, int page, int size, long limit) {
        Pager pager = new Pager(page, size);
        pager.setTotal(this.getCountByPrePareSql(sql, limit));
        pager.setData(this.getItemsDataBySql(target, sql, pager, true));
        return pager;
    }

    public int getCountByPrePareSql(SQLBean sql) {
        return this.getCountByPrePareSql(sql, 0L);
    }

    public int getCountByPrePareSql(SQLBean sql, long limit) {
        String countSql = new SqlParser().getSmartCountSql(sql.getSql(), limit);
        try {
            NativeQuery prePareSqlQuery = this.createPrePareCountSqlQuery(countSql, sql);
            String countNum = prePareSqlQuery.uniqueResult().toString();
            int count = Integer.valueOf(countNum);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("sql can't be auto count, sql is:" + countSql, e);
        }
    }

    private NativeQuery createPrePareSqlQuery(String sql, List<Object> list) {
        sql = sql.replace("#", "?");
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        int i = 0;
        while (i < list.size()) {
            Object param = list.get(i);
            nativeQuery.setParameter(i + 1, param);
            ++i;
        }
        return (NativeQuery)nativeQuery.unwrap(NativeQuery.class);
    }

    private NativeQuery createPrePareCountSqlQuery(String sql, SQLBean sqlBean) {
        List<Object> list = sqlBean.getList();
        ArrayList<Object> removeList = new ArrayList<Object>();
        ArrayList<Object> countList = new ArrayList<Object>(list);
        Map<Integer, Object> valueMap = sqlBean.getValueMap();
        for (Integer index : valueMap.keySet()) {
            Object o = valueMap.get(index);
            if (!list.get(index).equals(o)) continue;
            removeList.add(o);
        }
        countList.removeAll(removeList);
        Query nativeQuery = this.entityManager.createNativeQuery(sql);
        int i = 0;
        while (i < countList.size()) {
            Object param = countList.get(i);
            nativeQuery.setParameter(i + 1, param);
            ++i;
        }
        return (NativeQuery)nativeQuery.unwrap(NativeQuery.class);
    }

    @Override
    public int deleteByExample(T example) {
        Assert.notNull(example, (String)"example must not null");
        BeanMap map = new BeanMap(example);
        StringBuffer hql = new StringBuffer("DELETE FROM " + this.getDomainClass().getSimpleName() + " WHERE 1=1");
        HashMap valMap = new HashMap();
        int index = 0;
        for (Object key : map.keySet()) {
            if (map.get(key) == null || map.get(key) instanceof Collection || "class".equals(key.toString())) continue;
            hql.append(" and " + key.toString() + "=?" + ++index);
            valMap.put(index, map.get(key));
        }
        Query query = this.entityManager.createQuery(hql.toString());
        for (Integer key : valMap.keySet()) {
            query.setParameter(key.intValue(), valMap.get(key));
        }
        return query.executeUpdate();
    }

    @Override
    public T findOneByExample(T example) {
        List<T> list = this.findByExample(example);
        Assert.isTrue((list.size() <= 1 ? 1 : 0) != 0, (String)"example record more than one");
        return CollectionUtil.isEmpty(list) ? null : (T)list.get(0);
    }

    @Override
    public List<T> findByExample(T example) {
        Assert.notNull(example, (String)"example must not null");
        BeanMap map = new BeanMap(example);
        StringBuffer hql = new StringBuffer("FROM " + this.getDomainClass().getSimpleName() + " WHERE 1=1");
        HashMap valMap = new HashMap();
        int index = 0;
        for (Object key : map.keySet()) {
            if (map.get(key) == null || map.get(key) instanceof Collection || "class".equals(key.toString())) continue;
            hql.append(" and " + key.toString() + "=?" + ++index);
            valMap.put(index, map.get(key));
        }
        Query query = this.entityManager.createQuery(hql.toString());
        for (Integer key : valMap.keySet()) {
            query.setParameter(key.intValue(), valMap.get(key));
        }
        return query.getResultList();
    }
}

