/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.mid.service;

import java.util.Map;

public interface BaseDataProcessorService<T> {
    public static final String ADD_PROCESSOR = "add";
    public static final String EDIT_PROCESSOR = "update";
    public static final String DELETE_PROCESSOR = "delete";

    public T limitItem(T var1, String var2);

    public String doAddProcessor(T var1);

    public String doEditProcessor(T var1);

    public String doDeleteProcessor(T var1);

    public Map<String, Map> getAddRules(T var1);

    public Map<String, Map> getEditRules(T var1);

    public Map<String, Map> getDeleteRules(T var1);

    default public String doProcessor(T item, String type) {
        String res = null;
        switch (type) {
            case "add": {
                res = this.doAddProcessor(item);
                break;
            }
            case "update": {
                res = this.doEditProcessor(item);
                break;
            }
            case "delete": {
                res = this.doDeleteProcessor(item);
                break;
            }
            default: {
                return "-99";
            }
        }
        return res;
    }

    default public Map<String, Map> getRules(String processorType, T item) {
        switch (processorType) {
            case "add": {
                return this.getAddRules(item);
            }
            case "update": {
                return this.getEditRules(item);
            }
            case "delete": {
                return this.getDeleteRules(item);
            }
        }
        return null;
    }
}

