/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ad.controller;

import com.zkteco.zkbiosecurity.ad.remote.AdSyncRemote;
import com.zkteco.zkbiosecurity.ad.service.AdFieldMappingService;
import com.zkteco.zkbiosecurity.ad.service.AdParamsService;
import com.zkteco.zkbiosecurity.ad.service.AdSyncService;
import com.zkteco.zkbiosecurity.ad.vo.AdFieldMappingItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdSyncController
extends BaseController
implements AdSyncRemote {
    @Autowired
    private AdParamsService adParamsService;
    @Autowired
    private AdFieldMappingService adFieldMappingService;
    @Autowired
    private AdSyncService adSyncService;

    public ModelAndView index() {
        Map adParams = this.adParamsService.getAdParams();
        this.request.setAttribute("adParams", (Object)adParams);
        List adFieldMappingItems = this.adFieldMappingService.getAllFields();
        ArrayList<AdFieldMappingItem> initFields = new ArrayList<AdFieldMappingItem>();
        ArrayList<AdFieldMappingItem> intiConfigs = new ArrayList<AdFieldMappingItem>();
        ArrayList<AdFieldMappingItem> addFields = new ArrayList<AdFieldMappingItem>();
        for (AdFieldMappingItem item : adFieldMappingItems) {
            if (StringUtils.isNotBlank((CharSequence)item.getInitKey())) {
                initFields.add(item);
                intiConfigs.add(item);
                continue;
            }
            addFields.add(item);
        }
        this.request.setAttribute("initFields", initFields);
        this.request.setAttribute("intiConfigs", intiConfigs);
        this.request.setAttribute("addFields", addFields);
        return new ModelAndView("ad/import/importAD");
    }

    public ZKResultMsg saveParams(@RequestParam Map<String, String> params) {
        this.adParamsService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg importData() {
        String paramDataMap = this.request.getParameter("paramDataMap");
        String syncType = this.request.getParameter("syncType");
        this.adSyncService.syncData(paramDataMap, syncType, Boolean.valueOf(false));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

