/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ad.controller;

import com.zkteco.zkbiosecurity.ad.remote.AdImportRemote;
import com.zkteco.zkbiosecurity.ad.service.AdImportService;
import com.zkteco.zkbiosecurity.ad.vo.AdPropertiesItem;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.PagedResultsControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class AdImportController
extends BaseController
implements AdImportRemote {
    private static final Logger log = LoggerFactory.getLogger(AdImportController.class);
    @Autowired
    private AdImportService adImportService;
    @Autowired
    private ProgressCache progressCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg testConnect() {
        this.progressCache.beginProcess("");
        Context ctx = null;
        String type = this.request.getParameter("type");
        try {
            String serverAddress = this.request.getParameter("serverAddress");
            String userName = this.request.getParameter("userName");
            String userPwd = this.request.getParameter("userPwd");
            String domainNode = this.request.getParameter("domainNode");
            domainNode = domainNode.replaceAll("_", "=");
            ctx = this.adImportService.getADConnect(serverAddress, userName, Base64Util.getFromBase64((String)userPwd));
            if (null != ctx) {
                int pageSize = 1000;
                NamingEnumeration<SearchResult> results = null;
                ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true)});
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                results = "person".equals(type) ? ctx.search(domainNode, "(objectClass=person)", searchControls) : ctx.search(domainNode, "(objectCategory=group)", searchControls);
                results.hasMore();
                this.progressCache.finishProcess(I18nUtil.i18nCode((String)"docking_ad_connectSuccess", (Object[])new Object[0]));
            }
            this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"docking_import_connectFail", (Object[])new Object[0]) + "...</font><br/>");
        }
        catch (Exception e) {
            if ("person".equals(type)) {
                this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"docking_import_domainNodeWrong", (Object[])new Object[0]) + "...</font><br/>");
            }
            this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"docking_import_domainNodeForLevelWrong", (Object[])new Object[0]) + "...</font><br/>");
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception e) {
                    log.error("exception", (Throwable)e);
                }
            }
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
        }
    }

    public ZKResultMsg getAdProperties() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List adPropertiesItems = this.adImportService.getAdProperties();
        for (AdPropertiesItem item : adPropertiesItems) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(item.getAdKey());
            selectItem.setText((Object)I18nUtil.i18nCode((String)item.getText(), (Object[])new Object[0]));
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg getDbFields() {
        List selectItems = this.adImportService.getDbFields();
        return new ZKResultMsg((Object)selectItems);
    }
}

