/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.whatsapp.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.whatsapp.remote.WhatsappParamsRemote;
import com.zkteco.zkbiosecurity.whatsapp.service.WhatsappParamsService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class WhatsappParamsController
extends BaseController
implements WhatsappParamsRemote {
    @Autowired
    private WhatsappParamsService whatsappParamsService;

    @RequiresPermissions(value={"whatsapp:management"})
    public ModelAndView index() {
        Map whatsappMap = this.whatsappParamsService.getWhatsappParams();
        whatsappMap.put("rapiwhaWebhookPath", "/whatsappWebhook/receiveMessage/rapiwha");
        whatsappMap.put("twilioWebhookPath", "/whatsappWebhook/receiveMessage/twilio");
        this.request.setAttribute("whatsappMap", (Object)whatsappMap);
        return new ModelAndView("whatsapp/params/params");
    }

    @RequiresPermissions(value={"whatsapp:management"})
    public ZKResultMsg save(Map<String, String> whatsappParams) {
        ZKResultMsg res = new ZKResultMsg();
        this.whatsappParamsService.saveItem(whatsappParams);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

