/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.init;

import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryItem;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=82)
public class ParkDictionaryInit
implements CommandLineRunner {
    @Autowired
    private BaseDictionaryService baseDictionaryService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("ParkDictionaryInit");
        if (!alreadyInit) {
            BaseDictionaryItem baseDictionaryItem;
            if ("zh_CN".equals(LocaleMessageSourceUtil.language)) {
                baseDictionaryItem = new BaseDictionaryItem("parkProvince", I18nUtil.i18nCode((String)"park_parkingLotSet_province", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
                baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
                for (int i = 0; i < ParkConstants.INIT_PROVINCE_AREAS.length; ++i) {
                    this.baseDictionaryValueService.initData(new BaseDictionaryValueItem(ParkConstants.INIT_PROVINCE_AREAS[i], ParkConstants.INIT_PROVINCE_AREAS[i], Integer.valueOf(i + 1), baseDictionaryItem.getId()));
                }
                baseDictionaryItem = new BaseDictionaryItem("parkThirdPartyProvince", I18nUtil.i18nCode((String)"park_thirdParty_province", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
                baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
                this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DongGuan", I18nUtil.i18nCode((String)"park_thirdParty_province_dongguan", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
                this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("ShangHai", I18nUtil.i18nCode((String)"park_thirdParty_province_shanghai", (Object[])new Object[0]), Integer.valueOf(4), baseDictionaryItem.getId()));
            } else {
                baseDictionaryItem = new BaseDictionaryItem("parkPayType", I18nUtil.i18nCode((String)"park_parkingLotSet_payType", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
                baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
                this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("LinePay", "LinePay", Integer.valueOf(1), baseDictionaryItem.getId()));
                baseDictionaryItem = new BaseDictionaryItem("parkLinePayCurrency", "parkLinePayCurrency", Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
                baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
                this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("THB", "THB", Integer.valueOf(1), baseDictionaryItem.getId()));
                this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("TWD", "TWD", Integer.valueOf(2), baseDictionaryItem.getId()));
                this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("USD", "USD", Integer.valueOf(3), baseDictionaryItem.getId()));
                this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("JPY", "JPY", Integer.valueOf(4), baseDictionaryItem.getId()));
            }
            baseDictionaryItem = new BaseDictionaryItem("parkChannelState", I18nUtil.i18nCode((String)"park_channel_state", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
            baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", I18nUtil.i18nCode((String)"park_channel_stateMaxIn", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", I18nUtil.i18nCode((String)"park_channel_stateMaxOut", (Object[])new Object[0]), Integer.valueOf(2), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", I18nUtil.i18nCode((String)"park_channel_stateMinIn", (Object[])new Object[0]), Integer.valueOf(3), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", I18nUtil.i18nCode((String)"park_channel_stateMinOut", (Object[])new Object[0]), Integer.valueOf(4), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", I18nUtil.i18nCode((String)"park_channel_stateCentralFeePoint", (Object[])new Object[0]), Integer.valueOf(5), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", I18nUtil.i18nCode((String)"park_channel_stateCentralFeeOut", (Object[])new Object[0]), Integer.valueOf(6), baseDictionaryItem.getId()));
            baseDictionaryItem = new BaseDictionaryItem("parkEntryPrecision", I18nUtil.i18nCode((String)"park_parkingLotSet_entryPrecision", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
            baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", I18nUtil.i18nCode((String)"park_parkingLotSet_entryPrecision_all", (Object[])new Object[0]), Integer.valueOf(0), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("7", I18nUtil.i18nCode((String)"park_parkingLotSet_entryPrecision_7", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", I18nUtil.i18nCode((String)"park_parkingLotSet_entryPrecision_6", (Object[])new Object[0]), Integer.valueOf(2), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", I18nUtil.i18nCode((String)"park_parkingLotSet_entryPrecision_5", (Object[])new Object[0]), Integer.valueOf(3), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", I18nUtil.i18nCode((String)"park_parkingLotSet_entryPrecision_4", (Object[])new Object[0]), Integer.valueOf(4), baseDictionaryItem.getId()));
            baseDictionaryItem = new BaseDictionaryItem("parkPlateColor", I18nUtil.i18nCode((String)"park_carNumber_plateColor", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
            baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", I18nUtil.i18nCode((String)"common_unknown", (Object[])new Object[0]), Integer.valueOf(0), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("30", I18nUtil.i18nCode((String)"park_weChatCarNumber_colorBlue", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("20", I18nUtil.i18nCode((String)"park_weChatCarNumber_colorNew", (Object[])new Object[0]), Integer.valueOf(2), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("50", I18nUtil.i18nCode((String)"park_weChatCarNumber_colorYellow", (Object[])new Object[0]), Integer.valueOf(3), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", I18nUtil.i18nCode((String)"park_weChatCarNumber_colorBlack", (Object[])new Object[0]), Integer.valueOf(4), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("255", I18nUtil.i18nCode((String)"park_weChatCarNumber_colorWhite", (Object[])new Object[0]), Integer.valueOf(5), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("40", I18nUtil.i18nCode((String)"park_weChatCarNumber_colorRed", (Object[])new Object[0]), Integer.valueOf(6), baseDictionaryItem.getId()));
            baseDictionaryItem = new BaseDictionaryItem("parkEventType", I18nUtil.i18nCode((String)"park_recordin_eventType", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
            baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", I18nUtil.i18nCode((String)"park_recordin_eventType_normalCard", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", I18nUtil.i18nCode((String)"park_recordin_eventType_fixToTemp", (Object[])new Object[0]), Integer.valueOf(2), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", I18nUtil.i18nCode((String)"park_recordin_eventType_lostCard", (Object[])new Object[0]), Integer.valueOf(3), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", I18nUtil.i18nCode((String)"park_recordin_eventType_overtime", (Object[])new Object[0]), Integer.valueOf(4), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", I18nUtil.i18nCode((String)"park_recordin_eventType_manOpen", (Object[])new Object[0]), Integer.valueOf(5), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", I18nUtil.i18nCode((String)"park_recordin_eventType_cancelOpen", (Object[])new Object[0]), Integer.valueOf(6), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("7", I18nUtil.i18nCode((String)"park_recordin_eventType_monthCard", (Object[])new Object[0]), Integer.valueOf(7), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("8", I18nUtil.i18nCode((String)"park_recordin_eventType_guest", (Object[])new Object[0]), Integer.valueOf(8), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("9", I18nUtil.i18nCode((String)"park_recordin_eventType_correct", (Object[])new Object[0]), Integer.valueOf(9), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("10", I18nUtil.i18nCode((String)"park_recordin_eventType_unmatch", (Object[])new Object[0]), Integer.valueOf(10), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("11", I18nUtil.i18nCode((String)"park_recordin_eventType_perPay", (Object[])new Object[0]), Integer.valueOf(11), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("12", I18nUtil.i18nCode((String)"park_recordin_eventType_payed", (Object[])new Object[0]), Integer.valueOf(12), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("13", I18nUtil.i18nCode((String)"park_recordin_eventType_payedAliPay", (Object[])new Object[0]), Integer.valueOf(13), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("14", I18nUtil.i18nCode((String)"park_recordin_eventType_noEmptySrc", (Object[])new Object[0]), Integer.valueOf(14), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("15", I18nUtil.i18nCode((String)"park_carTeam", (Object[])new Object[0]), Integer.valueOf(15), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("16", I18nUtil.i18nCode((String)"park_doubleVerify_failed", (Object[])new Object[0]), Integer.valueOf(16), baseDictionaryItem.getId()));
            baseDictionaryItem = new BaseDictionaryItem("parkDeviceOption", I18nUtil.i18nCode((String)"park_device_parameter", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
            baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", "supportOffline", Integer.valueOf(1), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", "carteamMode", Integer.valueOf(2), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", "supportForeignOffline", Integer.valueOf(3), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", "recogCarInfo", Integer.valueOf(4), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", "uploadOfflineRecord", Integer.valueOf(5), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", "gateVoiceScreen", Integer.valueOf(6), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("7", "screenType", Integer.valueOf(7), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("8", "carSpace", Integer.valueOf(8), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("9", "supportForeignOfflineAll", Integer.valueOf(9), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("10", "chargeFloat", Integer.valueOf(10), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("11", "secondaryRecognition", Integer.valueOf(11), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("12", "LEDDisplayConfiguration", Integer.valueOf(12), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("13", "keep12", Integer.valueOf(13), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("14", "LPRSyncTime", Integer.valueOf(14), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("15", "closeGate", Integer.valueOf(15), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("16", "keep15", Integer.valueOf(16), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("17", "systemTimeZone", Integer.valueOf(17), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("18", "syncDataBetweenDevices", Integer.valueOf(18), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("19", "supportOfflineCharge", Integer.valueOf(19), baseDictionaryItem.getId()));
            baseDictionaryItem = new BaseDictionaryItem("parkDeviceOpType", I18nUtil.i18nCode((String)"park_device_opType", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
            baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("syncBlack", I18nUtil.i18nCode((String)"park_blackWhite_syncBlack", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("addBlack", I18nUtil.i18nCode((String)"park_blackWhite_addBlack", (Object[])new Object[0]), Integer.valueOf(2), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("delBlack", I18nUtil.i18nCode((String)"park_blackWhite_delBlack", (Object[])new Object[0]), Integer.valueOf(3), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("syncWhite", I18nUtil.i18nCode((String)"park_blackWhite_syncWhite", (Object[])new Object[0]), Integer.valueOf(4), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("addWhite", I18nUtil.i18nCode((String)"park_blackWhite_addWhite", (Object[])new Object[0]), Integer.valueOf(5), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("delWhite", I18nUtil.i18nCode((String)"park_blackWhite_delWhite", (Object[])new Object[0]), Integer.valueOf(6), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("syncAuth", I18nUtil.i18nCode((String)"park_offlineSet_syncAuth", (Object[])new Object[0]), Integer.valueOf(7), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("addAuth", I18nUtil.i18nCode((String)"park_authorize_addAuth", (Object[])new Object[0]), Integer.valueOf(8), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("delAuth", I18nUtil.i18nCode((String)"park_authorize_delAuth", (Object[])new Object[0]), Integer.valueOf(9), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("syncTime", I18nUtil.i18nCode((String)"park_offlineSet_syncTime", (Object[])new Object[0]), Integer.valueOf(10), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("getOption", I18nUtil.i18nCode((String)"park_device_getParameter", (Object[])new Object[0]), Integer.valueOf(11), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("syncParams", I18nUtil.i18nCode((String)"park_offlineSet_syncParams", (Object[])new Object[0]), Integer.valueOf(12), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("syncCharging", I18nUtil.i18nCode((String)"park_offlineSet_syncCharging", (Object[])new Object[0]), Integer.valueOf(13), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("readParams", I18nUtil.i18nCode((String)"park_offlineSet_readParams", (Object[])new Object[0]), Integer.valueOf(14), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("readBlack", I18nUtil.i18nCode((String)"park_offlineSet_readBlack", (Object[])new Object[0]), Integer.valueOf(15), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("readWhite", I18nUtil.i18nCode((String)"park_offlineSet_readWhite", (Object[])new Object[0]), Integer.valueOf(16), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("readAuth", I18nUtil.i18nCode((String)"park_offlineSet_readAuth", (Object[])new Object[0]), Integer.valueOf(17), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("readCharging", I18nUtil.i18nCode((String)"park_offlineSet_readCharging", (Object[])new Object[0]), Integer.valueOf(18), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("readVersion", I18nUtil.i18nCode((String)"park_offlineSet_readVersion", (Object[])new Object[0]), Integer.valueOf(19), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("cleanBlack", I18nUtil.i18nCode((String)"park_offlineSet_cleanBlack", (Object[])new Object[0]), Integer.valueOf(20), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("cleanWhite", I18nUtil.i18nCode((String)"park_offlineSet_cleanWhite", (Object[])new Object[0]), Integer.valueOf(21), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("cleanAuth", I18nUtil.i18nCode((String)"park_offlineSet_cleanAuth", (Object[])new Object[0]), Integer.valueOf(22), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("cleanCharging", I18nUtil.i18nCode((String)"park_offlineSet_cleanCharging", (Object[])new Object[0]), Integer.valueOf(23), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("recovery", I18nUtil.i18nCode((String)"park_offlineSet_recovery", (Object[])new Object[0]), Integer.valueOf(24), baseDictionaryItem.getId()));
            baseDictionaryItem = new BaseDictionaryItem("parkDeviceErrorCode", I18nUtil.i18nCode((String)"park_deviceErrorCode_name", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"park_module", (Object[])new Object[0]));
            baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1022", I18nUtil.i18nCode((String)"park_deviceErrorCode_1022", (Object[])new Object[0]), Integer.valueOf(2), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1021", I18nUtil.i18nCode((String)"park_deviceErrorCode_1021", (Object[])new Object[0]), Integer.valueOf(3), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1020", I18nUtil.i18nCode((String)"park_deviceErrorCode_1020", (Object[])new Object[0]), Integer.valueOf(4), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1019", I18nUtil.i18nCode((String)"park_deviceErrorCode_1019", (Object[])new Object[0]), Integer.valueOf(5), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1018", I18nUtil.i18nCode((String)"park_deviceErrorCode_1018", (Object[])new Object[0]), Integer.valueOf(6), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1017", I18nUtil.i18nCode((String)"park_deviceErrorCode_1017", (Object[])new Object[0]), Integer.valueOf(7), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1016", I18nUtil.i18nCode((String)"park_deviceErrorCode_1016", (Object[])new Object[0]), Integer.valueOf(8), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1015", I18nUtil.i18nCode((String)"park_deviceErrorCode_1015", (Object[])new Object[0]), Integer.valueOf(9), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1014", I18nUtil.i18nCode((String)"park_deviceErrorCode_1014", (Object[])new Object[0]), Integer.valueOf(10), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1013", I18nUtil.i18nCode((String)"park_deviceErrorCode_1013", (Object[])new Object[0]), Integer.valueOf(11), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1012", I18nUtil.i18nCode((String)"park_deviceErrorCode_1012", (Object[])new Object[0]), Integer.valueOf(12), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1011", I18nUtil.i18nCode((String)"park_deviceErrorCode_1011", (Object[])new Object[0]), Integer.valueOf(13), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1010", I18nUtil.i18nCode((String)"park_deviceErrorCode_1010", (Object[])new Object[0]), Integer.valueOf(14), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1009", I18nUtil.i18nCode((String)"park_deviceErrorCode_1009", (Object[])new Object[0]), Integer.valueOf(15), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1008", I18nUtil.i18nCode((String)"park_deviceErrorCode_1008", (Object[])new Object[0]), Integer.valueOf(16), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1007", I18nUtil.i18nCode((String)"park_deviceErrorCode_1007", (Object[])new Object[0]), Integer.valueOf(17), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1006", I18nUtil.i18nCode((String)"park_deviceErrorCode_1006", (Object[])new Object[0]), Integer.valueOf(18), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1005", I18nUtil.i18nCode((String)"park_deviceErrorCode_1005", (Object[])new Object[0]), Integer.valueOf(19), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1004", I18nUtil.i18nCode((String)"park_deviceErrorCode_1004", (Object[])new Object[0]), Integer.valueOf(20), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1003", I18nUtil.i18nCode((String)"park_deviceErrorCode_1003", (Object[])new Object[0]), Integer.valueOf(21), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-998", I18nUtil.i18nCode((String)"park_deviceErrorCode_998", (Object[])new Object[0]), Integer.valueOf(26), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-997", I18nUtil.i18nCode((String)"park_deviceErrorCode_997", (Object[])new Object[0]), Integer.valueOf(27), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-996", I18nUtil.i18nCode((String)"park_deviceErrorCode_996", (Object[])new Object[0]), Integer.valueOf(28), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-995", I18nUtil.i18nCode((String)"park_deviceErrorCode_995", (Object[])new Object[0]), Integer.valueOf(29), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-994", I18nUtil.i18nCode((String)"park_deviceErrorCode_994", (Object[])new Object[0]), Integer.valueOf(30), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-993", I18nUtil.i18nCode((String)"park_deviceErrorCode_993", (Object[])new Object[0]), Integer.valueOf(31), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-992", I18nUtil.i18nCode((String)"park_deviceErrorCode_992", (Object[])new Object[0]), Integer.valueOf(32), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-991", I18nUtil.i18nCode((String)"park_deviceErrorCode_991", (Object[])new Object[0]), Integer.valueOf(33), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-990", I18nUtil.i18nCode((String)"park_deviceErrorCode_990", (Object[])new Object[0]), Integer.valueOf(34), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-989", I18nUtil.i18nCode((String)"park_deviceErrorCode_989", (Object[])new Object[0]), Integer.valueOf(35), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-988", I18nUtil.i18nCode((String)"park_deviceErrorCode_988", (Object[])new Object[0]), Integer.valueOf(36), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-987", I18nUtil.i18nCode((String)"park_deviceErrorCode_987", (Object[])new Object[0]), Integer.valueOf(37), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-986", I18nUtil.i18nCode((String)"park_deviceErrorCode_986", (Object[])new Object[0]), Integer.valueOf(38), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-985", I18nUtil.i18nCode((String)"park_deviceErrorCode_985", (Object[])new Object[0]), Integer.valueOf(39), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-984", I18nUtil.i18nCode((String)"park_deviceErrorCode_984", (Object[])new Object[0]), Integer.valueOf(40), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-983", I18nUtil.i18nCode((String)"park_deviceErrorCode_983", (Object[])new Object[0]), Integer.valueOf(41), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-982", I18nUtil.i18nCode((String)"park_deviceErrorCode_982", (Object[])new Object[0]), Integer.valueOf(42), baseDictionaryItem.getId()));
            this.baseSysParamService.setAlreadyInitModule("ParkDictionaryInit");
        }
    }
}

