/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.List;
import java.util.Map;

@From(after="PSG_TRANSACTION t ")
@OrderBy(after="t.EVENT_TIME DESC")
@GridConfig
public class PsgTransactionItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(width="0", sortNo=0, show=false)
    private String id;
    @Column(name="t.LOG_ID")
    private Integer logId;
    @Column(name="t.EVENT_TIME")
    @GridColumn(label="common_time", width="150")
    private Date eventTime;
    @Column(name="t.AREA_NAME")
    @GridColumn(label="base_area_name")
    private String areaName;
    private String areaId;
    @Column(name="t.DEV_ALIAS")
    @GridColumn(label="common_dev_name", width="120")
    private String devAlias;
    @Column(name="t.EVENT_POINT_NAME")
    @GridColumn(label="common_eventPoint", width="140")
    private String eventPointName;
    @Column(name="t.GATE_TYPE")
    @GridColumn(label="psg_device_gateType", format="0=,1=psg_device_threeRollerGate,2=psg_device_wingGate,3=psg_device_swingGate", width="125")
    private Short gateType;
    @Column(name="t.PASSAGE_NAME")
    @GridColumn(label="psg_passage_name", width="125")
    private String passageName;
    @Column(name="t.EVENT_NAME", equalTag="in")
    @GridColumn(label="common_eventDescription", width="125", i18n=true, sort="na")
    private String eventName;
    @Column(name="t.VID_LINKAGE_HANDLE")
    @GridColumn(label="common_mediaFile", width="100", columnType="custom", convert="convertPsgVidLinkage", sort="na", isExportExcel=false)
    private String vidLinkageHandle;
    @Column(name="t.EVENT_NO")
    @GridColumn(label="psg_transaction_personTrends", width="100", columnType="custom", sort="na", convert="convertPsgPersonTrends", showHeader="psgShowPersonTrends", isExportExcel=false)
    private String personTrends;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Condition(value="t.PIN", equalTag="=")
    private String pinEqual;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Column(name="t.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", width="100", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="pers_dept_deptNo")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pers_dept_deptName")
    private String deptName;
    @Column(name="t.READER_NAME")
    @GridColumn(label="psg_readerDefine_readerName", width="100")
    private String readerName;
    @Column(name="t.VERIFY_MODE_NAME", equalTag="in")
    @GridColumn(label="common_verifyMode_entiy", width="100", i18n=true, sort="na")
    private String verifyModeName;
    @Column(name="t.DESCRIPTION")
    private String description;
    @Column(name="t.DEV_ID")
    private String devId;
    @Column(name="t.DEV_SN")
    private String devSn;
    @Condition(value="t.DEV_SN", equalTag="=")
    private String devSnEqual;
    @Column(name="t.VERIFY_MODE_NO")
    private Short verifyModeNo;
    @Column(name="t.EVENT_NO")
    private Short eventNo;
    @Column(name="t.EVENT_POINT_TYPE")
    private Short eventPointType;
    @Column(name="t.EVENT_POINT_ID")
    private String eventPointId;
    @Column(name="t.READER_STATE")
    private Short readerState;
    @Column(name="t.TRIGGER_COND")
    private Short triggerCond;
    @Column(name="t.EVENT_ADDR")
    private Short eventAddr;
    @Column(name="t.UNIQUE_KEY")
    private String uniqueKey;
    @Condition(value="t.EVENT_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.EVENT_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="t.READER_NAME", equalTag="in")
    private String inReaderName;
    @Condition(value="t.EVENT_NO", equalTag="in")
    private String inEventNo;
    @Condition(value="t.EVENT_NO", equalTag="not in")
    private String notInEventNo;
    @Column(name="t.EVENT_POINT_ID", equalTag="in")
    private String inEventPointId;
    @Condition(value="t.CREATE_TIME", equalTag=">=")
    private Date startCreateTime;
    @Condition(value="t.CREATE_TIME", equalTag="<=")
    private Date endCreateTime;
    @Column(name="t.CREATE_TIME")
    private Date createTime;
    private Integer eventLevel;
    private String audioFilePath;
    private Integer captureTime;
    private String readerId;
    private Object vidLinkageData;
    private Object vidLinkageFilePathData;
    protected List<Map<String, Object>> vidDevices;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.AREA_NAME", equalTag="in")
    private String areaNameIn;
    @Condition(value="(t.EVENT_NO >= 100 and t.EVENT_NO < 200 OR t.EVENT_NO = 28 OR t.EVENT_NO >= ''{0}'')")
    private String eventAlarmCondition;
    @Condition(value="(t.DEPT_CODE in (%s) or t.DEPT_CODE is null or t.DEPT_CODE = '')", formatType="quote")
    private String deptCodeIn;
    @Condition(value="(t.DEPT_CODE IN (select ud.code from auth_department ud where ud.id in(select aud.auth_dept_id from auth_user_dept aud where aud.auth_user_id = ''{0}'')) or t.DEPT_CODE is null or t.DEPT_CODE = '''')")
    private String deptCodeInByUserId;
    @Condition(value="t.AREA_NAME IN (select aa.name from auth_area aa where aa.id in(select aua.auth_area_id from auth_user_area aua where aua.auth_user_id = ''{0}''))")
    private String areaNameByUserId;

    public PsgTransactionItem() {
    }

    public PsgTransactionItem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Integer getLogId() {
        return this.logId;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getEventPointName() {
        return this.eventPointName;
    }

    public Short getGateType() {
        return this.gateType;
    }

    public String getPassageName() {
        return this.passageName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getVidLinkageHandle() {
        return this.vidLinkageHandle;
    }

    public String getPersonTrends() {
        return this.personTrends;
    }

    public String getPin() {
        return this.pin;
    }

    public String getPinEqual() {
        return this.pinEqual;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public String getVerifyModeName() {
        return this.verifyModeName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDevId() {
        return this.devId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getDevSnEqual() {
        return this.devSnEqual;
    }

    public Short getVerifyModeNo() {
        return this.verifyModeNo;
    }

    public Short getEventNo() {
        return this.eventNo;
    }

    public Short getEventPointType() {
        return this.eventPointType;
    }

    public String getEventPointId() {
        return this.eventPointId;
    }

    public Short getReaderState() {
        return this.readerState;
    }

    public Short getTriggerCond() {
        return this.triggerCond;
    }

    public Short getEventAddr() {
        return this.eventAddr;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getInReaderName() {
        return this.inReaderName;
    }

    public String getInEventNo() {
        return this.inEventNo;
    }

    public String getNotInEventNo() {
        return this.notInEventNo;
    }

    public String getInEventPointId() {
        return this.inEventPointId;
    }

    public Date getStartCreateTime() {
        return this.startCreateTime;
    }

    public Date getEndCreateTime() {
        return this.endCreateTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Integer getEventLevel() {
        return this.eventLevel;
    }

    public String getAudioFilePath() {
        return this.audioFilePath;
    }

    public Integer getCaptureTime() {
        return this.captureTime;
    }

    public String getReaderId() {
        return this.readerId;
    }

    public Object getVidLinkageData() {
        return this.vidLinkageData;
    }

    public Object getVidLinkageFilePathData() {
        return this.vidLinkageFilePathData;
    }

    public List<Map<String, Object>> getVidDevices() {
        return this.vidDevices;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getAreaNameIn() {
        return this.areaNameIn;
    }

    public String getEventAlarmCondition() {
        return this.eventAlarmCondition;
    }

    public String getDeptCodeIn() {
        return this.deptCodeIn;
    }

    public String getDeptCodeInByUserId() {
        return this.deptCodeInByUserId;
    }

    public String getAreaNameByUserId() {
        return this.areaNameByUserId;
    }

    public PsgTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public PsgTransactionItem setLogId(Integer logId) {
        this.logId = logId;
        return this;
    }

    public PsgTransactionItem setEventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public PsgTransactionItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public PsgTransactionItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public PsgTransactionItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PsgTransactionItem setEventPointName(String eventPointName) {
        this.eventPointName = eventPointName;
        return this;
    }

    public PsgTransactionItem setGateType(Short gateType) {
        this.gateType = gateType;
        return this;
    }

    public PsgTransactionItem setPassageName(String passageName) {
        this.passageName = passageName;
        return this;
    }

    public PsgTransactionItem setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public PsgTransactionItem setVidLinkageHandle(String vidLinkageHandle) {
        this.vidLinkageHandle = vidLinkageHandle;
        return this;
    }

    public PsgTransactionItem setPersonTrends(String personTrends) {
        this.personTrends = personTrends;
        return this;
    }

    public PsgTransactionItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PsgTransactionItem setPinEqual(String pinEqual) {
        this.pinEqual = pinEqual;
        return this;
    }

    public PsgTransactionItem setName(String name) {
        this.name = name;
        return this;
    }

    public PsgTransactionItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PsgTransactionItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PsgTransactionItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PsgTransactionItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PsgTransactionItem setReaderName(String readerName) {
        this.readerName = readerName;
        return this;
    }

    public PsgTransactionItem setVerifyModeName(String verifyModeName) {
        this.verifyModeName = verifyModeName;
        return this;
    }

    public PsgTransactionItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public PsgTransactionItem setDevId(String devId) {
        this.devId = devId;
        return this;
    }

    public PsgTransactionItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PsgTransactionItem setDevSnEqual(String devSnEqual) {
        this.devSnEqual = devSnEqual;
        return this;
    }

    public PsgTransactionItem setVerifyModeNo(Short verifyModeNo) {
        this.verifyModeNo = verifyModeNo;
        return this;
    }

    public PsgTransactionItem setEventNo(Short eventNo) {
        this.eventNo = eventNo;
        return this;
    }

    public PsgTransactionItem setEventPointType(Short eventPointType) {
        this.eventPointType = eventPointType;
        return this;
    }

    public PsgTransactionItem setEventPointId(String eventPointId) {
        this.eventPointId = eventPointId;
        return this;
    }

    public PsgTransactionItem setReaderState(Short readerState) {
        this.readerState = readerState;
        return this;
    }

    public PsgTransactionItem setTriggerCond(Short triggerCond) {
        this.triggerCond = triggerCond;
        return this;
    }

    public PsgTransactionItem setEventAddr(Short eventAddr) {
        this.eventAddr = eventAddr;
        return this;
    }

    public PsgTransactionItem setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
        return this;
    }

    public PsgTransactionItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PsgTransactionItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public PsgTransactionItem setInReaderName(String inReaderName) {
        this.inReaderName = inReaderName;
        return this;
    }

    public PsgTransactionItem setInEventNo(String inEventNo) {
        this.inEventNo = inEventNo;
        return this;
    }

    public PsgTransactionItem setNotInEventNo(String notInEventNo) {
        this.notInEventNo = notInEventNo;
        return this;
    }

    public PsgTransactionItem setInEventPointId(String inEventPointId) {
        this.inEventPointId = inEventPointId;
        return this;
    }

    public PsgTransactionItem setStartCreateTime(Date startCreateTime) {
        this.startCreateTime = startCreateTime;
        return this;
    }

    public PsgTransactionItem setEndCreateTime(Date endCreateTime) {
        this.endCreateTime = endCreateTime;
        return this;
    }

    public PsgTransactionItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PsgTransactionItem setEventLevel(Integer eventLevel) {
        this.eventLevel = eventLevel;
        return this;
    }

    public PsgTransactionItem setAudioFilePath(String audioFilePath) {
        this.audioFilePath = audioFilePath;
        return this;
    }

    public PsgTransactionItem setCaptureTime(Integer captureTime) {
        this.captureTime = captureTime;
        return this;
    }

    public PsgTransactionItem setReaderId(String readerId) {
        this.readerId = readerId;
        return this;
    }

    public PsgTransactionItem setVidLinkageData(Object vidLinkageData) {
        this.vidLinkageData = vidLinkageData;
        return this;
    }

    public PsgTransactionItem setVidLinkageFilePathData(Object vidLinkageFilePathData) {
        this.vidLinkageFilePathData = vidLinkageFilePathData;
        return this;
    }

    public PsgTransactionItem setVidDevices(List<Map<String, Object>> vidDevices) {
        this.vidDevices = vidDevices;
        return this;
    }

    public PsgTransactionItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PsgTransactionItem setAreaNameIn(String areaNameIn) {
        this.areaNameIn = areaNameIn;
        return this;
    }

    public PsgTransactionItem setEventAlarmCondition(String eventAlarmCondition) {
        this.eventAlarmCondition = eventAlarmCondition;
        return this;
    }

    public PsgTransactionItem setDeptCodeIn(String deptCodeIn) {
        this.deptCodeIn = deptCodeIn;
        return this;
    }

    public PsgTransactionItem setDeptCodeInByUserId(String deptCodeInByUserId) {
        this.deptCodeInByUserId = deptCodeInByUserId;
        return this;
    }

    public PsgTransactionItem setAreaNameByUserId(String areaNameByUserId) {
        this.areaNameByUserId = areaNameByUserId;
        return this;
    }
}

