/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PSG_READER t LEFT JOIN PSG_GATE pd ON pd.ID = t.GATE_ID LEFT JOIN PSG_DEVICE dev ON dev.ID = pd.DEV_ID ")
@OrderBy(after="dev.BUSINESS_ID ASC, t.READER_NO ASC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=450, operates={@GridOperate(type="edit", permission="psg:reader:edit", url="/psgReader.do?edit", label="common_op_edit"), @GridOperate(type="custom", permission="psg:reader:bindChannel", filter="psgShowBindChannel", click="psgReaderCheckChannel", label="common_vid_bindOrUnbindChannel")})
public class PsgReaderItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", show=false)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(label="psg_readerDefine_readerName", width="150", columnType="edit", editUrl="/psgReader.do?edit", editPermission="psg:reader:edit")
    private String name;
    @Column(name="t.GATE_ID")
    @GridColumn(label="psg_gate_id", show=false)
    private String gateId;
    @Column(name="pd.NAME")
    @GridColumn(label="psg_gate_name", width="150")
    private String gateName;
    @Column(name="t.READER_NO")
    @GridColumn(label="common_number")
    private Short readerNo;
    @Column(name="t.READER_STATE")
    @GridColumn(label="psg_reader_inout", format="0=common_in,1=common_out")
    private Short readerState;
    @Column(name="t.ID")
    private String channelId;
    @GridColumn(label="psg_common_boundChannel", width="250", sort="na", showHeader="psgShowBindChannel")
    private String channelName;
    @Condition(value="dev.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notId;
    @Column(name="dev.SN")
    private String deviceSn;
    @Condition(value="dev.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String deviceId;

    public PsgReaderItem() {
    }

    public PsgReaderItem(Boolean equals) {
        super(equals);
    }

    public PsgReaderItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PsgReaderItem(String id, String name, Short readerNo, Short readerState) {
        this.id = id;
        this.name = name;
        this.readerNo = readerNo;
        this.readerState = readerState;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getGateId() {
        return this.gateId;
    }

    public String getGateName() {
        return this.gateName;
    }

    public Short getReaderNo() {
        return this.readerNo;
    }

    public Short getReaderState() {
        return this.readerState;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotId() {
        return this.notId;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public PsgReaderItem setId(String id) {
        this.id = id;
        return this;
    }

    public PsgReaderItem setName(String name) {
        this.name = name;
        return this;
    }

    public PsgReaderItem setGateId(String gateId) {
        this.gateId = gateId;
        return this;
    }

    public PsgReaderItem setGateName(String gateName) {
        this.gateName = gateName;
        return this;
    }

    public PsgReaderItem setReaderNo(Short readerNo) {
        this.readerNo = readerNo;
        return this;
    }

    public PsgReaderItem setReaderState(Short readerState) {
        this.readerState = readerState;
        return this;
    }

    public PsgReaderItem setChannelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    public PsgReaderItem setChannelName(String channelName) {
        this.channelName = channelName;
        return this;
    }

    public PsgReaderItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public PsgReaderItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public PsgReaderItem setNotId(String notId) {
        this.notId = notId;
        return this;
    }

    public PsgReaderItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public PsgReaderItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PsgReaderItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }
}

