/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="PSG_DEVICE t LEFT JOIN PSG_PASSAGE pp ON pp.ID = t.PASSAGE_ID LEFT JOIN AUTH_AREA a ON a.id = t.auth_area_id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=430, winWidth=500, operates={@GridOperate(type="edit", permission="psg:device:edit", url="/psgDevice.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="psg:device:del", url="/psgDevice.do?delete", label="common_op_del")})
public class PsgDeviceItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.DEVICE_ALIAS")
    @GridColumn(columnType="edit", label="common_dev_name", width="140", editPermission="psg:device:edit", editUrl="/psgDevice.do?edit")
    private String alias;
    @Column(name="t.SN")
    @GridColumn(label="common_dev_sn", width="120")
    private String sn;
    @Column(name="t.AUTH_AREA_ID")
    private String authAreaId;
    @Column(name="a.NAME")
    @GridColumn(label="base_area_name", width="100")
    private String authAreaName;
    @Column(name="t.PASSAGE_ID")
    private String passageId;
    @Column(name="pp.NAME")
    @GridColumn(label="psg_passage_name", width="100")
    private String passageName;
    @Column(name="t.GATE_TYPE")
    @GridColumn(label="psg_device_gateType", width="100", format="0=,1=psg_device_threeRollerGate,2=psg_device_wingGate,3=psg_device_swingGate")
    private String gateType;
    @Column(name="t.COMM_TYPE")
    @GridColumn(label="common_dev_commType", format="1=TCP/IP,2=RS485,3=HTTP")
    private String commType;
    @Column(name="t.IP_ADDRESS")
    @GridColumn(label="common_ipAddress", width="130")
    private String ipAddress;
    @GridColumn(label="common_status", width="60", columnType="custom", convert="convertConnectState")
    private String connectState;
    @Column(name="t.ENABLED")
    private Boolean enabled;
    @Column(name="t.DEVICE_NAME")
    @GridColumn(label="common_dev_deviceModel", width="100")
    private String deviceName;
    @Column(name="t.FW_VERSION")
    @GridColumn(label="common_dev_firmwareVersion", width="100")
    private String fwVersion;
    @Column(name="t.IS_REGISTRATIONDEVICE")
    @GridColumn(label="psg_dev_registrationDevice", width="60", convert="convertToIcon", columnType="custom")
    private Boolean isRegistrationDevice;
    @Column(name="t.ID", equalTag="in")
    private String ids;
    @Column(name="t.IP_PORT")
    private Integer ipPort;
    @Column(name="t.COMM_PWD", encryptConverter=true)
    private String commPwd;
    @Column(name="t.TIME_ZONE")
    private String timeZone;
    @Column(name="t.DSTIME_ID")
    private String psgDSTimeId;
    @Column(name="t.MACHINE_TYPE")
    private Short machineType;
    @Column(name="t.SUBNET_MASK")
    private String subnetMask;
    @Column(name="t.GATEWAY")
    private String gateway;
    @Condition(value="t.ID IN (%s)", formatType="quote")
    private String devIdIn;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    private Long cmdCount;
    @Condition(value="t.AUTH_AREA_ID IN (SELECT ud.AUTH_AREA_ID FROM AUTH_USER_AREA ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.SN", equalTag="in")
    private String snIn;
    @Condition(value="t.SN", equalTag="not in")
    private String snsNotIn;

    public PsgDeviceItem() {
    }

    public PsgDeviceItem(Boolean equals) {
        super(equals);
    }

    public PsgDeviceItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSn() {
        return this.sn;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getPassageId() {
        return this.passageId;
    }

    public String getPassageName() {
        return this.passageName;
    }

    public String getGateType() {
        return this.gateType;
    }

    public String getCommType() {
        return this.commType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getConnectState() {
        return this.connectState;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getFwVersion() {
        return this.fwVersion;
    }

    public Boolean getIsRegistrationDevice() {
        return this.isRegistrationDevice;
    }

    public String getIds() {
        return this.ids;
    }

    public Integer getIpPort() {
        return this.ipPort;
    }

    public String getCommPwd() {
        return this.commPwd;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getPsgDSTimeId() {
        return this.psgDSTimeId;
    }

    public Short getMachineType() {
        return this.machineType;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getDevIdIn() {
        return this.devIdIn;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public Long getCmdCount() {
        return this.cmdCount;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSnIn() {
        return this.snIn;
    }

    public String getSnsNotIn() {
        return this.snsNotIn;
    }

    public PsgDeviceItem setId(String id) {
        this.id = id;
        return this;
    }

    public PsgDeviceItem setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public PsgDeviceItem setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public PsgDeviceItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public PsgDeviceItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public PsgDeviceItem setPassageId(String passageId) {
        this.passageId = passageId;
        return this;
    }

    public PsgDeviceItem setPassageName(String passageName) {
        this.passageName = passageName;
        return this;
    }

    public PsgDeviceItem setGateType(String gateType) {
        this.gateType = gateType;
        return this;
    }

    public PsgDeviceItem setCommType(String commType) {
        this.commType = commType;
        return this;
    }

    public PsgDeviceItem setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public PsgDeviceItem setConnectState(String connectState) {
        this.connectState = connectState;
        return this;
    }

    public PsgDeviceItem setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PsgDeviceItem setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public PsgDeviceItem setFwVersion(String fwVersion) {
        this.fwVersion = fwVersion;
        return this;
    }

    public PsgDeviceItem setIsRegistrationDevice(Boolean isRegistrationDevice) {
        this.isRegistrationDevice = isRegistrationDevice;
        return this;
    }

    public PsgDeviceItem setIds(String ids) {
        this.ids = ids;
        return this;
    }

    public PsgDeviceItem setIpPort(Integer ipPort) {
        this.ipPort = ipPort;
        return this;
    }

    public PsgDeviceItem setCommPwd(String commPwd) {
        this.commPwd = commPwd;
        return this;
    }

    public PsgDeviceItem setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public PsgDeviceItem setPsgDSTimeId(String psgDSTimeId) {
        this.psgDSTimeId = psgDSTimeId;
        return this;
    }

    public PsgDeviceItem setMachineType(Short machineType) {
        this.machineType = machineType;
        return this;
    }

    public PsgDeviceItem setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
        return this;
    }

    public PsgDeviceItem setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    public PsgDeviceItem setDevIdIn(String devIdIn) {
        this.devIdIn = devIdIn;
        return this;
    }

    public PsgDeviceItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public PsgDeviceItem setCmdCount(Long cmdCount) {
        this.cmdCount = cmdCount;
        return this;
    }

    public PsgDeviceItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PsgDeviceItem setSnIn(String snIn) {
        this.snIn = snIn;
        return this;
    }

    public PsgDeviceItem setSnsNotIn(String snsNotIn) {
        this.snsNotIn = snsNotIn;
        return this;
    }
}

