/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.web.listener;

import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
public class SystemParamsInitListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(SystemParamsInitListener.class);
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Value(value="${system.customDateFormat:false}")
    private Boolean customDateFormat;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        log.info("Init custom date format...");
        WebApplicationContext webApplicationContext = (WebApplicationContext)event.getApplicationContext();
        ServletContext servletContext = webApplicationContext.getServletContext();
        if (this.customDateFormat.booleanValue()) {
            try {
                BaseSysParamItem dateItem = this.baseSysParamService.findByParamName("system.fmt.date");
                BaseSysParamItem timeItem = this.baseSysParamService.findByParamName("system.fmt.time");
                String dateFmt = dateItem.getParamValue();
                String timeFmt = timeItem.getParamValue();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dateFmt, timeFmt})) {
                    DateUtil.CustomDateStyle d = DateUtil.CustomDateStyle.valueOf((String)dateFmt);
                    DateUtil.CustomDateStyle t = DateUtil.CustomDateStyle.valueOf((String)timeFmt);
                    servletContext.setAttribute("date.dhxDateFmt", (Object)d.getDhxFmt());
                    servletContext.setAttribute("date.dhxTimeFmt", (Object)t.getDhxFmt());
                    servletContext.setAttribute("biosecurity.date.sysDateFmt.alias", (Object)d.getJavaFmt());
                    servletContext.setAttribute("biosecurity.date.sysTimeFmt.alias", (Object)t.getJavaFmt());
                    servletContext.setAttribute("biosecurity.date.sysDateTimeFmt.alias", (Object)(String.valueOf(d.getJavaFmt()) + " " + t.getJavaFmt()));
                }
            }
            catch (Exception e) {
                log.error("Init custom date format failed", (Throwable)e);
            }
        }
    }
}

