/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.utils;

import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.FileType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class BaseMediaFileUtil {
    public static final String HTTPMARK = "http://";
    public static final String SOUNDPREPATH = "/upload/audio";
    public static final long MAXFILESIZE = 0xA00000L;

    public static String getLocalUrl() throws Exception {
        String projectPath = BaseMediaFileUtil.class.getClassLoader().getResource("").getPath();
        projectPath = String.valueOf(projectPath) + "../../";
        projectPath = projectPath.replace("/", "\\");
        String realpath = URLDecoder.decode(projectPath, "UTF-8");
        return realpath;
    }

    public static void deleteFile(String filePath) throws Exception {
        File existFile = new File(filePath);
        existFile.delete();
    }

    public static void saveFile(String fileName, MultipartFile uploadFile, String systemFilePath) throws Exception {
        File eventSoundFile;
        String realSoundPath = String.valueOf(systemFilePath) + SOUNDPREPATH;
        File eventSoundFilePath = new File(realSoundPath);
        if (!eventSoundFilePath.isAbsolute()) {
            realSoundPath = String.valueOf(ClassUtil.getRootPath()) + "/" + realSoundPath;
            eventSoundFilePath = new File(realSoundPath);
        }
        if (!eventSoundFilePath.exists()) {
            eventSoundFilePath.mkdirs();
        }
        if ((eventSoundFile = new File(String.valueOf(realSoundPath) + "/" + fileName)).exists()) {
            eventSoundFile.delete();
        }
        uploadFile.transferTo(eventSoundFile);
    }

    public static String saveFileToServer(String fileType, MultipartFile file, String systemFilePath) throws Exception {
        String fileName = "";
        boolean isMediaFile = false;
        try {
            InputStream inputStream;
            if (fileType.toLowerCase().contains("mp3") || fileType.toLowerCase().contains("mpeg")) {
                isMediaFile = BaseMediaFileUtil.isMp3Media(file);
                if (isMediaFile) {
                    fileName = String.valueOf(System.currentTimeMillis()) + ".mp3";
                }
            } else if (fileType.toLowerCase().contains("wav") && (isMediaFile = BaseMediaFileUtil.isWavMedia(inputStream = file.getInputStream()))) {
                fileName = String.valueOf(System.currentTimeMillis()) + ".wav";
            }
            if (StringUtils.isNotBlank((CharSequence)fileName)) {
                BaseMediaFileUtil.saveFile(fileName, file, systemFilePath);
                fileName = "/upload/audio/" + fileName;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public static String getNewFileName(String fileName) {
        int lastIndex = fileName.lastIndexOf(".");
        fileName = String.valueOf(fileName.substring(0, lastIndex)) + "-" + System.currentTimeMillis() + fileName.substring(lastIndex);
        return fileName;
    }

    public static String getFileSize(MultipartFile file) throws Exception {
        DecimalFormat df = new DecimalFormat("#.##");
        String fileSiz = file.getSize() / 1024L > 1000L ? String.valueOf(df.format((double)file.getSize() / 1024.0 / 1024.0)) + "MB" : String.valueOf(df.format(file.getSize() / 1024L)) + "KB";
        return fileSiz;
    }

    public static boolean validatorFileSize(MultipartFile file) {
        boolean flag = true;
        if (file.getSize() > 0L && file.getSize() < 0xA00000L) {
            flag = false;
        }
        return flag;
    }

    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        try (FileOutputStream out = null;){
            out = BaseMediaFileUtil.openOutputStream(file, false);
            ((OutputStream)out).write(data.getBytes(encoding));
        }
    }

    private static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static boolean isWavMedia(InputStream inputStream) {
        FileType fileType = BaseMediaFileUtil.getFileType(inputStream);
        if (ObjectUtils.isEmpty((Object)fileType)) {
            return false;
        }
        return fileType.equals((Object)FileType.WAV);
    }

    public static FileType getFileType(InputStream is) {
        try {
            byte[] buffer = new byte[12];
            is.read(buffer, 0, 12);
            StringBuilder stringBuilder = new StringBuilder("");
            if (buffer != null && buffer.length > 0) {
                int i = 8;
                while (i < buffer.length) {
                    int v = buffer[i] & 0xFF;
                    String hv = Integer.toHexString(v).toUpperCase();
                    if (hv.length() < 2) {
                        stringBuilder.append(0);
                    }
                    stringBuilder.append(hv);
                    ++i;
                }
                if (stringBuilder.toString().startsWith(FileType.WAV.getValue())) {
                    FileType fileType = FileType.WAV;
                    return fileType;
                }
                return null;
            }
            return null;
        }
        catch (IOException var20) {
            var20.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException var19) {
                    var19.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean isMp3Media(MultipartFile file) {
        try {
            byte[] buf = new byte[1024];
            InputStream is = file.getInputStream();
            is.read(buf, 0, 3);
            String tag = new String(buf, 0, 3);
            if ("ID3".equalsIgnoreCase(tag)) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

