/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheFtpUtil {
    private static final Logger log = LoggerFactory.getLogger(ApacheFtpUtil.class);
    private FTPClient ftpClient = new FTPClient();

    public ApacheFtpUtil(String hostName, int port, String userName, String password) throws IOException {
        this.ftpClient.setDefaultTimeout(20000);
        this.ftpClient.setConnectTimeout(10000);
        this.ftpClient.setDataTimeout(15000);
        this.ftpClient.connect(hostName, port);
        this.ftpClient.login(userName, password);
        this.ftpClient.enterLocalPassiveMode();
    }

    public Pair<Boolean, String> downloadFile(String ftpFilePath, String fileName, HttpServletResponse response) {
        InputStream input = null;
        OutputStream out = null;
        try {
            int len;
            this.ftpClient.setFileTransferMode(10);
            this.ftpClient.setFileType(2);
            this.ftpClient.changeWorkingDirectory(ftpFilePath);
            FTPFile[] files = this.ftpClient.listFiles();
            if (files.length < 1) {
                Pair pair = Pair.of((Object)false, (Object)"base_db_backupFileNotExist");
                return pair;
            }
            boolean fileExist = false;
            boolean downloadFlag = false;
            FTPFile[] fTPFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile ftpFile = fTPFileArray[n2];
                String ftpFileName = new String(ftpFile.getName().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
                if (fileName.equals(ftpFileName)) {
                    fileExist = true;
                    downloadFlag = true;
                    break;
                }
                ++n2;
            }
            if (!fileExist) {
                Pair pair = Pair.of((Object)false, (Object)"base_db_backupFileNotExist");
                return pair;
            }
            response.reset();
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
            input = this.ftpClient.retrieveFileStream(new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
            out = response.getOutputStream();
            byte[] bytes = new byte[1024];
            while ((len = input.read(bytes)) != -1) {
                out.write(bytes, 0, len);
            }
            out.flush();
            Pair pair = Pair.of((Object)downloadFlag, (Object)(downloadFlag ? "common_op_succeed" : "common_op_failed"));
            return pair;
        }
        catch (IOException e) {
            e.printStackTrace();
            Pair pair = Pair.of((Object)false, (Object)"common_op_failed");
            return pair;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        try {
            if (this.ftpClient != null && this.ftpClient.isConnected()) {
                this.ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

