/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.SystemServerInfoRemote;
import com.zkteco.zkbiosecurity.system.service.SystemServerInfoService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class SystemServerInfoController
implements SystemServerInfoRemote {
    @Autowired
    private SystemServerInfoService systemServerInfoService;

    @RequiresPermissions(value={"system:info"})
    public ModelAndView index() {
        return new ModelAndView("system/serverInfo/serverInfo");
    }

    public Map getInfo() {
        try {
            HashMap allInfo = new HashMap(5);
            Map cpuAndWork = this.systemServerInfoService.getCpuAndNetWorkInfo();
            allInfo.put("cpu", cpuAndWork.get("cpu"));
            allInfo.put("net", cpuAndWork.get("net"));
            allInfo.put("pc", this.systemServerInfoService.getMemoryInfo());
            allInfo.put("jvm", this.systemServerInfoService.getJvmMemoryInfo());
            allInfo.put("system", this.systemServerInfoService.getSystemInfo());
            allInfo.put("thread", this.systemServerInfoService.getThreadInfo());
            return allInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map getRedisInfo() {
        return this.systemServerInfoService.getRedisInfo();
    }
}

