/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.utils.PropertiesUtil;
import com.zkteco.zkbiosecurity.system.remote.SystemPolicyRemote;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SystemPolicyController
extends BaseController
implements SystemPolicyRemote {
    @Value(value="${system.policy.productLogos:images/policy/policy_img1.png}")
    private String policyProLogos;

    public ModelAndView policy() {
        this.request.setAttribute("policyProLogos", Arrays.asList(this.policyProLogos.split(",")));
        return new ModelAndView("system/basepolicy/policy");
    }

    public ModelAndView userPolicy(String view, String loginType) {
        return new ModelAndView("system/baseuserpolicy/userpolicy");
    }

    public ModelAndView productPolicy() {
        String lang = this.request.getParameter("language");
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = PropertiesUtil.getCurrentLanguage();
        }
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            lang = lang.replace("-", "_");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"zh_CN", (CharSequence)lang)) {
            return new ModelAndView("system/basepolicy/englishServicePolicy");
        }
        return new ModelAndView("system/basepolicy/chineseServicePolicy");
    }
}

