/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.remote.SystemForgetPasswordRemote;
import com.zkteco.zkbiosecurity.system.service.SystemForgetPasswordService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SystemForgetPasswordController
extends BaseController
implements SystemForgetPasswordRemote {
    @Autowired
    SystemForgetPasswordService systemForgetPasswordService;
    @Value(value="${system.enableRTL:false}")
    private boolean enableRTL;
    private static Pattern MAIL_PATTERN = Pattern.compile("\\S*@\\S*.\\S*");

    public ModelAndView index(String view, String loginType) {
        loginType = this.defaultIfBlank(loginType);
        this.addRequestParams(view, loginType);
        ModelAndView modelAndView = new ModelAndView(this.systemForgetPasswordService.selectViewByType(view));
        return modelAndView;
    }

    public ZKResultMsg sendMailCode(String user, String mail, String loginType) {
        loginType = this.defaultIfBlank(loginType);
        String errMess = this.verifySendParams(user, mail);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMess})) {
            return ZKResultMsg.failMsg((String)errMess, (Object[])new Object[0]);
        }
        if (this.systemForgetPasswordService.userAndEmailCheck(user, mail, loginType)) {
            return this.systemForgetPasswordService.sendVerityCodeToMail(mail, user, loginType);
        }
        return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_mail_returnMsg6", (Object[])new Object[0]), (Object[])new Object[0]);
    }

    public ZKResultMsg checkEmail(String user, String mail, String checkCode, String loginType) {
        if (!this.systemForgetPasswordService.userEmailCodeCheck(user, checkCode)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_login_captchaError", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        return ZKResultMsg.successMsg();
    }

    public ModelAndView verifyEmail(String user, String mail, String checkCode, String view, String loginType) {
        loginType = this.defaultIfBlank(loginType);
        this.addRequestParams(view, loginType);
        this.request.setAttribute("username", (Object)user);
        String errMess = this.verifySendParams(user, mail);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMess})) {
            this.request.setAttribute("mess", (Object)errMess);
            return new ModelAndView(this.systemForgetPasswordService.selectViewByType(view));
        }
        if (this.systemForgetPasswordService.userEmailCodeCheck(user, checkCode)) {
            this.request.setAttribute("pwdMessNo", (Object)this.systemForgetPasswordService.getSystemPwdStrengthLevel());
            this.request.setAttribute("account", (Object)checkCode);
            return new ModelAndView(this.systemForgetPasswordService.selectViewByType(view));
        }
        this.request.setAttribute("mess", (Object)I18nUtil.i18nCode((String)"auth_login_captchaError", (Object[])new Object[0]));
        return new ModelAndView(this.systemForgetPasswordService.selectViewByType(view));
    }

    public ModelAndView resetPassword(String userName, String account, String password, String view, String loginType) {
        loginType = this.defaultIfBlank(loginType);
        this.addRequestParams(view, loginType);
        if (this.systemForgetPasswordService.userEmailCodeCheck(userName, account)) {
            if (StringUtils.isBlank((CharSequence)password)) {
                this.request.setAttribute("title", (Object)I18nUtil.i18nCode((String)"auth_mail_error", (Object[])new Object[0]));
                this.request.setAttribute("mess", (Object)I18nUtil.i18nCode((String)"auth_mail_modifyFail", (Object[])new Object[0]));
                return new ModelAndView(this.systemForgetPasswordService.selectViewByType(view));
            }
            ZKResultMsg res = this.systemForgetPasswordService.changePassword(account, password, loginType);
            if (res.isSuccess()) {
                this.request.setAttribute("title", (Object)I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]));
            } else {
                this.request.setAttribute("title", (Object)I18nUtil.i18nCode((String)"auth_mail_error", (Object[])new Object[0]));
            }
            this.request.setAttribute("mess", (Object)I18nUtil.i18nCode((String)res.getMsg(), (Object[])new Object[0]));
            return new ModelAndView(this.systemForgetPasswordService.selectViewByType(view));
        }
        this.request.setAttribute("title", (Object)I18nUtil.i18nCode((String)"auth_mail_error", (Object[])new Object[0]));
        this.request.setAttribute("mess", (Object)I18nUtil.i18nCode((String)"auth_mail_linkNoUse", (Object[])new Object[0]));
        return new ModelAndView(this.systemForgetPasswordService.selectViewByType(view));
    }

    public ZKResultMsg resetPws(String user, String pws, String verifyCode) {
        if (!this.systemForgetPasswordService.userEmailCodeCheck(user, verifyCode)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_mail_linkNoUse", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)pws)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_mail_modifyFail", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        ZKResultMsg res = this.systemForgetPasswordService.changePassword(verifyCode, pws, "");
        if (res.isSuccess()) {
            return ZKResultMsg.successMsg();
        }
        return res;
    }

    public void addRequestParams(String view, String loginType) {
        this.request.setAttribute("loginType", (Object)loginType);
        this.request.setAttribute("enableRTL", (Object)this.enableRTL);
        this.request.setAttribute("view", (Object)view);
    }

    public String defaultIfBlank(String loginType) {
        return StringUtils.isBlank((CharSequence)loginType) ? "NORMAL" : loginType;
    }

    private String verifySendParams(String user, String mail) {
        if (StringUtils.isBlank((CharSequence)user)) {
            return I18nUtil.i18nCode((String)"auth_login_userNotNull", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)mail)) {
            return I18nUtil.i18nCode((String)"auth_user_emailNotNull", (Object[])new Object[0]);
        }
        if (!this.isMail(mail)) {
            return I18nUtil.i18nCode((String)"auth_mail_mailError", (Object[])new Object[0]);
        }
        return null;
    }

    private boolean isMail(String mail) {
        Matcher m = MAIL_PATTERN.matcher(mail);
        return m.matches();
    }
}

