/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.SystemAcmsRemote;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.SystemAcmsService;
import com.zkteco.zkbiosecurity.system.vo.SystemAcmsItem;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SystemAcmsController
extends BaseController
implements SystemAcmsRemote {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private SystemAcmsService systemAcmsService;

    @RequiresPermissions(value={"system:acms"})
    public ModelAndView index() {
        Map acmsParams = this.baseSysParamService.getParamsByModule("acms");
        this.request.setAttribute("acmsParams", (Object)acmsParams);
        return new ModelAndView("system/acms/editAcms");
    }

    @RequiresPermissions(value={"system:acms:edit"})
    public ZKResultMsg save(Map<String, String> params) {
        this.baseSysParamService.saveParams(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkConnect() {
        String address = this.request.getParameter("address");
        String companyCode = this.request.getParameter("companyCode");
        String username = this.request.getParameter("userName");
        String pwd = this.request.getParameter("pwd");
        SystemAcmsItem item = new SystemAcmsItem(address, companyCode, username, pwd);
        return this.systemAcmsService.checkConnect(item);
    }
}

