/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseTimeSegRemote;
import com.zkteco.zkbiosecurity.system.service.BaseTimeSegService;
import com.zkteco.zkbiosecurity.system.vo.BaseTimeSegItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseTimeSegController
extends BaseController
implements BaseTimeSegRemote {
    @Autowired
    private BaseTimeSegService baseTimeSegService;

    @RequiresPermissions(value={"base:timeseg"})
    public ModelAndView index() {
        return new ModelAndView("system/baseTimeseg/baseTimeSeg");
    }

    @RequiresPermissions(value={"base:timeseg:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.baseTimeSegService.getItemById(id));
        }
        return new ModelAndView("system/baseTimeseg/editBaseTimeSeg");
    }

    @RequiresPermissions(value={"base:timeseg:edit"})
    public ZKResultMsg save(BaseTimeSegItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.baseTimeSegService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"base:timeseg:refresh"})
    public DxGrid list(BaseTimeSegItem codition) {
        Pager pager = this.baseTimeSegService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"base:timeseg:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.baseTimeSegService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public String isExist(String name) {
        return String.valueOf(this.baseTimeSegService.getItemByName(name) == null);
    }
}

