/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseRegisterRemote;
import com.zkteco.zkbiosecurity.system.service.BaseRegisterService;
import com.zkteco.zkbiosecurity.system.vo.BaseRegisterItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseRegisterController
extends BaseController
implements BaseRegisterRemote {
    @Autowired
    private BaseRegisterService baseRegisterService;

    @RequiresPermissions(value={"base:register"})
    public ModelAndView index() {
        return new ModelAndView("system/register/baseRegister");
    }

    @RequiresPermissions(value={"base:register:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            BaseRegisterItem item = this.baseRegisterService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("system/register/editBaseRegister");
    }

    @LogRequest(module="system_module", object="base_client_register", opType="common_op_add", requestParams={"clientName"}, opContent="base_client_name")
    @RequiresPermissions(value={"base:register:add"})
    public ZKResultMsg save(BaseRegisterItem item) {
        this.baseRegisterService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"base:register:refresh"})
    public DxGrid list(BaseRegisterItem codition) {
        Pager pager = this.baseRegisterService.getItemFilterByLicense(codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="system_module", object="base_client_register", opType="common_op_del", requestParams={"clientName"}, opContent="base_client_name")
    @RequiresPermissions(value={"base:register:del"})
    public ZKResultMsg delete(String ids) {
        this.baseRegisterService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @LogRequest(module="system_module", object="base_client_register", opType="common_op_reset", requestParams={"clientName"}, opContent="base_client_name")
    @RequiresPermissions(value={"base:register:reset"})
    public ZKResultMsg reset(String ids) {
        this.baseRegisterService.reset(ids);
        return ZKResultMsg.successMsg();
    }

    public boolean isExist(String registrationCode) {
        return this.baseRegisterService.isExist(registrationCode);
    }

    public ZKResultMsg loadClientType() {
        return null;
    }

    public ModelAndView getQrcodeById(String id) {
        BaseRegisterItem baseRegisterItem = this.baseRegisterService.getItemById(id);
        this.request.setAttribute("registrationCode", (Object)baseRegisterItem.getRegistrationCode());
        return new ModelAndView("system/register/opBaseRegisterQrCode");
    }

    public ZKResultMsg getRegistrationCodeList() {
        String clientType = this.request.getParameter("clientType");
        return new ZKResultMsg((Object)this.baseRegisterService.getRegistrationCodeList(clientType));
    }

    public ZKResultMsg getLicenseMsg() {
        String moduleName = this.request.getParameter("moduleName");
        return this.baseRegisterService.getLicenseMsg(moduleName);
    }

    public ZKResultMsg isActivationRegistCode() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String registrationCode = this.request.getParameter("registrationCode");
        String clientType = this.request.getParameter("clientType");
        Boolean flag = this.baseRegisterService.activationRegCode(clientType, registrationCode, Short.valueOf((short)1));
        if (!flag.booleanValue()) {
            zkResultMsg.setRet("fail");
        }
        return zkResultMsg;
    }

    public ZKResultMsg isCertLicensed() {
        String clientTypeStr = this.request.getParameter("clientTypeStr");
        String certType = this.request.getParameter("certType");
        return this.baseRegisterService.isCertLicensed(clientTypeStr, certType);
    }

    public ZKResultMsg getRegistClientList(boolean showAppRegistClient) {
        return new ZKResultMsg((Object)this.baseRegisterService.getRegistClientList(Boolean.valueOf(showAppRegistClient)));
    }
}

